/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;

public class Connection {
    private static final byte NEWLINE = 10;
    private IServerConnection serverConnection;
    private ICVSRepositoryLocation fCVSRoot;
    private String fCVSRootDirectory;
    private boolean fIsEstablished;
    private InputStream fResponseStream;
    private byte[] readLineBuffer = new byte[256];

    public Connection(ICVSRepositoryLocation cvsroot, IServerConnection serverConnection) {
        this.fCVSRoot = cvsroot;
        this.serverConnection = serverConnection;
    }

    private static byte[] append(byte[] buffer, int index, byte b) {
        if (index >= buffer.length) {
            byte[] newBuffer = new byte[index * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        buffer[index] = b;
        return buffer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws CVSException {
        if (!this.isEstablished()) {
            return;
        }
        try {
            try {
                this.serverConnection.close();
            }
            catch (IOException ex) {
                if (CVSProviderPlugin.getPlugin().isDebugging()) {
                    CVSProviderPlugin.log((CoreException)((Object)new CVSCommunicationException(Policy.bind("Connection.cannotClose"), ex)));
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fResponseStream = null;
            this.fIsEstablished = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fResponseStream = null;
            this.fIsEstablished = false;
            return;
        }
    }

    public void flush() throws CVSException {
        if (!this.isEstablished()) {
            return;
        }
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new CVSCommunicationException(e);
        }
    }

    public OutputStream getOutputStream() throws CVSException {
        if (!this.isEstablished()) {
            return null;
        }
        return this.serverConnection.getOutputStream();
    }

    public InputStream getInputStream() throws CVSException {
        if (!this.isEstablished()) {
            return null;
        }
        if (this.fResponseStream == null) {
            this.fResponseStream = this.serverConnection.getInputStream();
        }
        return this.fResponseStream;
    }

    public boolean isEstablished() {
        return this.fIsEstablished;
    }

    public void open(IProgressMonitor monitor) throws CVSException {
        if (this.isEstablished()) {
            return;
        }
        try {
            this.serverConnection.open(monitor);
        }
        catch (IOException e) {
            throw new CVSCommunicationException(e);
        }
        this.fIsEstablished = true;
    }

    public String readLine() throws CVSException {
        if (!this.isEstablished()) {
            throw new CVSCommunicationException(Policy.bind("Connection.readUnestablishedConnection"));
        }
        try {
            int r;
            InputStream in = this.getInputStream();
            int index = 0;
            while ((r = in.read()) != -1) {
                if (r == 10) break;
                this.readLineBuffer = Connection.append(this.readLineBuffer, index++, (byte)r);
            }
            String result = new String(this.readLineBuffer, 0, index);
            if (Policy.DEBUG_CVS_PROTOCOL) {
                System.out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new CVSCommunicationException(e);
        }
    }

    static String readLine(InputStream in) throws IOException {
        int r;
        byte[] buffer = new byte[256];
        int index = 0;
        while ((r = in.read()) != -1) {
            if (r == 10) break;
            buffer = Connection.append(buffer, index++, (byte)r);
        }
        String result = new String(buffer, 0, index);
        if (Policy.DEBUG_CVS_PROTOCOL) {
            System.out.println(result);
        }
        return result;
    }

    public void write(String s) throws CVSException {
        this.write(s.getBytes(), false);
    }

    public void write(byte[] b, int off, int len) throws CVSException {
        this.write(b, off, len, false);
    }

    public void writeLine(String s) throws CVSException {
        this.write(s.getBytes(), true);
    }

    public void writeLine(byte[] b, int off, int len) throws CVSException {
        this.write(b, off, len, true);
    }

    void write(byte[] bytes, boolean newLine) throws CVSException {
        this.write(bytes, 0, bytes.length, newLine);
    }

    void write(byte[] b, int off, int len, boolean newline) throws CVSException {
        if (!this.isEstablished()) {
            throw new CVSCommunicationException(Policy.bind("Connection.writeUnestablishedConnection"));
        }
        if (Policy.DEBUG_CVS_PROTOCOL) {
            System.out.print(String.valueOf(new String(b, off, len)) + (newline ? "\n" : ""));
        }
        try {
            OutputStream out = this.getOutputStream();
            out.write(b, off, len);
            if (newline) {
                out.write(10);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new CVSCommunicationException(e);
        }
    }
}

