/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.core.connection.Connection;
import org.eclipse.team.internal.ccvs.core.connection.PServerConnectionMethod;
import org.eclipse.team.internal.ccvs.core.connection.UserInfo;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;

public class CVSRepositoryLocation
extends PlatformObject
implements ICVSRepositoryLocation,
IUserInfo {
    public static final int UNDETERMINED_PLATFORM = 0;
    public static final int CVS_SERVER = 1;
    public static final int CVSNT_SERVER = 2;
    public static final int UNSUPPORTED_SERVER = 3;
    public static final int UNKNOWN_SERVER = 4;
    private static IUserAuthenticator authenticator;
    private static IConnectionMethod[] pluggedInConnectionMethods;
    private IConnectionMethod method;
    private String user;
    private String password;
    private String host;
    private int port;
    private String root;
    private boolean userFixed;
    private boolean passwordFixed;
    private int serverPlatform = 0;
    public static final char COLON = ':';
    public static final char HOST_SEPARATOR = '@';
    public static final char PORT_SEPARATOR = '#';
    public static final boolean STANDALONE_MODE;
    private static final String INVOKE_SVR_CMD = "server";
    public static final String INFO_PASSWORD = "org.eclipse.team.cvs.core.password";
    public static final String INFO_USERNAME = "org.eclipse.team.cvs.core.username";
    public static final String AUTH_SCHEME = "";
    public static final URL FAKE_URL;
    public static final String USER_VARIABLE = "{user}";
    public static final String PASSWORD_VARIABLE = "{password}";
    public static final String HOST_VARIABLE = "{host}";
    public static final String PORT_VARIABLE = "{port}";
    private String readLocation;
    private String writeLocation;

    static {
        pluggedInConnectionMethods = null;
        STANDALONE_MODE = System.getProperty("eclipse.cvs.standalone") == null ? false : new Boolean(System.getProperty("eclipse.cvs.standalone"));
        URL temp = null;
        try {
            temp = new URL("http://org.eclipse.team.cvs.core");
        }
        catch (MalformedURLException malformedURLException) {}
        FAKE_URL = temp;
    }

    private CVSRepositoryLocation(IConnectionMethod method, String user, String password, String host, int port, String root, boolean userFixed, boolean passwordFixed) {
        this.method = method;
        this.user = user;
        this.password = password;
        this.host = host;
        this.port = port;
        this.root = root;
        if (userFixed && user != null) {
            this.userFixed = true;
        }
        if (userFixed && passwordFixed && password != null) {
            this.passwordFixed = true;
        }
    }

    private Connection createConnection(String password, IProgressMonitor monitor) throws CVSException {
        Connection connection = new Connection(this, this.method.createConnection(this, password));
        connection.open(monitor);
        return connection;
    }

    public void dispose() throws CVSException {
        this.flushCache();
    }

    private void flushCache() throws CVSException {
        try {
            Platform.flushAuthorizationInfo((URL)FAKE_URL, (String)this.getLocation(), (String)AUTH_SCHEME);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
            throw new CVSException(4, 4, Policy.bind("CVSRepositoryLocation.errorFlushing", this.getLocation()), e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getLocation() {
        return this.getLocation(false);
    }

    public String getLocation(boolean forDisplay) {
        return String.valueOf(':') + this.method.getName() + ':' + (this.userFixed ? String.valueOf(this.user) + (this.passwordFixed && !forDisplay ? String.valueOf(':') + this.password : AUTH_SCHEME) + '@' : AUTH_SCHEME) + this.host + ':' + (this.port == 0 ? AUTH_SCHEME : new Integer(this.port).toString()) + this.root;
    }

    public IConnectionMethod getMethod() {
        return this.method;
    }

    public boolean setMethod(String methodName) {
        IConnectionMethod newMethod = CVSRepositoryLocation.getPluggedInConnectionMethod(methodName);
        if (newMethod == null) {
            return false;
        }
        this.method = newMethod;
        return true;
    }

    public int getPort() {
        return this.port;
    }

    public ICVSRemoteResource[] members(CVSTag tag, boolean modules, IProgressMonitor progress) throws CVSException {
        try {
            if (modules) {
                return RemoteModule.getRemoteModules(this, tag, progress);
            }
            RemoteFolder root = new RemoteFolder(null, this, AUTH_SCHEME, tag);
            ICVSRemoteResource[] resources = (ICVSRemoteResource[])root.members(progress);
            ArrayList<ICVSRemoteResource> folders = new ArrayList<ICVSRemoteResource>(resources.length);
            int i = 0;
            while (i < resources.length) {
                ICVSRemoteResource remoteResource = resources[i];
                if (remoteResource.isContainer()) {
                    folders.add(remoteResource);
                }
                ++i;
            }
            return folders.toArray(new ICVSRemoteResource[folders.size()]);
        }
        catch (TeamException e) {
            throw new CVSException(e.getStatus());
        }
    }

    public ICVSRemoteFolder getRemoteFolder(String remotePath, CVSTag tag) {
        return new RemoteFolder(null, this, remotePath, tag);
    }

    public ICVSRemoteFile getRemoteFile(String remotePath, CVSTag tag) {
        Path path = new Path(remotePath);
        RemoteFolderTree remoteFolder = new RemoteFolderTree(null, this, path.removeLastSegments(1).toString(), tag);
        RemoteFile remoteFile = new RemoteFile(remoteFolder, 1, path.lastSegment(), null, null, tag);
        remoteFolder.setChildren(new ICVSRemoteResource[]{remoteFile});
        return remoteFile;
    }

    public String getRootDirectory() {
        return this.root;
    }

    public int getTimeout() {
        return CVSProviderPlugin.getPlugin().getTimeout();
    }

    public IUserInfo getUserInfo(boolean makeUsernameMutable) {
        return new UserInfo(this.getUsername(), this.password, makeUsernameMutable ? true : this.isUsernameMutable());
    }

    public String getUsername() {
        if (this.user == null && this.isUsernameMutable()) {
            try {
                this.retrievePassword();
            }
            catch (CVSException cVSException) {}
        }
        return this.user == null ? AUTH_SCHEME : this.user;
    }

    public boolean isUsernameMutable() {
        return !this.userFixed;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Connection openConnection(IProgressMonitor monitor) throws CVSException {
        block12: {
            block11: {
                try {
                    monitor.beginTask(Policy.bind("CVSRepositoryLocation.openingConnection", this.getHost()), 2);
                    if (this.user != null && this.password != null) {
                        var7_2 = this.createConnection(this.password, monitor);
                        var5_4 = null;
                        break block11;
                    }
                    CVSProviderPlugin.getPlugin().getRepository(this.getLocation());
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        try {
                            password = this.retrievePassword();
                            if (this.user == null) {
                                throw new CVSAuthenticationException((IStatus)new CVSStatus(4, Policy.bind("CVSRepositoryLocation.usernameRequired")));
                            }
                            if (password == null) {
                                password = "";
                            }
                            var7_3 = this.createConnection(password, monitor);
                            break block12;
                        }
                        catch (CVSAuthenticationException ex) {
                            message = ex.getMessage();
                            try {
                                authenticator = CVSRepositoryLocation.getAuthenticator();
                                if (authenticator == null) {
                                    throw new CVSAuthenticationException(this.getLocation(), Policy.bind("Client.noAuthenticator"));
                                }
                                authenticator.promptForUserInfo(this, this, message);
                                this.updateCache();
                                continue;
                            }
                            catch (OperationCanceledException v0) {
                                throw new CVSAuthenticationException((IStatus)new CVSStatus(4, message));
                            }
                        }
                        break;
                    }
                }
                catch (Throwable var6_11) {
                    var5_6 = null;
                    monitor.done();
                    throw var6_11;
                }
                {
                    ** while (true)
                }
            }
            monitor.done();
            return var7_2;
        }
        var5_5 = null;
        monitor.done();
        return var7_3;
    }

    public String toString() {
        return this.getLocation(true);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSRepositoryLocation)) {
            return false;
        }
        return this.getLocation().equals(((CVSRepositoryLocation)o).getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    private String retrievePassword() throws CVSException {
        Map map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)this.getLocation(), (String)AUTH_SCHEME);
        if (map != null) {
            String password;
            String username = (String)map.get(INFO_USERNAME);
            if (username != null && this.isUsernameMutable()) {
                this.setUsername(username);
            }
            if ((password = (String)map.get(INFO_PASSWORD)) != null) {
                return password;
            }
        }
        return null;
    }

    public void setPassword(String password) {
        if (this.passwordFixed) {
            throw new UnsupportedOperationException();
        }
        this.password = password;
    }

    public void setUserInfo(IUserInfo userinfo) {
        this.user = userinfo.getUsername();
        this.password = ((UserInfo)userinfo).getPassword();
    }

    public void setUsername(String user) {
        if (this.userFixed) {
            throw new UnsupportedOperationException();
        }
        this.user = user;
    }

    public void setUserMuteable(boolean muteable) {
        this.userFixed = !muteable;
    }

    public void updateCache() throws CVSException {
        if (this.passwordFixed) {
            return;
        }
        this.updateCache(this.user, this.password, true);
        this.password = null;
        CVSProviderPlugin.getPlugin().getRepository(this.getLocation());
    }

    private void updateCache(String username, String password, boolean createIfAbsent) throws CVSException {
        HashMap<String, String> map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)this.getLocation(), (String)AUTH_SCHEME);
        if (map == null) {
            if (!createIfAbsent) {
                return;
            }
            map = new HashMap<String, String>(10);
        }
        if (username != null) {
            map.put(INFO_USERNAME, username);
        }
        if (password != null) {
            map.put(INFO_PASSWORD, password);
        }
        try {
            Platform.addAuthorizationInfo((URL)FAKE_URL, (String)this.getLocation(), (String)AUTH_SCHEME, map);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
            throw new CVSException(4, 4, Policy.bind("CVSRepositoryLocation.errorCaching", this.getLocation()), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateConnection(IProgressMonitor monitor) throws CVSException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            Session session = new Session(this, root, false);
            session.open(Policy.subMonitorFor(monitor, 50), false);
            try {
                IStatus status = Command.VERSION.execute(session, this, Policy.subMonitorFor(monitor, 50));
                if (!status.isOK()) {
                    CVSProviderPlugin.log(status);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                session.close();
                monitor.done();
                throw throwable;
            }
            {
                Object var5_8 = null;
                session.close();
            }
            monitor.done();
            if (this.getServerPlatform() != 2) return;
            if (!this.getRootDirectory().startsWith("/")) return;
            CVSProviderPlugin.log(2, Policy.bind("CVSRepositoryLocation.cvsntPrefix", this.getLocation()), null);
            throw new CVSAuthenticationException((IStatus)new Status(2, "org.eclipse.team.cvs.core", 0, Policy.bind("CVSRepositoryLocation.cvsntPrefix", this.getLocation()), null));
        }
        catch (CVSException e) {
            this.dispose();
            throw e;
        }
    }

    public int getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlaform(IStatus status) {
        if (status.isOK()) {
            this.serverPlatform = 1;
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus iStatus = children[i];
                if (iStatus.getCode() == -21 || iStatus.getCode() == -20 || iStatus.getCode() == -22) {
                    status = iStatus;
                    break;
                }
                ++i;
            }
        }
        switch (status.getCode()) {
            case -21: {
                this.serverPlatform = 2;
                break;
            }
            case -20: {
                this.serverPlatform = 3;
                break;
            }
            case -22: {
                this.serverPlatform = 4;
                break;
            }
            default: {
                this.serverPlatform = 0;
            }
        }
    }

    public static boolean validateConnectionMethod(String methodName) {
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static CVSRepositoryLocation fromProperties(Properties configuration) throws CVSException {
        String host;
        IConnectionMethod method;
        String connection = configuration.getProperty("connection");
        if (connection == null) {
            connection = "pserver";
        }
        if ((method = CVSRepositoryLocation.getPluggedInConnectionMethod(connection)) == null) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSRepositoryLocation.methods", new Object[]{CVSRepositoryLocation.getPluggedInConnectionMethodNames()}), null));
        }
        String user = configuration.getProperty("user");
        if (user.length() == 0) {
            user = null;
        }
        String password = configuration.getProperty("password");
        if (user == null) {
            password = null;
        }
        if ((host = configuration.getProperty("host")) == null) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSRepositoryLocation.hostRequired"), null));
        }
        String portString = configuration.getProperty("port");
        int port = portString == null ? 0 : Integer.parseInt(portString);
        String root = configuration.getProperty("root");
        if (root == null) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSRepositoryLocation.rootRequired"), null));
        }
        root = root.replace('\\', '/');
        return new CVSRepositoryLocation(method, user, password, host, port, root, user != null, false);
    }

    public static CVSRepositoryLocation fromString(String location) throws CVSException {
        try {
            return CVSRepositoryLocation.fromString(location, false);
        }
        catch (CVSException e) {
            MultiStatus error = new MultiStatus("org.eclipse.team.cvs.core", 4, Policy.bind("CVSRepositoryLocation.invalidFormat", new Object[]{location}), null);
            error.merge((IStatus)new CVSStatus(4, Policy.bind("CVSRepositoryLocation.locationForm")));
            error.merge(e.getStatus());
            throw new CVSException((IStatus)error);
        }
    }

    public static CVSRepositoryLocation fromString(String location, boolean validateOnly) throws CVSException {
        String partId = null;
        try {
            String methodName;
            int end;
            partId = "CVSRepositoryLocation.parsingMethod";
            int start = location.indexOf(58);
            if (start == 0) {
                end = location.indexOf(58, start + 1);
                methodName = location.substring(start + 1, end);
                start = end + 1;
            } else {
                methodName = "ext";
                start = 0;
            }
            IConnectionMethod method = CVSRepositoryLocation.getPluggedInConnectionMethod(methodName);
            if (method == null) {
                throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSRepositoryLocation.methods", new Object[]{CVSRepositoryLocation.getPluggedInConnectionMethodNames()})));
            }
            partId = "CVSRepositoryLocation.parsingUser";
            end = location.indexOf(64, start);
            String user = null;
            String password = null;
            if (end != -1) {
                user = location.substring(start, end);
                if ((start = user.indexOf(58)) != -1) {
                    partId = "CVSRepositoryLocation.parsingPassword";
                    password = user.substring(start + 1);
                    user = user.substring(0, start);
                }
                start = end + 1;
            }
            partId = "CVSRepositoryLocation.parsingHost";
            end = location.indexOf(58, start);
            String host = location.substring(start, end);
            int port = 0;
            start = host.indexOf(35);
            if (start != -1) {
                partId = "CVSRepositoryLocation.parsingPort";
                port = Integer.parseInt(host.substring(start + 1));
                host = host.substring(0, start);
            } else {
                partId = "CVSRepositoryLocation.parsingPort";
                int index = end;
                char c = location.charAt(++index);
                String portString = new String();
                while (Character.isDigit(c)) {
                    portString = String.valueOf(portString) + c;
                    c = location.charAt(++index);
                }
                if (portString.length() > 0) {
                    end = index - 1;
                    port = Integer.parseInt(portString);
                }
            }
            partId = "CVSRepositoryLocation.parsingRoot";
            start = end + 1;
            String root = location.substring(start).replace('\\', '/');
            if (validateOnly) {
                throw new CVSException((IStatus)new CVSStatus(0, Policy.bind("ok")));
            }
            return new CVSRepositoryLocation(method, user, password, host, port, root, user != null, password != null);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CVSException(Policy.bind(partId));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CVSException(Policy.bind(partId));
        }
    }

    public static IUserAuthenticator getAuthenticator() {
        if (authenticator == null) {
            authenticator = CVSRepositoryLocation.getPluggedInAuthenticator();
        }
        return authenticator;
    }

    private static IConnectionMethod getPluggedInConnectionMethod(String methodName) {
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private static String getPluggedInConnectionMethodNames() {
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        StringBuffer methodNames = new StringBuffer();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (i > 0) {
                methodNames.append(", ");
            }
            methodNames.append(name);
            ++i;
        }
        return methodNames.toString();
    }

    public static IConnectionMethod[] getPluggedInConnectionMethods() {
        if (pluggedInConnectionMethods == null) {
            ArrayList<Object> connectionMethods = new ArrayList<Object>();
            if (STANDALONE_MODE) {
                connectionMethods.add(new PServerConnectionMethod());
            } else {
                IExtension[] extensions = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "connectionmethods").getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] configs = extension.getConfigurationElements();
                    if (configs.length == 0) {
                        CVSProviderPlugin.log(4, Policy.bind("CVSProviderPlugin.execProblem"), null);
                    } else {
                        try {
                            IConfigurationElement config = configs[0];
                            connectionMethods.add(config.createExecutableExtension("run"));
                        }
                        catch (CoreException ex) {
                            CVSProviderPlugin.log(4, Policy.bind("CVSProviderPlugin.execProblem"), ex);
                        }
                    }
                    ++i;
                }
            }
            pluggedInConnectionMethods = connectionMethods.toArray(new IConnectionMethod[0]);
        }
        return pluggedInConnectionMethods;
    }

    private static IUserAuthenticator getPluggedInAuthenticator() {
        IExtension[] extensions = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            CVSProviderPlugin.log(4, Policy.bind("CVSAdapter.noConfigurationElement", new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IUserAuthenticator)config.createExecutableExtension("run");
        }
        catch (CoreException ex) {
            CVSProviderPlugin.log(4, Policy.bind("CVSAdapter.unableToInstantiate", new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    public static IStatus validate(String location) {
        int colon;
        if (location == null) {
            return new CVSStatus(4, Policy.bind("CVSRepositoryLocation.nullLocation"));
        }
        if (location.equals(AUTH_SCHEME)) {
            return new CVSStatus(4, Policy.bind("CVSRepositoryLocation.emptyLocation"));
        }
        if (location.endsWith(" ") || location.endsWith("\t")) {
            return new CVSStatus(4, Policy.bind("CVSRepositoryLocation.endWhitespace"));
        }
        if (!location.startsWith(":") || location.indexOf(58, 1) == -1) {
            return new CVSStatus(4, Policy.bind("CVSRepositoryLocation.startOfLocation"));
        }
        String formatError = Policy.bind("CVSRepositoryLocation.locationForm");
        int secondColon = location.indexOf(58, 1);
        int at = location.indexOf(64);
        if (at != -1) {
            String user = location.substring(secondColon + 1, at);
            if (user.equals(AUTH_SCHEME)) {
                return new CVSStatus(4, formatError);
            }
        } else {
            at = secondColon;
        }
        if ((colon = location.indexOf(58, at + 1)) == -1) {
            return new CVSStatus(4, formatError);
        }
        String host = location.substring(at + 1, colon);
        if (host.equals(AUTH_SCHEME)) {
            return new CVSStatus(4, formatError);
        }
        String path = location.substring(colon + 1, location.length());
        if (path.equals(AUTH_SCHEME)) {
            return new CVSStatus(4, formatError);
        }
        try {
            CVSRepositoryLocation.fromString(location, true);
        }
        catch (CVSException e) {
            return e.getStatus();
        }
        return new CVSStatus(0, Policy.bind("ok"));
    }

    public void flushUserInfo() throws CVSException {
        this.flushCache();
    }

    String[] getExtCommand(String password) throws IOException {
        String CVS_RSH = CVSProviderPlugin.getPlugin().getCvsRshCommand();
        String CVS_RSH_PARAMETERS = CVSProviderPlugin.getPlugin().getCvsRshParameters();
        String CVS_SERVER = CVSProviderPlugin.getPlugin().getCvsServer();
        if (CVS_RSH == null || CVS_SERVER == null) {
            throw new IOException(Policy.bind("EXTServerConnection.varsNotSet"));
        }
        if (CVS_RSH_PARAMETERS == null || CVS_RSH_PARAMETERS.length() == 0) {
            if (this.port != 0) {
                throw new IOException(Policy.bind("EXTServerConnection.invalidPort"));
            }
            return new String[]{CVS_RSH, this.host, "-l", this.user, CVS_SERVER, INVOKE_SVR_CMD};
        }
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, USER_VARIABLE, this.user);
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, PASSWORD_VARIABLE, password);
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, HOST_VARIABLE, this.host);
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, PORT_VARIABLE, new Integer(this.port).toString());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(CVS_RSH);
        StringTokenizer tokenizer = new StringTokenizer(CVS_RSH_PARAMETERS);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            commands.add(next);
        }
        commands.add(CVS_SERVER);
        commands.add(INVOKE_SVR_CMD);
        return commands.toArray(new String[commands.size()]);
    }

    private String stringReplace(String string, String oldString, String newString) {
        int index = string.toLowerCase().indexOf(oldString);
        if (index == -1) {
            return string;
        }
        return this.stringReplace(String.valueOf(string.substring(0, index)) + newString + string.substring(index + oldString.length()), oldString, newString);
    }

    public String getServerMessageWithoutPrefix(String errorLine, String prefix) {
        String message = errorLine;
        int firstSpace = message.indexOf(32);
        if (firstSpace != -1) {
            message = message.substring(firstSpace + 1);
            if (prefix.startsWith("[")) {
                int closingBracket = message.indexOf("]: ");
                if (closingBracket == -1) {
                    return null;
                }
                String realPrefix = message.substring(1, closingBracket);
                int space = realPrefix.indexOf(32);
                if (space == -1) {
                    return null;
                }
                if (realPrefix.indexOf(32, space + 1) != -1) {
                    return null;
                }
                if (!realPrefix.substring(space + 1).equals("aborted")) {
                    return null;
                }
                if ((message = message.substring(closingBracket + 2)).charAt(0) == ' ') {
                    message = message.substring(1);
                }
                return message;
            }
            int colon = message.indexOf(": ");
            if (colon == -1) {
                return null;
            }
            String realPrefix = message.substring(0, colon);
            if (realPrefix.indexOf(32) != -1) {
                return null;
            }
            if ((message = message.substring(colon + 1)).charAt(0) == ' ') {
                message = message.substring(1);
            }
            return message;
        }
        return null;
    }

    public String getReadLocation() {
        return this.readLocation;
    }

    public void setReadLocation(String readLocation) {
        this.readLocation = readLocation != null && readLocation.equals(this.getLocation()) ? null : readLocation;
    }

    public String getWriteLocation() {
        return this.writeLocation;
    }

    public void setWriteLocation(String writeLocation) {
        this.writeLocation = writeLocation != null && writeLocation.equals(this.getLocation()) ? null : writeLocation;
    }

    public IUserAuthenticator getUserAuthenticator() {
        return CVSRepositoryLocation.getAuthenticator();
    }

    public void setUserAuthenticator(IUserAuthenticator authenticator) {
        CVSRepositoryLocation.authenticator = authenticator;
    }
}

