/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;

public class UpdateListener
extends CommandOutputListener {
    IUpdateMessageListener updateMessageListener;
    boolean merging = false;

    public UpdateListener(IUpdateMessageListener updateMessageListener) {
        this.updateMessageListener = updateMessageListener;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (this.updateMessageListener == null) {
            return ICommandOutputListener.OK;
        }
        if (line.startsWith("Merging differences")) {
            this.merging = true;
        } else if (line.indexOf(32) == 1) {
            String path = line.substring(2);
            char changeType = line.charAt(0);
            int type = 0;
            switch (changeType) {
                case 'A': {
                    type = 1;
                    break;
                }
                case '?': {
                    type = 2;
                    break;
                }
                case 'U': {
                    type = 3;
                    break;
                }
                case 'R': {
                    type = 4;
                    break;
                }
                case 'M': {
                    type = 5;
                    break;
                }
                case 'C': {
                    type = 6;
                    break;
                }
                case 'D': {
                    type = 4;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            if (this.merging) {
                if (type == 5) {
                    type = 7;
                }
                this.merging = false;
            }
            this.updateMessageListener.fileInformation(type, commandRoot, path);
        }
        return ICommandOutputListener.OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        try {
            String serverMessage = this.getServerMessage(line, location);
            if (serverMessage != null) {
                String message = serverMessage;
                if (message.startsWith("Updating")) {
                    if (this.updateMessageListener != null) {
                        String path = message.substring(9);
                        this.updateMessageListener.directoryInformation(commandRoot, path, false);
                    }
                    return ICommandOutputListener.OK;
                }
                if (message.startsWith("skipping directory")) {
                    if (this.updateMessageListener != null) {
                        String path = message.substring(18).trim();
                        this.updateMessageListener.directoryDoesNotExist(commandRoot, path);
                    }
                    return ICommandOutputListener.OK;
                }
                if (message.startsWith("New directory")) {
                    if (this.updateMessageListener != null) {
                        String path = message.substring(15, message.lastIndexOf(39));
                        this.updateMessageListener.directoryInformation(commandRoot, path, true);
                    }
                    return ICommandOutputListener.OK;
                }
                if (message.endsWith("is no longer in the repository")) {
                    if (this.updateMessageListener != null) {
                        String filename = message.substring(0, message.length() - 31);
                        this.updateMessageListener.fileDoesNotExist(commandRoot, filename);
                    }
                    return ICommandOutputListener.OK;
                }
                if (message.startsWith("conflict:")) {
                    if (this.updateMessageListener != null && message.endsWith("is modified but no longer in the repository")) {
                        String filename = message.substring(10, message.length() - 44);
                        this.updateMessageListener.fileDoesNotExist(commandRoot, filename);
                    }
                    return new CVSStatus(2, -12, commandRoot, line);
                }
                if (message.startsWith("warning:")) {
                    if (this.updateMessageListener != null && message.endsWith("is not (any longer) pertinent")) {
                        String filename = message.substring(9, message.length() - 30);
                        this.updateMessageListener.fileDoesNotExist(commandRoot, filename);
                    }
                    return new CVSStatus(2, -12, commandRoot, line);
                }
                if (message.startsWith("conflicts")) {
                    return new CVSStatus(1, -12, commandRoot, line);
                }
                if (!message.startsWith("cannot open directory") && !message.startsWith("nothing known about")) {
                    return super.errorLine(line, location, commandRoot, monitor);
                }
            } else {
                String serverAbortedMessage = this.getServerAbortedMessage(line, location);
                if (serverAbortedMessage != null) {
                    String message = serverAbortedMessage;
                    if (message.startsWith("no such tag")) {
                        return new CVSStatus(2, -11, commandRoot, line);
                    }
                    return super.errorLine(line, location, commandRoot, monitor);
                }
                if (line.equals("rcsmerge: warning: conflicts during merge")) {
                    return new CVSStatus(2, -12, commandRoot, line);
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (CVSProviderPlugin.getPlugin().isDebugging()) {
                System.out.println("Error parsing E line: " + line);
            }
            return new CVSStatus(4, -24, commandRoot, line);
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }
}

