/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.DateUtil;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;

public class LogListener
extends CommandOutputListener {
    private List entries;
    private RemoteFile file;
    private final int BEGIN = 0;
    private final int SYMBOLIC_NAMES = 1;
    private final int REVISION = 2;
    private final int COMMENT = 3;
    private final int DONE = 4;
    private List tagNames = new ArrayList(5);
    private List tagRevisions = new ArrayList(5);
    private int state = 0;
    private String creationDate;
    private String author;
    private String revision;
    private String fileState;
    private StringBuffer comment;
    private static final String NOTHING_KNOWN_ABOUT = "nothing known about ";

    public LogListener(RemoteFile file, List entries) {
        this.file = file;
        this.entries = entries;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        switch (this.state) {
            case 0: {
                if (line.startsWith("symbolic names:")) {
                    this.state = 1;
                    break;
                }
                if (!line.startsWith("revision ")) break;
                this.revision = line.substring(9);
                this.state = 2;
                break;
            }
            case 1: {
                if (line.startsWith("keyword substitution:")) {
                    this.state = 0;
                    break;
                }
                int firstColon = line.indexOf(58);
                String tagName = line.substring(1, firstColon);
                String tagRevision = line.substring(firstColon + 2);
                this.tagNames.add(tagName);
                this.tagRevisions.add(tagRevision);
                break;
            }
            case 2: {
                int endOfDateIndex = line.indexOf(59, 6);
                this.creationDate = String.valueOf(line.substring(6, endOfDateIndex)) + " GMT";
                int endOfAuthorIndex = line.indexOf(59, endOfDateIndex + 1);
                this.author = line.substring(endOfDateIndex + 11, endOfAuthorIndex);
                this.fileState = line.substring(endOfAuthorIndex + 10, line.indexOf(59, endOfAuthorIndex + 1));
                this.comment = new StringBuffer();
                this.state = 3;
                break;
            }
            case 3: {
                if (line.startsWith("branches:")) break;
                if (line.equals("=============================================================================") || line.equals("----------------------------")) {
                    this.state = 4;
                    break;
                }
                if (this.comment.length() != 0) {
                    this.comment.append('\n');
                }
                this.comment.append(line);
            }
        }
        if (this.state == 4) {
            ArrayList<CVSTag> thisRevisionTags = new ArrayList<CVSTag>(3);
            int i = 0;
            while (i < this.tagNames.size()) {
                String tagName = (String)this.tagNames.get(i);
                String tagRevision = (String)this.tagRevisions.get(i);
                boolean isBranch = this.isBranchTag(tagRevision);
                if (isBranch) {
                    int lastDot = tagRevision.lastIndexOf(46);
                    if (lastDot == -1) {
                        CVSProviderPlugin.log(4, Policy.bind("LogListener.invalidRevisionFormat", tagName, tagRevision), null);
                    } else {
                        if (tagRevision.charAt(lastDot - 1) == '0' && tagRevision.charAt(lastDot - 2) == '.') {
                            lastDot -= 2;
                        }
                        tagRevision = tagRevision.substring(0, lastDot);
                    }
                }
                if (tagRevision.equals(this.revision)) {
                    int type = isBranch ? 1 : 2;
                    thisRevisionTags.add(new CVSTag(tagName, type));
                }
                ++i;
            }
            Date date = DateUtil.convertFromLogTime(this.creationDate);
            LogEntry entry = new LogEntry(this.file, this.revision, this.author, date, this.comment.toString(), this.fileState, thisRevisionTags.toArray(new CVSTag[0]));
            this.entries.add(entry);
            this.state = 0;
        }
        return ICommandOutputListener.OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        String serverMessage = this.getServerMessage(line, location);
        if (serverMessage != null && serverMessage.startsWith(NOTHING_KNOWN_ABOUT)) {
            return new CVSStatus(4, -17, commandRoot, line);
        }
        return ICommandOutputListener.OK;
    }

    protected boolean isBranchTag(String tagName) {
        int numberOfDots = 0;
        int lastDot = 0;
        int i = 0;
        while (i < tagName.length()) {
            if (tagName.charAt(i) == '.') {
                ++numberOfDots;
                lastDot = i;
            }
            ++i;
        }
        if (numberOfDots % 2 == 0) {
            return true;
        }
        if (numberOfDots == 1) {
            return false;
        }
        return tagName.charAt(lastDot - 1) == '0' && tagName.charAt(lastDot - 2) == '.';
    }
}

