/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSAnnotateBlock;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;

public class AnnotateListener
extends CommandOutputListener {
    ByteArrayOutputStream aStream = new ByteArrayOutputStream();
    List blocks = new ArrayList();
    int lineNumber;
    String error;

    public String getError() {
        return this.error;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        CVSAnnotateBlock aBlock;
        if (!(aBlock = new CVSAnnotateBlock(line, this.lineNumber++)).isValid()) {
            this.error = line;
        }
        try {
            this.aStream.write(line.substring(aBlock.getSourceOffset()).getBytes());
            if (!line.endsWith("\r") && !line.endsWith("\r\n")) {
                this.aStream.write(System.getProperty("line.separator").getBytes());
            }
        }
        catch (IOException iOException) {}
        this.add(aBlock);
        return ICommandOutputListener.OK;
    }

    public InputStream getContents() {
        return new ByteArrayInputStream(this.aStream.toByteArray());
    }

    public List getCvsAnnotateBlocks() {
        return this.blocks;
    }

    private void add(CVSAnnotateBlock aBlock) {
        int size = this.blocks.size();
        if (size == 0) {
            this.blocks.add(aBlock);
        } else {
            CVSAnnotateBlock lastBlock = (CVSAnnotateBlock)this.blocks.get(size - 1);
            if (lastBlock.getRevision().equals(aBlock.getRevision())) {
                lastBlock.setEndLine(aBlock.getStartLine());
            } else {
                this.blocks.add(aBlock);
            }
        }
    }

    public boolean hasError() {
        return this.error != null;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (line.startsWith("Skipping binary file")) {
            this.error = "Cannot annotate a binary file.";
            return new CVSStatus(4, -10, commandRoot, this.error);
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }
}

