/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RemoteCommand;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;

public class Version
extends RemoteCommand {
    private static final String CVS_NT_PREFIX_1 = "Concurrent Versions System (CVS) NT ";
    private static final String CVS_NT_PREFIX_2 = "Concurrent Versions System (CVSNT) ";
    private static final String CVS_PREFIX = "Concurrent Versions System (CVS) ";

    protected String getRequestId() {
        return "version";
    }

    public IStatus execute(Session session, ICVSRepositoryLocation location, IProgressMonitor monitor) throws CVSException {
        if (!session.isValidRequest(this.getRequestId())) {
            CVSStatus status = new CVSStatus(2, -22, Policy.bind("Version.versionNotValidRequest", location.getHost()));
            ((CVSRepositoryLocation)location).setServerPlaform((IStatus)status);
            CVSProviderPlugin.log((IStatus)status);
            return status;
        }
        ICommandOutputListener listener = new ICommandOutputListener(){

            public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
                String knownPrefix = null;
                boolean isCVSNT = false;
                if (line.startsWith(Version.CVS_NT_PREFIX_1)) {
                    isCVSNT = true;
                    knownPrefix = Version.CVS_NT_PREFIX_1;
                } else if (line.startsWith(Version.CVS_NT_PREFIX_2)) {
                    isCVSNT = true;
                    knownPrefix = Version.CVS_NT_PREFIX_2;
                } else if (line.startsWith(Version.CVS_PREFIX)) {
                    knownPrefix = Version.CVS_PREFIX;
                }
                Object status = ICommandOutputListener.OK;
                if (knownPrefix != null) {
                    String versionNumber = line.substring(knownPrefix.length(), line.indexOf(32, knownPrefix.length() + 1));
                    if (versionNumber.startsWith("1.10") || versionNumber.equals("1.11") || versionNumber.equals("1.11.1")) {
                        status = new CVSStatus(4, -20, Policy.bind("Version.unsupportedVersion", location.getHost(), versionNumber));
                    } else if (isCVSNT) {
                        status = new CVSStatus(2, -21, Policy.bind("Version.unsupportedCVSNT", location.getHost(), versionNumber));
                    }
                } else {
                    status = new CVSStatus(1, -22, Policy.bind("Version.unknownVersionFormat", location.getHost(), line));
                }
                ((CVSRepositoryLocation)location).setServerPlaform((IStatus)status);
                return status;
            }

            public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
                return new CVSStatus(4, -14, line);
            }
        };
        return this.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, new String[0], listener, monitor);
    }
}

