/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSStorage;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.CRLFDetectInputStream;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.Connection;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.core.streams.CRLFtoLFInputStream;
import org.eclipse.team.internal.core.streams.LFtoCRLFInputStream;
import org.eclipse.team.internal.core.streams.ProgressMonitorInputStream;
import org.eclipse.team.internal.core.streams.SizeConstrainedInputStream;

public class Session {
    public static final String CURRENT_LOCAL_FOLDER = ".";
    public static final String CURRENT_REMOTE_FOLDER = "";
    public static final String SERVER_SEPARATOR = "/";
    private static final int TRANSFER_BUFFER_SIZE = 8192;
    private static final int TRANSFER_PROGRESS_INCREMENT = 32768;
    private static final boolean IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").getBytes(), new byte[]{13, 10});
    private CVSRepositoryLocation location;
    private ICVSFolder localRoot;
    private boolean outputToConsole;
    private Connection connection = null;
    private String validRequests = null;
    private Date modTime = null;
    private boolean noLocalChanges = false;
    private boolean createBackups = true;
    private int compressionLevel = 0;
    private List expansions;
    private Collection textTransferOverrideSet = null;
    private Map caseMappings;
    private boolean ignoringLocalChanges = false;
    private String sendFileTitleKey;
    private Map responseHandlers;

    public Session(ICVSRepositoryLocation location, ICVSFolder localRoot) {
        this(location, localRoot, true);
    }

    public Session(ICVSRepositoryLocation location, ICVSFolder localRoot, boolean outputToConsole) {
        this.location = (CVSRepositoryLocation)location;
        this.localRoot = localRoot;
        this.outputToConsole = outputToConsole;
    }

    protected void addCaseCollision(String desiredLocalPath, String actualLocalPath) {
        if (this.caseMappings == null) {
            this.caseMappings = new HashMap();
        }
        Path desiredPath = new Path(desiredLocalPath);
        Path actualPath = new Path(actualLocalPath);
        Assert.isTrue(actualPath.equals((Object)Path.EMPTY) || desiredPath.segmentCount() == actualPath.segmentCount());
        this.caseMappings.put(desiredPath, actualPath);
    }

    protected void addModuleExpansion(String expansion) {
        this.expansions.add(expansion);
    }

    protected void resetModuleExpansion() {
        if (this.expansions == null) {
            this.expansions = new ArrayList();
        } else {
            this.expansions.clear();
        }
    }

    public void open(IProgressMonitor monitor) throws CVSException {
        this.open(monitor, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(IProgressMonitor monitor, boolean writeAccess) throws CVSException {
        block14: {
            if (this.connection != null) {
                throw new IllegalStateException();
            }
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            opened = false;
            try {
                this.connection = this.getLocationForConnection(writeAccess).openConnection(Policy.subMonitorFor(monitor, 50));
                v0 = useMT = this.location.getServerPlatform() != 1;
                if (!useMT) {
                    this.removeResponseHandler("MT");
                }
                this.connection.writeLine("Valid-responses " + this.makeResponseList());
                status = Request.VALID_REQUESTS.execute(this, Policy.subMonitorFor(monitor, 40));
                if (!status.isOK()) {
                    throw new CVSException(status);
                }
                this.connection.writeLine("Root " + this.getRepositoryRoot());
                this.compressionLevel = CVSProviderPlugin.getPlugin().getCompressionLevel();
                if (this.compressionLevel != 0 && this.isValidRequest("gzip-file-contents")) {
                    this.connection.writeLine("gzip-file-contents " + Integer.toString(this.compressionLevel));
                } else {
                    this.compressionLevel = 0;
                }
                if (CVSProviderPlugin.getPlugin().isDetermineVersionEnabled() && this.location.getServerPlatform() == 0) {
                    Command.VERSION.execute(this, this.location, Policy.subMonitorFor(monitor, 10));
                }
                opened = true;
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                if (this.connection != null && !opened) {
                    try {
                        this.close();
                    }
                    catch (CVSException ex) {
                        CVSProviderPlugin.log((CoreException)ex);
                    }
                }
                monitor.done();
                throw var7_6;
            }
            {
                var6_8 = null;
                if (this.connection == null || opened) break block14;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 293->300)] { 
lbl41:
            // 1 sources

            this.close();
            break block14;
lbl43:
            // 1 sources

            catch (CVSException ex) {
                CVSProviderPlugin.log((CoreException)ex);
            }
        }
        monitor.done();
    }

    private CVSRepositoryLocation getLocationForConnection(boolean writeAccess) {
        try {
            if (writeAccess) {
                String writeLocation = this.location.getWriteLocation();
                if (writeLocation != null) {
                    return (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(writeLocation);
                }
            } else {
                String readLocation = this.location.getReadLocation();
                if (readLocation != null) {
                    return (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(readLocation);
                }
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)e);
        }
        return this.location;
    }

    public void close() throws CVSException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            this.validRequests = null;
        }
    }

    public boolean isValidRequest(String request) {
        return this.validRequests == null || this.validRequests.indexOf(" " + request + " ") != -1;
    }

    public boolean isCVSNT() {
        if (this.location.getServerPlatform() == 0) {
            return this.location.getRootDirectory().indexOf(58) == 1;
        }
        return this.location.getServerPlatform() == 2;
    }

    protected String getUniquePathForCaseSensitivePath(String localPath, boolean creatingFolder) {
        Path path = new Path(localPath);
        IPath existingMapping = null;
        if (this.caseMappings != null) {
            int i = 0;
            while (i < path.segmentCount()) {
                IPath key = path.removeLastSegments(i);
                existingMapping = (IPath)this.caseMappings.get(key);
                if (existingMapping != null) break;
                ++i;
            }
        }
        if (existingMapping != null) {
            if (existingMapping.segmentCount() == path.segmentCount()) {
                return existingMapping.toString();
            }
            path = existingMapping.append(path.removeFirstSegments(existingMapping.segmentCount()));
        }
        if (creatingFolder) {
            String folderName = path.lastSegment();
            folderName = this.getUniqueNameForCaseVariant(folderName);
            path = path.removeLastSegments(1).append(folderName);
        }
        return path.toString();
    }

    private String getUniqueNameForCaseVariant(String name) {
        char[] buffer = new char[name.length() * 2];
        int position = 0;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            buffer[position++] = c;
            if (Character.isLetter(c)) {
                buffer[position++] = Character.isUpperCase(c) ? 45 : 95;
            }
            ++i;
        }
        return new String(buffer, 0, position);
    }

    public ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    public String[] getModuleExpansions() {
        if (this.expansions == null) {
            return new String[0];
        }
        return this.expansions.toArray(new String[this.expansions.size()]);
    }

    public String getRepositoryRoot() {
        return this.location.getRootDirectory();
    }

    public ICVSRepositoryLocation getCVSRepositoryLocation() {
        return this.location;
    }

    private IContainer getIResourceFor(ICVSFolder cvsFolder) throws CoreException, CVSException {
        if (cvsFolder.isManaged()) {
            return this.getIResourceFor(cvsFolder.getParent()).getFolder((IPath)new Path(cvsFolder.getName()));
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(cvsFolder.getName());
    }

    protected void handleCaseCollisions() throws CVSException {
        Map mappings = this.caseMappings;
        if (mappings == null || mappings.size() == 0) {
            return;
        }
        ArrayList sortedCollisions = new ArrayList();
        sortedCollisions.addAll(mappings.keySet());
        Collections.sort(sortedCollisions, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int length1;
                int length0 = ((IPath)arg0).segmentCount();
                if (length0 == (length1 = ((IPath)arg1).segmentCount())) {
                    return arg0.toString().compareTo(arg1.toString());
                }
                return length0 > length1 ? -1 : 1;
            }
        });
        ArrayList<IPath> unhandledMappings = new ArrayList<IPath>();
        Iterator iterator = sortedCollisions.iterator();
        while (iterator.hasNext()) {
            IPath desiredPath = (IPath)iterator.next();
            IPath actualPath = (IPath)mappings.get(desiredPath);
            if (actualPath.equals((Object)Path.EMPTY)) {
                unhandledMappings.add(desiredPath);
                continue;
            }
            ICVSFolder actualFolder = this.getLocalRoot().getFolder(actualPath.toString());
            if (!actualFolder.exists()) continue;
            ICVSFolder desiredFolder = this.getLocalRoot().getFolder(desiredPath.toString());
            try {
                desiredFolder.mkdir();
                desiredFolder.delete();
            }
            catch (CVSException cVSException) {
                actualFolder.delete();
                actualFolder.unmanage(null);
                unhandledMappings.add(desiredPath);
                continue;
            }
            try {
                IContainer actualResource = this.getIResourceFor(actualFolder);
                IFolder desiredResource = actualResource.getParent().getFolder((IPath)new Path(desiredFolder.getName()));
                actualResource.move(desiredResource.getFullPath(), false, null);
                desiredFolder.accept(new ICVSResourceVisitor(){

                    public void visitFile(ICVSFile file) throws CVSException {
                        file.setSyncBytes(file.getSyncBytes(), 0);
                    }

                    public void visitFolder(ICVSFolder folder) throws CVSException {
                        folder.setFolderSyncInfo(folder.getFolderSyncInfo());
                        folder.acceptChildren(this);
                    }
                });
                actualFolder.unmanage(null);
            }
            catch (CoreException e) {
                CVSProviderPlugin.log(e);
                unhandledMappings.add(desiredPath);
            }
        }
        if (unhandledMappings.size() > 0) {
            MultiStatus status = new MultiStatus("org.eclipse.team.cvs.core", -19, Policy.bind("PruneFolderVisitor.caseVariantsExist"), null);
            Iterator iter = unhandledMappings.iterator();
            while (iter.hasNext()) {
                IPath desiredPath = (IPath)iter.next();
                status.add((IStatus)new CVSStatus(4, -19, Policy.bind("PruneFolderVisitor.caseVariantExists", desiredPath.toString())));
            }
            if (status.getChildren().length == 1) {
                throw new CVSException(status.getChildren()[0]);
            }
            throw new CVSException((IStatus)status);
        }
    }

    public String readLine() throws CVSException {
        return this.connection.readLine();
    }

    public void writeLine(String line) throws CVSException {
        this.connection.writeLine(line);
    }

    public void sendArgument(String arg) throws CVSException {
        int pos;
        this.connection.write("Argument ");
        int oldPos = 0;
        while ((pos = arg.indexOf(10, oldPos)) != -1) {
            this.connection.writeLine(arg.substring(oldPos, pos));
            this.connection.write("Argumentx ");
            oldPos = pos + 1;
        }
        this.connection.writeLine(arg.substring(oldPos));
    }

    public void sendRequest(String requestId) throws CVSException {
        this.connection.writeLine(requestId);
        this.connection.flush();
    }

    public void sendIsModified(ICVSFile file, boolean isBinary, IProgressMonitor monitor) throws CVSException {
        if (this.isValidRequest("Is-modified")) {
            this.connection.writeLine("Is-modified " + file.getName());
        } else {
            this.sendModified(file, isBinary, monitor);
        }
    }

    public void sendStaticDirectory() throws CVSException {
        this.connection.writeLine("Static-directory");
    }

    public void sendConstructedDirectory(String localDir) throws CVSException {
        this.sendDirectory(localDir, String.valueOf(this.getRepositoryRoot()) + SERVER_SEPARATOR + localDir);
    }

    public void sendDirectory(String localDir, String remoteDir) throws CVSException {
        if (localDir.length() == 0) {
            localDir = CURRENT_LOCAL_FOLDER;
        }
        this.connection.writeLine("Directory " + localDir);
        this.connection.writeLine(remoteDir);
    }

    public void sendLocalRootDirectory() throws CVSException {
        this.sendDirectory(CURRENT_LOCAL_FOLDER, this.localRoot.getRemoteLocation(this.localRoot));
    }

    public void sendConstructedRootDirectory() throws CVSException {
        this.sendConstructedDirectory(CURRENT_REMOTE_FOLDER);
    }

    public void sendEntry(byte[] syncBytes, String serverTimestamp) throws CVSException {
        int start;
        this.connection.write("Entry ");
        if (serverTimestamp == null) {
            serverTimestamp = CURRENT_REMOTE_FOLDER;
        }
        if ((start = Util.getOffsetOfDelimeter(syncBytes, (byte)47, 0, 3)) == -1) {
            this.connection.writeLine(syncBytes, 0, syncBytes.length);
            return;
        }
        int end = Util.getOffsetOfDelimeter(syncBytes, (byte)47, start + 1, 1);
        if (end == -1) {
            this.connection.writeLine(syncBytes, 0, syncBytes.length);
            return;
        }
        this.connection.write(syncBytes, 0, start + 1);
        this.connection.write(serverTimestamp);
        this.connection.writeLine(syncBytes, end, syncBytes.length - end);
    }

    public void sendGlobalOption(String option) throws CVSException {
        this.connection.writeLine("Global_option " + option);
    }

    public void sendUnchanged(ICVSFile file) throws CVSException {
        this.connection.writeLine("Unchanged " + file.getName());
    }

    public void sendNotify(ICVSFolder parent, NotifyInfo info) throws CVSException {
        String filename = info.getName();
        this.connection.writeLine("Notify " + filename);
        this.connection.writeLine(info.getServerLine(parent));
    }

    public void sendQuestionable(ICVSResource resource) throws CVSException {
        this.connection.writeLine("Questionable " + resource.getName());
    }

    public void sendSticky(String tag) throws CVSException {
        this.connection.writeLine("Sticky " + tag);
    }

    public void sendModified(ICVSFile file, boolean isBinary, IProgressMonitor monitor) throws CVSException {
        this.sendModified(file, isBinary, true, monitor);
    }

    public void sendModified(ICVSFile file, boolean isBinary, boolean sendBinary, IProgressMonitor monitor) throws CVSException {
        String filename = file.getName();
        this.connection.writeLine("Modified " + filename);
        this.connection.writeLine(ResourceSyncInfo.getDefaultPermissions());
        this.sendFile(file, isBinary, sendBinary, monitor);
    }

    public void sendFile(ICVSFile file, boolean isBinary, IProgressMonitor monitor) throws CVSException {
        this.sendFile(file, isBinary, true, monitor);
    }

    /*
     * Exception decompiling
     */
    public void sendFile(ICVSStorage file, boolean isBinary, boolean sendBinary, IProgressMonitor monitor) throws CVSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 201->204)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendCompressedBytes(InputStream in, long length) throws IOException, CVSException {
        int count;
        String sizeLine = "z" + Long.toString(length);
        this.writeLine(sizeLine);
        OutputStream out = this.connection.getOutputStream();
        GZIPOutputStream zo = new GZIPOutputStream(out);
        byte[] buffer = new byte[8192];
        while ((count = in.read(buffer)) != -1) {
            zo.write(buffer, 0, count);
        }
        zo.finish();
    }

    private void sendUncompressedBytes(InputStream in, long length) throws IOException, CVSException {
        int count;
        OutputStream out = this.connection.getOutputStream();
        String sizeLine = Long.toString(length);
        this.writeLine(sizeLine);
        byte[] buffer = new byte[8192];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public void receiveFile(ICVSStorage file, boolean isBinary, int responseType, IProgressMonitor monitor) throws CVSException {
        long size;
        if (this.textTransferOverrideSet != null && this.textTransferOverrideSet.contains(file)) {
            isBinary = false;
        }
        final String title = Policy.bind("Session.receiving", new Object[]{Util.toTruncatedPath(file, this.localRoot, 3)});
        monitor.subTask(Policy.bind("Session.transferNoSize", title));
        boolean compressed = false;
        try {
            String sizeLine = this.readLine();
            if (sizeLine.charAt(0) == 'z') {
                compressed = true;
                sizeLine = sizeLine.substring(1);
            }
            size = Long.parseLong(sizeLine, 10);
        }
        catch (NumberFormatException e) {
            throw new CVSException(Policy.bind("Session.badInt"), e);
        }
        Object in = new SizeConstrainedInputStream(this.connection.getInputStream(), size, true);
        in = new ProgressMonitorInputStream((InputStream)in, size, 32768, monitor){

            protected void updateMonitor(long bytesRead, long bytesTotal, IProgressMonitor monitor) {
                if (bytesRead == 0L) {
                    return;
                }
                monitor.subTask(Policy.bind("Session.transfer", new Object[]{title, Long.toString(bytesRead >> 10), Long.toString(bytesTotal >> 10)}));
            }
        };
        if (compressed) {
            try {
                in = new GZIPInputStream((InputStream)in);
            }
            catch (IOException e) {
                throw CVSException.wrapException(e);
            }
        }
        if (!isBinary) {
            if (IS_CRLF_PLATFORM) {
                in = new CRLFtoLFInputStream((InputStream)in);
                in = new LFtoCRLFInputStream((InputStream)in);
            } else {
                in = new CRLFDetectInputStream((InputStream)in, file);
            }
        }
        file.setContents((InputStream)in, responseType, true, (IProgressMonitor)new NullProgressMonitor());
    }

    void setModTime(Date modTime) {
        this.modTime = modTime;
    }

    Date getModTime() {
        return this.modTime;
    }

    void setNoLocalChanges(boolean noLocalChanges) {
        this.noLocalChanges = noLocalChanges;
    }

    boolean isNoLocalChanges() {
        return this.noLocalChanges;
    }

    void setValidRequests(String validRequests) {
        this.validRequests = " " + validRequests + " ";
    }

    boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    void setCreateBackups(boolean createBackups) {
        this.createBackups = createBackups;
    }

    boolean isCreateBackups() {
        return this.createBackups;
    }

    String getSendFileTitleKey() {
        if (this.sendFileTitleKey == null) {
            return "Session.sending";
        }
        return this.sendFileTitleKey;
    }

    public void setSendFileTitleKey(String sendFileTitleKey) {
        this.sendFileTitleKey = sendFileTitleKey;
    }

    public void setTextTransferOverride(Collection textTransferOverrideSet) {
        this.textTransferOverrideSet = textTransferOverrideSet;
    }

    protected Command.GlobalOption[] filterGlobalOptions(Command.GlobalOption[] globalOptions) {
        if (!Command.DO_NOT_CHANGE.isElementOf(globalOptions)) {
            Command.QuietOption quietOption = CVSProviderPlugin.getPlugin().getQuietness();
            if (quietOption != null) {
                globalOptions = quietOption.addToEnd(globalOptions);
            }
            if (CVSProviderPlugin.getPlugin().getPluginPreferences().getBoolean("cvs.read.only") && !Command.MAKE_READ_ONLY.isElementOf(globalOptions)) {
                globalOptions = Command.MAKE_READ_ONLY.addToEnd(globalOptions);
            }
        }
        return globalOptions;
    }

    protected void setIgnoringLocalChanges(boolean b) {
        this.ignoringLocalChanges = b;
    }

    protected boolean isIgnoringLocalChanges() {
        return this.ignoringLocalChanges;
    }

    public String getUniquePathForInvalidPath(String localDir) {
        Path oldPath = new Path(localDir);
        int count = oldPath.segmentCount();
        int i = 0;
        while (i < count) {
            String segment = oldPath.segment(i);
            if (segment.endsWith(CURRENT_LOCAL_FOLDER)) {
                segment = String.valueOf(segment) + Policy.bind("Session.dot_2");
                oldPath = oldPath.removeLastSegments(count - i).append(segment).append(oldPath.removeFirstSegments(i + 1));
            }
            ++i;
        }
        return oldPath.toString();
    }

    protected Map getReponseHandlers() {
        if (this.responseHandlers == null) {
            this.responseHandlers = Request.getReponseHandlerMap();
        }
        return this.responseHandlers;
    }

    private String makeResponseList() {
        StringBuffer result = new StringBuffer("ok error M E");
        Iterator elements = this.getReponseHandlers().keySet().iterator();
        while (elements.hasNext()) {
            result.append(' ');
            result.append((String)elements.next());
        }
        return result.toString();
    }

    public void registerResponseHandler(ResponseHandler handler) {
        this.getReponseHandlers().put(handler.getResponseID(), handler);
    }

    public void removeResponseHandler(String responseID) {
        this.getReponseHandlers().remove(responseID);
    }

    public ResponseHandler getResponseHandler(String responseID) {
        return (ResponseHandler)this.getReponseHandlers().get(responseID);
    }
}

