/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.Util;

public abstract class ResponseHandler {
    public abstract String getResponseID();

    public abstract void handle(Session var1, String var2, IProgressMonitor var3) throws CVSException;

    protected static ICVSFolder createFolder(Session session, String localDir, String repositoryDir) throws CVSException {
        ICVSFolder folder;
        block15: {
            folder = session.getLocalRoot().getFolder(localDir);
            if (!folder.exists()) {
                try {
                    folder.mkdir();
                }
                catch (CVSException original) {
                    boolean caseInvariant = false;
                    switch (original.getStatus().getCode()) {
                        case 275: {
                            caseInvariant = true;
                            break;
                        }
                        case 368: {
                            String actualLocalDir = session.getUniquePathForCaseSensitivePath(localDir, false);
                            folder = session.getLocalRoot().getFolder(actualLocalDir);
                            try {
                                if (folder.exists()) break;
                                folder.mkdir();
                                break;
                            }
                            catch (CVSException ex) {
                                if (ex.getStatus().getCode() == 275) {
                                    caseInvariant = true;
                                    break;
                                }
                                throw original;
                            }
                        }
                        case 77: {
                            String validLocalDir = session.getUniquePathForInvalidPath(localDir);
                            folder = session.getLocalRoot().getFolder(validLocalDir);
                            try {
                                if (folder.exists()) break;
                                folder.mkdir();
                                break;
                            }
                            catch (CVSException cVSException) {
                                throw original;
                            }
                        }
                        default: {
                            throw original;
                        }
                    }
                    if (!caseInvariant) break block15;
                    String newlocalDir = session.getUniquePathForCaseSensitivePath(localDir, true);
                    folder = session.getLocalRoot().getFolder(newlocalDir);
                    if (!folder.exists()) {
                        folder.mkdir();
                    }
                    session.addCaseCollision(localDir, newlocalDir);
                }
            }
        }
        if (!folder.isCVSFolder()) {
            folder.setFolderSyncInfo(new FolderSyncInfo(Util.getRelativePath(session.getRepositoryRoot(), repositoryDir), session.getCVSRepositoryLocation().getLocation(), null, false));
        }
        return folder;
    }

    protected ICVSFolder getExistingFolder(Session session, String localDir) throws CVSException {
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        if (!mParent.exists()) {
            IContainer container = (IContainer)mParent.getIResource();
            if (container != null && container.isPhantom()) {
                this.recreatePhatomFolders(mParent);
            } else {
                localDir = session.getUniquePathForCaseSensitivePath(localDir, false);
                mParent = session.getLocalRoot().getFolder(localDir);
                if (!mParent.exists()) {
                    localDir = session.getUniquePathForInvalidPath(localDir);
                    mParent = session.getLocalRoot().getFolder(localDir);
                    Assert.isTrue(mParent.exists());
                }
            }
        }
        return mParent;
    }

    private void recreatePhatomFolders(ICVSFolder folder) throws CVSException {
        ICVSFolder parent = folder.getParent();
        if (!parent.exists()) {
            this.recreatePhatomFolders(parent);
        }
        folder.mkdir();
    }

    ResponseHandler getInstance() {
        return this;
    }
}

