/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.FileStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ModuleDefinitionsListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class Checkout
extends Command {
    public static final Command.LocalOption DO_NOT_SHORTEN = new Command.LocalOption("-N");
    public static final Command.LocalOption FETCH_MODULE_ALIASES = new Command.LocalOption("-c");
    private static final ICommandOutputListener DEFAULT_OUTPUT_LISTENER = new UpdateListener(null);
    public static Command.LocalOption ALIAS = new Command.LocalOption("-a");

    public static Command.LocalOption makeDirectoryNameOption(String moduleName) {
        return new Command.LocalOption("-d", moduleName);
    }

    public static Command.LocalOption makeStatusOption(String status) {
        return new Command.LocalOption("-s", status);
    }

    protected Checkout() {
    }

    protected String getRequestId() {
        return "co";
    }

    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return DEFAULT_OUTPUT_LISTENER;
    }

    protected ICVSResource[] computeWorkResources(Session session, Command.LocalOption[] localOptions, String[] arguments) throws CVSException {
        if (arguments.length < 1 && !FETCH_MODULE_ALIASES.isElementOf(localOptions)) {
            throw new IllegalArgumentException();
        }
        Command.Option dOption = Command.findOption(localOptions, "-d");
        if (dOption != null) {
            return new ICVSResource[]{session.getLocalRoot().getFolder(dOption.argument)};
        }
        String[] modules = session.getModuleExpansions();
        ICVSResource[] resources = new ICVSResource[modules.length];
        int i = 0;
        while (i < resources.length) {
            resources[i] = session.getLocalRoot().getFolder(modules[i]);
            ++i;
        }
        return resources;
    }

    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        Assert.isTrue(session.getLocalRoot().isFolder());
        ArrayList<ICVSResource> resourcesToSend = new ArrayList<ICVSResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            ICVSResource resource = resources[i];
            if (resource.exists() && resource.isFolder() && ((ICVSFolder)resource).isCVSFolder()) {
                resourcesToSend.add(resource);
            }
            ++i;
        }
        if (!resourcesToSend.isEmpty()) {
            resources = resourcesToSend.toArray(new ICVSResource[resourcesToSend.size()]);
            new FileStructureVisitor(session, true, true).visit(session, resources, monitor);
        }
        return resources;
    }

    protected void sendLocalWorkingDirectory(Session session) throws CVSException {
        session.sendConstructedRootDirectory();
    }

    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        if (FETCH_MODULE_ALIASES.isElementOf(localOptions)) {
            return status;
        }
        if (Command.PRUNE_EMPTY_DIRECTORIES.isElementOf(localOptions) || Command.findOption(localOptions, "-D") != null || Command.findOption(localOptions, "-r") != null) {
            new PruneFolderVisitor().visit(session, resources);
        }
        session.handleCaseCollisions();
        return status;
    }

    protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        if (!FETCH_MODULE_ALIASES.isElementOf(localOptions)) {
            IStatus status = Request.EXPAND_MODULES.execute(session, arguments, Policy.subMonitorFor(monitor, 10));
            if (status.getCode() == -10) {
                return status;
            }
            if (Command.findOption(localOptions, "-d") == null && !DO_NOT_SHORTEN.isElementOf(localOptions)) {
                Command.LocalOption[] newLocalOptions = new Command.LocalOption[localOptions.length + 1];
                newLocalOptions[0] = DO_NOT_SHORTEN;
                System.arraycopy(localOptions, 0, newLocalOptions, 1, localOptions.length);
                localOptions = newLocalOptions;
            }
        }
        return super.doExecute(session, globalOptions, localOptions, arguments, listener, Policy.subMonitorFor(monitor, 90));
    }

    public RemoteModule[] getRemoteModules(Session session, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        ModuleDefinitionsListener moduleDefinitionListener = new ModuleDefinitionsListener();
        IStatus status = super.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{FETCH_MODULE_ALIASES}, Command.NO_ARGUMENTS, (ICommandOutputListener)moduleDefinitionListener, monitor);
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
        return RemoteModule.createRemoteModules(moduleDefinitionListener.getModuleExpansions(), session.getCVSRepositoryLocation(), tag);
    }
}

