/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.RemoteSynchronizer;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamDelta;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.OptimizedRemoteSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.RemoteTagSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;

public class CVSWorkspaceSubscriber
extends CVSSyncTreeSubscriber
implements IResourceStateChangeListener {
    private OptimizedRemoteSynchronizer remoteSynchronizer = new OptimizedRemoteSynchronizer("remote-resource-key");
    private static final String REMOTE_RESOURCE_KEY = "remote-resource-key";

    CVSWorkspaceSubscriber(QualifiedName id, String name, String description) {
        super(id, name, description);
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener(this);
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (project.isOpen() && (provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId())) != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.internalResourceSyncInfoChanged(changedResources, true);
    }

    private void internalResourceSyncInfoChanged(IResource[] changedResources, boolean canModifyWorkspace) {
        int i = 0;
        while (i < changedResources.length) {
            IResource resource = changedResources[i];
            try {
                if (resource.getType() == 1 && (resource.exists() || resource.isPhantom())) {
                    byte[] remoteBytes = this.remoteSynchronizer.getSyncBytes(resource);
                    if (remoteBytes == null) {
                        if (this.remoteSynchronizer.isRemoteKnown(resource) && this.getBaseSynchronizer().hasRemote(resource) && canModifyWorkspace) {
                            this.remoteSynchronizer.removeSyncBytes(resource, 0);
                        }
                    } else {
                        byte[] localBytes = this.remoteSynchronizer.getBaseSynchronizer().getSyncBytes(resource);
                        if ((localBytes == null || !this.isLaterRevision(remoteBytes, localBytes)) && canModifyWorkspace) {
                            this.remoteSynchronizer.removeSyncBytes(resource, 0);
                        }
                    }
                } else if (resource.getType() == 2 && this.getBaseSynchronizer().hasRemote(resource) && canModifyWorkspace) {
                    this.remoteSynchronizer.removeSyncBytes(resource, 0);
                }
            }
            catch (TeamException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
            ++i;
        }
        this.fireTeamResourceChange(TeamDelta.asSyncChangedDeltas((TeamSubscriber)this, (IResource[])changedResources));
    }

    private boolean isLaterRevision(byte[] remoteBytes, byte[] localBytes) {
        try {
            return ResourceSyncInfo.isLaterRevisionOnSameBranch(remoteBytes, localBytes);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    public void externalSyncInfoChange(IResource[] changedResources) {
        this.internalResourceSyncInfoChanged(changedResources, false);
    }

    public void resourceModified(IResource[] changedResources) {
    }

    public void projectConfigured(IProject project) {
        TeamDelta delta = new TeamDelta((TeamSubscriber)this, 2, (IResource)project);
        this.fireTeamResourceChange(new TeamDelta[]{delta});
    }

    public void projectDeconfigured(IProject project) {
        try {
            this.remoteSynchronizer.removeSyncBytes((IResource)project, 2);
        }
        catch (TeamException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        TeamDelta delta = new TeamDelta((TeamSubscriber)this, 4, (IResource)project);
        this.fireTeamResourceChange(new TeamDelta[]{delta});
    }

    protected RemoteSynchronizer getRemoteSynchronizer() {
        return this.remoteSynchronizer;
    }

    protected RemoteSynchronizer getBaseSynchronizer() {
        return this.remoteSynchronizer.getBaseSynchronizer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncInfo[] getAllOutOfSync(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, resources.length * 100);
        final ArrayList result = new ArrayList();
        int i = 0;
        while (true) {
            Object var9_8;
            if (i >= resources.length) {
                monitor.done();
                return result.toArray(new SyncInfo[result.size()]);
            }
            IResource resource = resources[i];
            final IProgressMonitor infinite = Policy.infiniteSubMonitorFor(monitor, 100);
            try {
                try {
                    infinite.beginTask(null, 512);
                    Platform.getJobManager().beginRule((ISchedulingRule)resource, Policy.subMonitorFor(infinite, 1));
                    resource.accept(new IResourceVisitor(){

                        public boolean visit(IResource innerResource) throws CoreException {
                            try {
                                SyncInfo info;
                                if (CVSWorkspaceSubscriber.this.isOutOfSync(innerResource, infinite) && (info = CVSWorkspaceSubscriber.this.getSyncInfo(innerResource, infinite)) != null && info.getKind() != 0) {
                                    result.add(info);
                                }
                                return true;
                            }
                            catch (TeamException e) {
                                throw new CoreException(e.getStatus());
                            }
                        }
                    }, depth, true);
                }
                catch (CoreException e) {
                    throw CVSException.wrapException(e);
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                Platform.getJobManager().endRule((ISchedulingRule)resource);
                infinite.done();
                throw throwable;
            }
            {
                var9_8 = null;
            }
            Platform.getJobManager().endRule((ISchedulingRule)resource);
            infinite.done();
            ++i;
        }
    }

    boolean isOutOfSync(IResource resource, IProgressMonitor monitor) throws TeamException {
        return this.hasIncomingChange(resource) || this.hasOutgoingChange(CVSWorkspaceRoot.getCVSResourceFor(resource), monitor);
    }

    private boolean hasOutgoingChange(ICVSResource resource, IProgressMonitor monitor) throws CVSException {
        if (resource.isFolder()) {
            ICVSFolder folder = (ICVSFolder)resource;
            if (folder.getParent().isModified(monitor)) {
                return !folder.isCVSFolder() && !folder.isIgnored();
            }
        } else {
            ICVSFile file = (ICVSFile)resource;
            if (file.getParent().isModified(monitor)) {
                return file.isModified(monitor);
            }
        }
        return false;
    }

    private boolean hasIncomingChange(IResource resource) throws TeamException {
        return this.remoteSynchronizer.isRemoteKnown(resource);
    }

    public IRemoteResource getRemoteResource(IResource resource) throws TeamException {
        IRemoteResource remote = super.getRemoteResource(resource);
        if (resource.getType() == 1 && remote instanceof ICVSRemoteFile) {
            byte[] remoteBytes = ((ICVSRemoteFile)remote).getSyncBytes();
            byte[] localBytes = CVSWorkspaceRoot.getCVSFileFor((IFile)resource).getSyncBytes();
            if (localBytes != null && remoteBytes != null && !ResourceSyncInfo.isLaterRevisionOnSameBranch(remoteBytes, localBytes)) {
                return this.getBaseResource(resource);
            }
        }
        return remote;
    }

    public void setRemote(IProject project, IRemoteResource remote, IProgressMonitor monitor) throws TeamException {
        ArrayList changedResources = new ArrayList();
        ((RemoteTagSynchronizer)this.getRemoteSynchronizer()).collectChanges((IResource)project, remote, changedResources, 2, monitor);
        if (!changedResources.isEmpty()) {
            IResource[] changes = changedResources.toArray(new IResource[changedResources.size()]);
            this.fireTeamResourceChange(TeamDelta.asSyncChangedDeltas((TeamSubscriber)this, (IResource[])changes));
        }
    }
}

