/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.EditorsInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.AdminKSubstListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.DiffListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.EditorsListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.MoveDeleteHook;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;
import org.eclipse.team.internal.core.streams.CRLFtoLFInputStream;
import org.eclipse.team.internal.core.streams.LFtoCRLFInputStream;

public class CVSTeamProvider
extends RepositoryProvider {
    private static final boolean IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").getBytes(), new byte[]{13, 10});
    public static final IStatus OK = new Status(0, "org.eclipse.team.cvs.core", 0, Policy.bind("ok"), null);
    private static final int UNIFIED_FORMAT = 0;
    private static final int CONTEXT_FORMAT = 1;
    private static final int STANDARD_FORMAT = 2;
    private CVSWorkspaceRoot workspaceRoot;
    private IProject project;
    private String comment = "";
    private static MoveDeleteHook moveDeleteHook = new MoveDeleteHook();
    private static IFileModificationValidator fileModificationValidator;
    private static final QualifiedName FETCH_ABSENT_DIRECTORIES_PROP_KEY;
    private static final QualifiedName WATCH_EDIT_PROP_KEY;

    static {
        FETCH_ABSENT_DIRECTORIES_PROP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "fetch_absent_directories");
        WATCH_EDIT_PROP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "watch_edit");
    }

    private static IFileModificationValidator getPluggedInValidator() {
        IExtension[] extensions = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "filemodificationvalidator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            CVSProviderPlugin.log(4, Policy.bind("CVSAdapter.noConfigurationElement", new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IFileModificationValidator)config.createExecutableExtension("run");
        }
        catch (CoreException ex) {
            CVSProviderPlugin.log(4, Policy.bind("CVSAdapter.unableToInstantiate", new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    public void deconfigure() throws CoreException {
        try {
            EclipseSynchronizer.getInstance().deconfigure(this.getProject(), null);
        }
        catch (CVSException e) {
            throw new CoreException(e.getStatus());
        }
    }

    public void deconfigured() {
        ResourceStateChangeListeners.getListener().projectDeconfigured(this.getProject());
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        try {
            this.workspaceRoot = new CVSWorkspaceRoot((IContainer)project);
            if (this.workspaceRoot.getLocalRoot().getFolderSyncInfo() == null) {
                CVSProviderPlugin.log((CoreException)((Object)new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.noFolderInfo", project.getName())))));
            }
        }
        catch (CVSException cVSException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        final TreeSet<ICVSResource> folders = new TreeSet<ICVSResource>();
        final HashMap files = new HashMap();
        TeamException[] eHolder = new TeamException[1];
        int i = 0;
        while (true) {
            if (i >= resources.length) {
                if (eHolder[0] == null) break;
                throw eHolder[0];
            }
            final IResource currentResource = resources[i];
            this.checkIsChild(currentResource);
            try {
                IContainer parent = currentResource.getParent();
                ICVSResource cvsParentResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)parent);
                while (true) {
                    if (parent.getType() == 8 || parent.getType() == 4 || this.isManaged(cvsParentResource)) {
                        final TeamException[] exception = new TeamException[1];
                        currentResource.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) {
                                try {
                                    ICVSResource mResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
                                    if (!(CVSTeamProvider.this.isManaged(mResource) || !currentResource.equals((Object)resource) && mResource.isIgnored())) {
                                        if (resource.getType() == 1) {
                                            Command.KSubstOption ksubst = Command.KSubstOption.fromFile((IFile)resource);
                                            HashSet<ICVSResource> set = (HashSet<ICVSResource>)files.get(ksubst);
                                            if (set == null) {
                                                set = new HashSet<ICVSResource>();
                                                files.put(ksubst, set);
                                            }
                                            set.add(mResource);
                                        } else {
                                            folders.add(mResource);
                                        }
                                    }
                                    return true;
                                }
                                catch (CVSException e) {
                                    exception[0] = e;
                                    return false;
                                }
                            }
                        }, depth, false);
                        if (exception[0] == null) break;
                        throw exception[0];
                    }
                    folders.add(cvsParentResource);
                    parent = parent.getParent();
                    cvsParentResource = cvsParentResource.getParent();
                }
            }
            catch (CoreException e) {
                throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSTeamProvider.visitError", new Object[]{resources[i].getFullPath()}), (Throwable)e));
            }
            ++i;
        }
        progress.beginTask(null, files.size() * 10 + (folders.isEmpty() ? 0 : 10));
        try {
            if (!folders.isEmpty()) {
                Object e;
                Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot(), true);
                session.open(Policy.subMonitorFor(progress, 2), true);
                try {
                    IStatus status = Command.ADD.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, folders.toArray(new ICVSResource[folders.size()]), null, Policy.subMonitorFor(progress, 8));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable cvsParentResource) {
                    e = null;
                    session.close();
                    throw cvsParentResource;
                }
                {
                    e = null;
                    session.close();
                }
            }
            Iterator it = files.entrySet().iterator();
            while (it.hasNext()) {
                Object var13_17;
                Map.Entry entry = it.next();
                Command.KSubstOption ksubst = (Command.KSubstOption)entry.getKey();
                Set set = (Set)entry.getValue();
                Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot(), true);
                session.open(Policy.subMonitorFor(progress, 2), true);
                try {
                    IStatus status = Command.ADD.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{ksubst}, set.toArray(new ICVSResource[set.size()]), null, Policy.subMonitorFor(progress, 8));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable throwable) {
                    var13_17 = null;
                    session.close();
                    throw throwable;
                }
                {
                    var13_17 = null;
                    session.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            progress.done();
            throw throwable;
        }
        {
            Object var15_21 = null;
        }
        progress.done();
    }

    private boolean isManaged(ICVSResource cvsResource) throws CVSException {
        return cvsResource.isManaged() && (!cvsResource.isFolder() || ((ICVSFolder)cvsResource).isCVSFolder());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkin(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        IStatus status;
        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
        localOptions.add(Commit.makeArgumentOption(Command.MESSAGE_OPTION, this.comment));
        if (depth != 2) {
            localOptions.add(Commit.DO_NOT_RECURSE);
        }
        Command.LocalOption[] commandOptions = localOptions.toArray(new Command.LocalOption[localOptions.size()]);
        String[] arguments = this.getValidArguments(resources, commandOptions);
        Session s = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot());
        progress.beginTask(null, 100);
        try {
            s.open(Policy.subMonitorFor(progress, 20), true);
            status = Command.COMMIT.execute(s, Command.NO_GLOBAL_OPTIONS, commandOptions, arguments, null, Policy.subMonitorFor(progress, 80));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            s.close();
            progress.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
            s.close();
        }
        progress.done();
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(IResource[] resources, IProgressMonitor progress) throws TeamException {
        block16: {
            block15: {
                try {
                    IStatus status;
                    progress.beginTask(null, 100);
                    final IProgressMonitor subProgress = Policy.infiniteSubMonitorFor(progress, 30);
                    subProgress.beginTask(null, 256);
                    final ArrayList<String> files = new ArrayList<String>(resources.length);
                    final TeamException[] eHolder = new TeamException[1];
                    int i = 0;
                    while (true) {
                        block14: {
                            if (i >= resources.length) {
                                subProgress.done();
                                if (eHolder[0] == null) break;
                                throw eHolder[0];
                            }
                            IResource resource = resources[i];
                            this.checkIsChild(resource);
                            try {
                                if (resource.exists()) {
                                    resource.accept(new IResourceVisitor(){

                                        public boolean visit(IResource resource) {
                                            try {
                                                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
                                                if (cvsResource.isManaged()) {
                                                    String name = resource.getProjectRelativePath().toString();
                                                    if (resource.getType() == 1) {
                                                        files.add(name);
                                                        ((IFile)resource).delete(false, true, subProgress);
                                                    }
                                                }
                                            }
                                            catch (TeamException e) {
                                                eHolder[0] = e;
                                            }
                                            catch (CoreException e) {
                                                eHolder[0] = CVSTeamProvider.wrapException(e);
                                                return false;
                                            }
                                            return true;
                                        }
                                    }, 2, false);
                                    break block14;
                                }
                                if (resource.getType() == 1) {
                                    files.add(resource.getProjectRelativePath().toString());
                                }
                            }
                            catch (CoreException e) {
                                throw CVSTeamProvider.wrapException(e);
                            }
                        }
                        ++i;
                    }
                    if (files.isEmpty()) {
                        Object var10_12 = null;
                        break block15;
                    }
                    Session s = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot());
                    s.open(Policy.subMonitorFor(progress, 10), true);
                    try {
                        status = Command.REMOVE.execute(s, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, files.toArray(new String[files.size()]), null, Policy.subMonitorFor(progress, 60));
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        s.close();
                        throw throwable;
                    }
                    {
                        Object var8_11 = null;
                        s.close();
                    }
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    progress.done();
                    throw throwable;
                }
            }
            progress.done();
            return;
        }
        Object var10_14 = null;
        progress.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void diff(IResource resource, Command.LocalOption[] options, PrintStream stream, IProgressMonitor progress) throws TeamException {
        String[] arguments;
        ICVSFolder commandRoot;
        boolean includeNewFiles = false;
        boolean doNotRecurse = false;
        int format = 2;
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
        if (cvsResource.isFolder()) {
            commandRoot = (ICVSFolder)cvsResource;
            arguments = new String[]{"."};
        } else {
            commandRoot = cvsResource.getParent();
            arguments = new String[]{cvsResource.getName()};
        }
        Session s = new Session(this.workspaceRoot.getRemoteLocation(), commandRoot);
        progress.beginTask(null, 100);
        try {
            s.open(Policy.subMonitorFor(progress, 20), false);
            Command.DIFF.execute(s, Command.NO_GLOBAL_OPTIONS, options, arguments, (ICommandOutputListener)new DiffListener(stream), Policy.subMonitorFor(progress, 80));
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            s.close();
            progress.done();
            throw throwable;
        }
        {
            Object var12_15 = null;
            s.close();
        }
        progress.done();
        int i = 0;
        while (true) {
            if (i >= options.length) {
                if (includeNewFiles) {
                    this.newFileDiff(commandRoot, stream, doNotRecurse, format);
                }
                return;
            }
            Command.LocalOption option = options[i];
            if (option.equals(Diff.INCLUDE_NEWFILES)) {
                includeNewFiles = true;
            } else if (option.equals(Diff.DO_NOT_RECURSE)) {
                doNotRecurse = true;
            } else if (option.equals(Diff.UNIFIED_FORMAT)) {
                format = 0;
            } else if (option.equals(Diff.CONTEXT_FORMAT)) {
                format = 1;
            }
            ++i;
        }
    }

    private void newFileDiff(final ICVSResource resource, final PrintStream stream, final boolean doNotRecurse, final int format) throws CVSException {
        resource.accept(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (!file.isIgnored() && !file.isManaged()) {
                    CVSTeamProvider.this.addFileToDiff(file, stream, format);
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                if (!folder.exists() || folder.isIgnored() || doNotRecurse && !folder.equals(resource)) {
                    return;
                }
                folder.acceptChildren(this);
            }
        });
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFileToDiff(ICVSFile file, PrintStream stream, int format) throws CVSException {
        nullFilePrefix = "";
        newFilePrefix = "";
        positionInfo = "";
        linePrefix = "";
        pathString = file.getIResource().getProjectRelativePath().toString();
        fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
        lines = 0;
        try {
            try {
                while (fileReader.readLine() != null) {
                    ++lines;
                }
                fileReader.close();
                switch (format) {
                    case 0: {
                        nullFilePrefix = "--- ";
                        newFilePrefix = "+++ ";
                        positionInfo = "@@ -0,0 +1," + lines + " @@";
                        linePrefix = "+";
                        break;
                    }
                    case 1: {
                        nullFilePrefix = "*** ";
                        newFilePrefix = "--- ";
                        positionInfo = "--- 1," + lines + " ----";
                        linePrefix = "+ ";
                        break;
                    }
                    default: {
                        positionInfo = "0a1," + lines;
                        linePrefix = "> ";
                    }
                }
                fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
                stream.println("Index: " + pathString);
                stream.println("===================================================================");
                stream.println("RCS file: " + pathString);
                stream.println("diff -N " + pathString);
                if (lines > 0) {
                    if (format != 2) {
                        stream.println(String.valueOf(nullFilePrefix) + "/dev/null\t1 Jan 1970 00:00:00 -0000");
                        stream.println(String.valueOf(newFilePrefix) + pathString + "\t1 Jan 1970 00:00:00 -0000");
                    }
                    if (format == 1) {
                        stream.println("***************");
                        stream.println("*** 0 ****");
                    }
                    stream.println(positionInfo);
                    i = 0;
                    while (i < lines) {
                        stream.print(linePrefix);
                        stream.println(fileReader.readLine());
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                throw CVSException.wrapException(file.getIResource(), Policy.bind("CVSTeamProvider.errorAddingFileToDiff", pathString), e);
            }
            var12_15 = null;
            ** GOTO lbl60
        }
        catch (Throwable var13_13) {
            var12_14 = null;
            try {
                fileReader.close();
                throw var13_13;
lbl60:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [3 : 464->472)] { 
lbl61:
                // 1 sources

                fileReader.close();
                return;
            }
            catch (IOException v0) {}
            throw var13_13;
        }
lbl65:
        // 1 sources

        catch (IOException v1) {
            return;
        }
    }

    public ICVSRepositoryLocation getRemoteLocation() throws CVSException {
        try {
            return this.workspaceRoot.getRemoteLocation();
        }
        catch (CVSException e) {
            try {
                RepositoryProvider.unmap((IProject)this.project);
            }
            catch (TeamException ex) {
                CVSProviderPlugin.log((CoreException)((Object)ex));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeBranch(IResource[] resources, CVSTag versionTag, CVSTag branchTag, boolean moveToBranch, IProgressMonitor monitor) throws TeamException {
        int totalWork = (versionTag != null ? 60 : 40) + (moveToBranch ? 20 : 0);
        monitor.beginTask(Policy.bind("CVSTeamProvider.makeBranch"), totalWork);
        try {
            IStatus status;
            block14: {
                ICVSResource[] arguments;
                block15: {
                    Object var10_15;
                    arguments = this.getCVSArguments(resources);
                    status = null;
                    if (versionTag == null) break block15;
                    Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot(), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, versionTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        session.close();
                        throw throwable;
                    }
                    {
                        var10_15 = null;
                        session.close();
                    }
                    if (!status.isOK()) break block14;
                    session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot(), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, branchTag, arguments, null, Policy.subMonitorFor(monitor, 15));
                    }
                    catch (Throwable throwable) {
                        var10_15 = null;
                        session.close();
                        throw throwable;
                    }
                    {
                        var10_15 = null;
                        session.close();
                        break block14;
                    }
                }
                Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot(), true);
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try {
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, branchTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    session.close();
                    throw throwable;
                }
                {
                    Object var10_17 = null;
                    session.close();
                }
            }
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
            if (moveToBranch) {
                this.setTag(resources, branchTag, Policy.subMonitorFor(monitor, 20));
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var12_20 = null;
        }
        monitor.done();
    }

    public void merged(IRemoteSyncElement[] elements) throws TeamException {
        int i = 0;
        while (i < elements.length) {
            ((CVSRemoteSyncElement)elements[i]).makeOutgoing(Policy.monitorFor(null));
            ++i;
        }
    }

    public void moved(IPath source, IResource resource, IProgressMonitor progress) throws TeamException {
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean setConnectionInfo(IResource resource, String methodName, IUserInfo userInfo, IProgressMonitor monitor) throws TeamException {
        block6: {
            this.checkIsChild(resource);
            try {
                monitor.beginTask(Policy.bind("CVSTeamProvider.connectionInfo", this.project.getName()), 100);
                if (CVSRepositoryLocation.validateConnectionMethod(methodName)) break block6;
                Object var9_5 = null;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return false;
        }
        ICVSRepositoryLocation location = this.workspaceRoot.getRemoteLocation();
        CVSRepositoryLocation newLocation = CVSRepositoryLocation.fromString(location.getLocation());
        newLocation.setMethod(methodName);
        newLocation.setUserInfo(userInfo);
        boolean isKnown = CVSProviderPlugin.getPlugin().isKnownRepository(newLocation.getLocation());
        try {
            newLocation.validateConnection(Policy.subMonitorFor(monitor, 20));
        }
        catch (CVSException e) {
            if (!isKnown) {
                CVSProviderPlugin.getPlugin().disposeRepository(newLocation);
            }
            throw e;
        }
        CVSProviderPlugin.getPlugin().addRepository(newLocation);
        this.setRemoteRoot(newLocation, Policy.subMonitorFor(monitor, 80));
        Object var9_6 = null;
        monitor.done();
        return true;
    }

    private void setTag(final IResource[] resources, final CVSTag tag, IProgressMonitor monitor) throws TeamException {
        this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor progress) throws CVSException {
                try {
                    progress.beginTask(null, 100);
                    IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                    monitor.beginTask(Policy.bind("CVSTeamProvider.folderInfo", CVSTeamProvider.this.project.getName()), 512);
                    int i = 0;
                    while (i < resources.length) {
                        CVSWorkspaceRoot.getCVSResourceFor(resources[i]).accept(new ICVSResourceVisitor(this, monitor, tag){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ CVSTag val$tag;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$tag = cVSTag;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                                this.val$monitor.worked(1);
                                byte[] syncBytes = file.getSyncBytes();
                                if (syncBytes != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFile", file.getName()));
                                    file.setSyncBytes(ResourceSyncInfo.setTag(syncBytes, this.val$tag), 0);
                                }
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFolder", info.getRepository()));
                                    folder.setFolderSyncInfo(new FolderSyncInfo(info.getRepository(), info.getRoot(), this.val$tag, info.getIsStatic()));
                                    folder.acceptChildren(this);
                                }
                            }
                        });
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    progress.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                progress.done();
            }
        }, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(IResource[] resources, Command.LocalOption[] options, CVSTag tag, boolean createBackups, IProgressMonitor progress) throws TeamException {
        progress.beginTask(null, 100);
        Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot(), true);
        session.open(Policy.subMonitorFor(progress, 10), false);
        try {
            this.update(session, resources, options, tag, createBackups, Policy.subMonitorFor(progress, 90));
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            session.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
            session.close();
            return;
        }
    }

    private void update(Session session, IResource[] resources, Command.LocalOption[] options, CVSTag tag, boolean createBackups, IProgressMonitor progress) throws TeamException {
        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
        if (tag != null) {
            localOptions.add(Update.makeTagOption(tag));
        }
        localOptions.addAll(Arrays.asList(options));
        Command.LocalOption[] commandOptions = localOptions.toArray(new Command.LocalOption[localOptions.size()]);
        ICVSResource[] arguments = this.getCVSArguments(resources);
        IStatus status = Command.UPDATE.execute(session, Command.NO_GLOBAL_OPTIONS, commandOptions, arguments, null, progress);
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
    }

    public void refreshState(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        Assert.isTrue(false);
    }

    public boolean isDirty(IResource resource) {
        Assert.isTrue(false);
        return false;
    }

    public CVSWorkspaceRoot getCVSWorkspaceRoot() {
        return this.workspaceRoot;
    }

    private void checkIsChild(IResource resource) throws CVSException {
        if (!this.isChildResource(resource)) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSTeamProvider.invalidResource", new Object[]{resource.getFullPath().toString(), this.project.getName()}), null));
        }
    }

    private String[] getValidArguments(IResource[] resources, Command.LocalOption[] options) throws CVSException {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        int i = 0;
        while (i < resources.length) {
            this.checkIsChild(resources[i]);
            IPath cvsPath = resources[i].getFullPath().removeFirstSegments(1);
            if (cvsPath.segmentCount() == 0) {
                arguments.add(".");
            } else {
                arguments.add(cvsPath.toString());
            }
            ++i;
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private ICVSResource[] getCVSArguments(IResource[] resources) {
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        int i = 0;
        while (i < cvsResources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor(resources[i]);
            ++i;
        }
        return cvsResources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRemoteRoot(ICVSRepositoryLocation location, IProgressMonitor monitor) throws TeamException {
        final String root = location.getLocation();
        if (root.equals(this.workspaceRoot.getRemoteLocation())) {
            return;
        }
        try {
            this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progress) throws CVSException {
                    try {
                        progress.beginTask(null, 100);
                        IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                        monitor.beginTask(Policy.bind("CVSTeamProvider.folderInfo", CVSTeamProvider.this.project.getName()), 256);
                        CVSTeamProvider.this.workspaceRoot.getLocalRoot().accept(new ICVSResourceVisitor(this, monitor, root){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ String val$root;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$root = string;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFolder", info.getRepository()));
                                    folder.setFolderSyncInfo(new FolderSyncInfo(info.getRepository(), this.val$root, info.getTag(), info.getIsStatic()));
                                    folder.acceptChildren(this);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        progress.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    progress.done();
                }
            }, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    private boolean isChildResource(IResource resource) {
        return resource.getProject().getName().equals(this.project.getName());
    }

    private static TeamException wrapException(CoreException e) {
        return CVSException.wrapException(e);
    }

    public void configureProject() throws CoreException {
        ResourceStateChangeListeners.getListener().projectConfigured(this.getProject());
    }

    public IStatus setKeywordSubstitution(final Map changeSet, final String comment, IProgressMonitor monitor) throws TeamException {
        final IStatus[] result = new IStatus[]{ICommandOutputListener.OK};
        this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CVSException {
                Command.KSubstOption toKSubst;
                HashMap<Command.KSubstOption, ArrayList<ICVSFile>> filesToAdmin = new HashMap<Command.KSubstOption, ArrayList<ICVSFile>>();
                ArrayList<ICVSFile> filesToCommit = new ArrayList<ICVSFile>();
                HashSet<ICVSFile> filesToCommitAsText = new HashSet<ICVSFile>();
                Iterator it = changeSet.entrySet().iterator();
                while (it.hasNext()) {
                    byte[] syncBytes;
                    Command.KSubstOption fromKSubst;
                    Map.Entry entry = it.next();
                    IFile file = (IFile)entry.getKey();
                    toKSubst = (Command.KSubstOption)entry.getValue();
                    CVSTeamProvider.this.checkIsChild((IResource)file);
                    ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor(file);
                    if (!mFile.isManaged() || toKSubst.equals(fromKSubst = ResourceSyncInfo.getKeywordMode(syncBytes = mFile.getSyncBytes()))) continue;
                    if (ResourceSyncInfo.isAddition(syncBytes)) {
                        mFile.setSyncBytes(ResourceSyncInfo.setKeywordMode(syncBytes, toKSubst), 0);
                        continue;
                    }
                    if (ResourceSyncInfo.isDeletion(syncBytes)) continue;
                    if (fromKSubst.isBinary() && !toKSubst.isBinary()) {
                        CVSTeamProvider.cleanLineDelimiters(file, IS_CRLF_PLATFORM, (IProgressMonitor)new NullProgressMonitor());
                        filesToCommitAsText.add(mFile);
                    }
                    CVSTeamProvider.makeDirty(file);
                    filesToCommit.add(mFile);
                    ArrayList<ICVSFile> list = (ArrayList<ICVSFile>)filesToAdmin.get(toKSubst);
                    if (list == null) {
                        list = new ArrayList<ICVSFile>();
                        filesToAdmin.put(toKSubst, list);
                    }
                    list.add(mFile);
                }
                int totalWork = filesToCommit.size() + 1;
                Iterator<Object> it2 = filesToAdmin.values().iterator();
                while (it2.hasNext()) {
                    List list = (List)it2.next();
                    totalWork += list.size();
                    ++totalWork;
                }
                if (totalWork == 0) return;
                monitor.beginTask(Policy.bind("CVSTeamProvider.settingKSubst"), totalWork);
                try {
                    if (filesToCommit.size() != 0) {
                        Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                        session.open(Policy.subMonitorFor(monitor, 1), true);
                        try {
                            String keywordChangeComment = comment;
                            if (keywordChangeComment == null || keywordChangeComment.length() == 0) {
                                keywordChangeComment = Policy.bind("CVSTeamProvider.changingKeywordComment");
                            }
                            result[0] = Command.COMMIT.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Commit.DO_NOT_RECURSE, Commit.FORCE, Commit.makeArgumentOption(Command.MESSAGE_OPTION, keywordChangeComment)}, filesToCommit.toArray(new ICVSResource[filesToCommit.size()]), filesToCommitAsText, null, Policy.subMonitorFor(monitor, filesToCommit.size()));
                            toKSubst = null;
                            session.close();
                        }
                        catch (Throwable mFile) {
                            toKSubst = null;
                            session.close();
                            throw mFile;
                        }
                        if (!result[0].isOK()) {
                            Object var13_16 = null;
                            monitor.done();
                            return;
                        }
                    }
                    it2 = filesToAdmin.entrySet().iterator();
                    while (it2.hasNext()) {
                        Object var11_13;
                        Map.Entry entry = (Map.Entry)it2.next();
                        toKSubst = (Command.KSubstOption)entry.getKey();
                        List list = (List)entry.getValue();
                        Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                        session.open(Policy.subMonitorFor(monitor, 1), true);
                        try {
                            result[0] = Command.ADMIN.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{toKSubst}, list.toArray(new ICVSResource[list.size()]), (ICommandOutputListener)new AdminKSubstListener(toKSubst), Policy.subMonitorFor(monitor, list.size()));
                            var11_13 = null;
                            session.close();
                        }
                        catch (Throwable throwable) {
                            var11_13 = null;
                            session.close();
                            throw throwable;
                        }
                        if (result[0].isOK()) continue;
                        Object var13_17 = null;
                        monitor.done();
                        return;
                    }
                    Object var13_19 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        }, Policy.monitorFor(monitor));
        return result[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanLineDelimiters(IFile file, boolean useCRLF, IProgressMonitor progress) throws CVSException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream is = new BufferedInputStream(file.getContents());
            try {
                is = new CRLFtoLFInputStream((InputStream)is);
                if (useCRLF) {
                    is = new LFtoCRLFInputStream((InputStream)is);
                }
                while (true) {
                    int b;
                    block8: {
                        if ((b = ((InputStream)is).read()) != -1) break block8;
                        bos.close();
                        break;
                    }
                    bos.write(b);
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            {
                Object var6_11 = null;
            }
            ((InputStream)is).close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            file.setContents((InputStream)bis, false, false, progress);
            return;
        }
        catch (CoreException e) {
            throw CVSException.wrapException((IResource)file, Policy.bind("CVSTeamProvider.cleanLineDelimitersException"), e);
        }
        catch (IOException e) {
            throw CVSException.wrapException((IResource)file, Policy.bind("CVSTeamProvider.cleanLineDelimitersException"), e);
        }
    }

    private static void makeDirty(IFile file) throws CVSException {
        ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor(file);
        ResourceSyncInfo origInfo = mFile.getSyncInfo();
        MutableResourceSyncInfo info = origInfo.cloneMutable();
        info.setTimeStamp(null);
        mFile.setSyncInfo(info, 0);
    }

    public String getID() {
        return CVSProviderPlugin.getTypeId();
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return moveDeleteHook;
    }

    public static MoveDeleteHook getRegisteredMoveDeleteHook() {
        return moveDeleteHook;
    }

    public IFileModificationValidator getFileModificationValidator() {
        if (fileModificationValidator == null && (fileModificationValidator = CVSTeamProvider.getPluggedInValidator()) == null) {
            fileModificationValidator = super.getFileModificationValidator();
        }
        return fileModificationValidator;
    }

    public void edit(IResource[] resources, boolean recurse, boolean notifyServer, final int notification, IProgressMonitor progress) throws CVSException {
        this.notifyEditUnedit(resources, recurse, notifyServer, new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (file.isReadOnly()) {
                    file.edit(notification, Policy.monitorFor(null));
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
            }
        }, progress);
    }

    public void unedit(IResource[] resources, boolean recurse, boolean notifyServer, IProgressMonitor progress) throws CVSException {
        this.notifyEditUnedit(resources, recurse, notifyServer, new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (!file.isReadOnly()) {
                    file.unedit(Policy.monitorFor(null));
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
            }
        }, progress);
    }

    private void notifyEditUnedit(final IResource[] resources, final boolean recurse, final boolean notifyServer, final ICVSResourceVisitor editUneditVisitor, IProgressMonitor monitor) throws CVSException {
        final CVSException[] exception = new CVSException[1];
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSResource[] cvsResources = CVSTeamProvider.this.getCVSArguments(resources);
                try {
                    int i = 0;
                    while (i < cvsResources.length) {
                        cvsResources[i].accept(editUneditVisitor, recurse);
                        ++i;
                    }
                }
                catch (CVSException e) {
                    exception[0] = e;
                    return;
                }
                if (!notifyServer) return;
                monitor.beginTask(null, 100);
                Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                try {
                    try {
                        try {
                            session.open(Policy.subMonitorFor(monitor, 10), true);
                        }
                        catch (CVSException cVSException) {
                            Object var5_6 = null;
                            session.close();
                            monitor.done();
                            return;
                        }
                        Command.NOOP.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, cvsResources, null, Policy.subMonitorFor(monitor, 90));
                    }
                    catch (CVSException e) {
                        exception[0] = e;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    session.close();
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    session.close();
                }
                monitor.done();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)this.getProject(), Policy.monitorFor(monitor));
        }
        catch (CoreException e) {
            if (exception[0] == null) {
                throw CVSException.wrapException(e);
            }
            CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e)));
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public boolean getFetchAbsentDirectories() throws CVSException {
        try {
            String property = this.getProject().getPersistentProperty(FETCH_ABSENT_DIRECTORIES_PROP_KEY);
            if (property == null) {
                return CVSProviderPlugin.getPlugin().getFetchAbsentDirectories();
            }
            return Boolean.valueOf(property);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorGettingFetchProperty", this.project.getName()), e));
        }
    }

    public void setFetchAbsentDirectories(boolean fetchAbsentDirectories) throws CVSException {
        try {
            this.getProject().setPersistentProperty(FETCH_ABSENT_DIRECTORIES_PROP_KEY, fetchAbsentDirectories ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorSettingFetchProperty", this.project.getName()), e));
        }
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, IPath location) {
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource.getParent().getFolder((IPath)new Path(resource.getName())));
        try {
            if (cvsFolder.isCVSFolder()) {
                return new CVSStatus(4, Policy.bind("CVSTeamProvider.overlappingRemoteFolder", resource.getFullPath().toString()));
            }
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor(resource.getParent().getFile((IPath)new Path(resource.getName())));
            if (cvsFile.isManaged()) {
                return new CVSStatus(4, Policy.bind("CVSTeamProvider.overlappingFileDeletion", resource.getFullPath().toString()));
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return e.getStatus();
        }
        return super.validateCreateLink(resource, updateFlags, location);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EditorsInfo[] editors(IResource[] resources, IProgressMonitor progress) throws CVSException {
        Command.LocalOption[] commandOptions = new Command.LocalOption[]{};
        String[] arguments = this.getValidArguments(resources, commandOptions);
        EditorsListener listener = new EditorsListener();
        if (progress.isCanceled()) {
            return new EditorsInfo[0];
        }
        Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot());
        if (progress.isCanceled()) {
            return new EditorsInfo[0];
        }
        progress.beginTask(null, 100);
        try {
            session.open(Policy.subMonitorFor(progress, 20), false);
            if (!progress.isCanceled()) {
                Command.EDITORS.execute(session, Command.NO_GLOBAL_OPTIONS, commandOptions, arguments, (ICommandOutputListener)listener, Policy.subMonitorFor(progress, 80));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            session.close();
            progress.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
            session.close();
        }
        progress.done();
        return listener.getEditorsInfos();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCommitTemplate() throws CVSException {
        ICVSFolder localFolder = this.getCVSWorkspaceRoot().getLocalRoot();
        ICVSFile templateFile = CVSWorkspaceRoot.getCVSFileFor(SyncFileWriter.getTemplateFile((IContainer)localFolder.getIResource()));
        if (!templateFile.exists()) {
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(templateFile.getContents());
        try {
            try {
                int b;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                do {
                    if ((b = ((InputStream)in).read()) == -1) continue;
                    out.write((byte)b);
                } while (b != -1);
                out.close();
                String string = new String(out.toString());
                Object var6_8 = null;
                try {
                    ((InputStream)in).close();
                    return string;
                }
                catch (IOException e2) {
                    CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e2)));
                }
                return string;
            }
            catch (IOException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (IOException e2) {
                CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e2)));
                throw throwable;
            }
            ((InputStream)in).close();
            throw throwable;
        }
    }

    public boolean isWatchEditEnabled() throws CVSException {
        try {
            IProject project = this.getProject();
            String property = (String)project.getSessionProperty(WATCH_EDIT_PROP_KEY);
            if (property == null) {
                property = project.getPersistentProperty(WATCH_EDIT_PROP_KEY);
                if (property == null) {
                    return CVSProviderPlugin.getPlugin().isWatchEditEnabled();
                }
                project.setSessionProperty(WATCH_EDIT_PROP_KEY, (Object)property);
            }
            return Boolean.valueOf(property);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorGettingWatchEdit", this.project.getName()), e));
        }
    }

    public void setWatchEditEnabled(boolean enabled) throws CVSException {
        try {
            IProject project = this.getProject();
            project.setPersistentProperty(WATCH_EDIT_PROP_KEY, enabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            project.setSessionProperty(WATCH_EDIT_PROP_KEY, (Object)(enabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorSettingWatchEdit", this.project.getName()), e));
        }
    }
}

