/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.Policy;

public class CVSTag {
    public static final int HEAD = 0;
    public static final int BRANCH = 1;
    public static final int VERSION = 2;
    public static final int DATE = 3;
    public static final CVSTag DEFAULT = new CVSTag();
    public static final CVSTag BASE = new CVSTag("BASE", 2);
    protected String name;
    protected int type;

    public CVSTag() {
        this("HEAD", 0);
    }

    public CVSTag(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CVSTag)) {
            return false;
        }
        CVSTag tag = (CVSTag)other;
        if (this.getType() != tag.getType()) {
            return false;
        }
        return this.getName().equals(tag.getName());
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(CVSTag other) {
        return this.getName().compareTo(other.getName());
    }

    public static boolean equalTags(CVSTag tag1, CVSTag tag2) {
        if (tag1 == null) {
            tag1 = DEFAULT;
        }
        if (tag2 == null) {
            tag2 = DEFAULT;
        }
        return tag1.equals(tag2);
    }

    public static IStatus validateTagName(String tagName) {
        if (tagName == null) {
            return new CVSStatus(4, Policy.bind("CVSTag.nullName"));
        }
        if (tagName.equals("")) {
            return new CVSStatus(4, Policy.bind("CVSTag.emptyName"));
        }
        if (!Character.isLetter(tagName.charAt(0))) {
            return new CVSStatus(4, Policy.bind("CVSTag.beginName"));
        }
        int i = 0;
        while (i < tagName.length()) {
            char c = tagName.charAt(i);
            if (Character.isSpaceChar(c) || c == '$' || c == ',' || c == '.' || c == ':' || c == ';' || c == '@' || c == '|') {
                return new CVSStatus(4, Policy.bind("CVSTag.badCharName"));
            }
            ++i;
        }
        return new CVSStatus(0, Policy.bind("ok"));
    }
}

