/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ComparisonCriteria;
import org.eclipse.team.core.subscribers.ContentComparisonCriteria;
import org.eclipse.team.core.subscribers.RemoteSynchronizer;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamDelta;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSRevisionNumberCompareCriteria;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;

public abstract class CVSSyncTreeSubscriber
extends TeamSubscriber {
    private QualifiedName id;
    private String name;
    private String description;
    private Map comparisonCriterias = new HashMap();
    private String defaultCriteria;

    CVSSyncTreeSubscriber(QualifiedName id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.initializeComparisonCriteria();
    }

    protected void initializeComparisonCriteria() {
        CVSRevisionNumberCompareCriteria revisionNumberComparator = new CVSRevisionNumberCompareCriteria();
        ContentComparisonCriteria contentsComparator = new ContentComparisonCriteria(new ComparisonCriteria[]{revisionNumberComparator}, false);
        ContentComparisonCriteria contentsComparatorIgnoreWhitespace = new ContentComparisonCriteria(new ComparisonCriteria[]{revisionNumberComparator}, true);
        this.addComparisonCriteria(revisionNumberComparator);
        this.addComparisonCriteria((ComparisonCriteria)contentsComparator);
        this.addComparisonCriteria((ComparisonCriteria)contentsComparatorIgnoreWhitespace);
        this.defaultCriteria = revisionNumberComparator.getId();
    }

    protected void addComparisonCriteria(ComparisonCriteria comparator) {
        this.comparisonCriterias.put(comparator.getId(), comparator);
    }

    public QualifiedName getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource.getType() == 1) {
            return new IResource[0];
        }
        try {
            IResource[] members;
            try {
                members = ((IContainer)resource).members(true);
            }
            catch (CoreException e) {
                if (!this.isSupervised(resource) || e.getStatus().getCode() == 368) {
                    return new IResource[0];
                }
                throw e;
            }
            ArrayList<IResource> filteredMembers = new ArrayList<IResource>(members.length);
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if ((!member.isPhantom() || this.getRemoteSynchronizer().hasRemote(member)) && this.isSupervised(resource)) {
                    filteredMembers.add(member);
                }
                ++i;
            }
            return filteredMembers.toArray(new IResource[filteredMembers.size()]);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    public IResource[] roots() {
        return null;
    }

    public IRemoteResource getRemoteResource(IResource resource) throws TeamException {
        return this.getRemoteSynchronizer().getRemoteResource(resource);
    }

    public IRemoteResource getBaseResource(IResource resource) throws TeamException {
        return this.getBaseSynchronizer().getRemoteResource(resource);
    }

    protected abstract RemoteSynchronizer getRemoteSynchronizer();

    protected abstract RemoteSynchronizer getBaseSynchronizer();

    public SyncInfo getSyncInfo(IResource resource, IProgressMonitor monitor) throws TeamException {
        if (!this.isSupervised(resource)) {
            return null;
        }
        IRemoteResource remoteResource = this.getRemoteResource(resource);
        if (resource.getType() == 1) {
            IRemoteResource baseResource = this.getBaseResource(resource);
            return this.getSyncInfo(resource, baseResource, remoteResource, monitor);
        }
        return this.getSyncInfo(resource, remoteResource, remoteResource, monitor);
    }

    protected SyncInfo getSyncInfo(IResource local, IRemoteResource base, IRemoteResource remote, IProgressMonitor monitor) throws TeamException {
        CVSSyncInfo cVSSyncInfo;
        try {
            CVSSyncInfo info;
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            cVSSyncInfo = info = new CVSSyncInfo(local, base, remote, this, Policy.subMonitorFor(monitor, 100));
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return cVSSyncInfo;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        try {
            monitor.beginTask(null, 100 * resources.length);
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                IStatus status = this.refresh(resource, depth, Policy.subMonitorFor(monitor, 100));
                if (!status.isOK()) {
                    errors.add(status);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
        if (!errors.isEmpty()) {
            throw new CVSException((IStatus)new MultiStatus("org.eclipse.team.cvs.core", 0, errors.toArray(new IStatus[errors.size()]), Policy.bind("CVSSyncTreeSubscriber.1", this.getName()), null));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus refresh(IResource resource, int depth, IProgressMonitor monitor) {
        IStatus iStatus;
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                int baseWork = this.getCacheFileContentsHint() ? 10 : 30;
                int remoteWork = 100;
                monitor.beginTask(null, baseWork + remoteWork);
                IResource[] baseChanges = this.refreshBase(resource, depth, Policy.subMonitorFor(monitor, baseWork));
                IResource[] remoteChanges = this.refreshRemote(resource, depth, Policy.subMonitorFor(monitor, remoteWork));
                HashSet<IResource> allChanges = new HashSet<IResource>();
                allChanges.addAll(Arrays.asList(remoteChanges));
                allChanges.addAll(Arrays.asList(baseChanges));
                IResource[] changedResources = allChanges.toArray(new IResource[allChanges.size()]);
                this.fireTeamResourceChange(TeamDelta.asSyncChangedDeltas((TeamSubscriber)this, (IResource[])changedResources));
                iStatus = Status.OK_STATUS;
                Object var10_13 = null;
            }
            catch (TeamException e) {
                CVSStatus cVSStatus = new CVSStatus(4, Policy.bind("CVSSyncTreeSubscriber.2", resource.getFullPath().toString(), e.getMessage()), e);
                Object var10_14 = null;
                monitor.done();
                return cVSStatus;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iStatus;
    }

    protected IResource[] refreshBase(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        return this.getBaseSynchronizer().refresh(resource, depth, this.getCacheFileContentsHint(), monitor);
    }

    protected IResource[] refreshRemote(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        return this.getRemoteSynchronizer().refresh(resource, depth, this.getCacheFileContentsHint(), monitor);
    }

    public ComparisonCriteria getCurrentComparisonCriteria() {
        return (ComparisonCriteria)this.comparisonCriterias.get(this.defaultCriteria);
    }

    private boolean getCacheFileContentsHint() {
        return this.getCurrentComparisonCriteria().usesFileContents();
    }

    public void setCurrentComparisonCriteria(String id) throws TeamException {
        if (!this.comparisonCriterias.containsKey(id)) {
            throw new CVSException(Policy.bind("CVSSyncTreeSubscriber.0", id, this.getName()));
        }
        this.defaultCriteria = id;
    }

    public ComparisonCriteria[] getComparisonCriterias() {
        return this.comparisonCriterias.values().toArray(new ComparisonCriteria[this.comparisonCriterias.size()]);
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        try {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
            if (provider == null) {
                return false;
            }
            ICVSResource cvsThing = CVSWorkspaceRoot.getCVSResourceFor(resource);
            if (cvsThing.isIgnored()) {
                return this.getRemoteSynchronizer().hasRemote(resource);
            }
            return true;
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() == 368) {
                return false;
            }
            throw e;
        }
    }

    public boolean isThreeWay() {
        return true;
    }

    public boolean isCancellable() {
        return false;
    }

    public void cancel() {
    }
}

