/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.subscribers.ComparisonCriteria;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class CVSRevisionNumberCompareCriteria
extends ComparisonCriteria {
    public String getName() {
        return Policy.bind("CVSRevisionNumberCompareCriteria.1");
    }

    public String getId() {
        return "org.eclipse.team.cvs.revisioncomparator";
    }

    public boolean compare(Object e1, Object e2, IProgressMonitor monitor) {
        if (e1 instanceof IResource && e2 instanceof IRemoteResource) {
            return this.compare((IResource)e1, (IRemoteResource)e2);
        }
        if (e1 instanceof IRemoteResource && e2 instanceof IRemoteResource) {
            return this.compare((IRemoteResource)e1, (IRemoteResource)e2);
        }
        return false;
    }

    protected boolean compare(IRemoteResource e1, IRemoteResource e2) {
        if (e1.isContainer()) {
            return e2.isContainer();
        }
        return e1.equals(e2);
    }

    protected boolean compare(IResource e1, IRemoteResource e2) {
        if (e1.getType() != 1) {
            return e2.isContainer();
        }
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)e1);
        try {
            byte[] syncBytes1 = cvsFile.getSyncBytes();
            byte[] syncBytes2 = ((ICVSRemoteFile)e2).getSyncBytes();
            if (syncBytes1 != null) {
                if (ResourceSyncInfo.isDeletion(syncBytes1) || ResourceSyncInfo.isMerge(syncBytes1) || cvsFile.isModified(null)) {
                    return false;
                }
                return ResourceSyncInfo.getRevision(syncBytes1).equals(ResourceSyncInfo.getRevision(syncBytes2));
            }
            return false;
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    public boolean usesFileContents() {
        return false;
    }
}

