/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ITeamResourceChangeListener;
import org.eclipse.team.core.subscribers.RemoteBytesSynchronizer;
import org.eclipse.team.core.subscribers.RemoteSynchronizer;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamDelta;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSMergeSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.syncinfo.MergedSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.RemoteTagSynchronizer;

public class CVSMergeSubscriber
extends CVSSyncTreeSubscriber
implements IResourceChangeListener,
ITeamResourceChangeListener {
    public static final String QUALIFIED_NAME = "org.eclipse.team.cvs.ui.cvsmerge-participant";
    private static final String UNIQUE_ID_PREFIX = "merge-";
    private CVSTag start;
    private CVSTag end;
    private List roots;
    private RemoteTagSynchronizer remoteSynchronizer;
    private RemoteBytesSynchronizer mergedSynchronizer;
    private RemoteTagSynchronizer baseSynchronizer;
    private static final byte[] NO_REMOTE = new byte[0];

    protected IResource[] refreshRemote(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] remoteChanges = super.refreshRemote(resource, depth, monitor);
        this.adjustMergedResources(remoteChanges);
        return remoteChanges;
    }

    private void adjustMergedResources(IResource[] remoteChanges) throws TeamException {
        int i = 0;
        while (i < remoteChanges.length) {
            IResource resource = remoteChanges[i];
            this.mergedSynchronizer.removeSyncBytes(resource, 0);
            ++i;
        }
    }

    private static QualifiedName getUniqueId() {
        String uniqueId = Long.toString(System.currentTimeMillis());
        return new QualifiedName(QUALIFIED_NAME, "CVSmerge-" + uniqueId);
    }

    public CVSMergeSubscriber(IResource[] roots, CVSTag start, CVSTag end) {
        this(CVSMergeSubscriber.getUniqueId(), roots, start, end);
    }

    public CVSMergeSubscriber(QualifiedName id, IResource[] roots, CVSTag start, CVSTag end) {
        super(id, Policy.bind("CVSMergeSubscriber.2", start.getName(), end.getName()), Policy.bind("CVSMergeSubscriber.4"));
        this.start = start;
        this.end = end;
        this.roots = new ArrayList<IResource>(Arrays.asList(roots));
        this.initialize();
    }

    private void initialize() {
        QualifiedName id = this.getId();
        String syncKeyPrefix = id.getLocalName();
        this.remoteSynchronizer = new RemoteTagSynchronizer(String.valueOf(syncKeyPrefix) + this.end.getName(), this.end);
        this.baseSynchronizer = new RemoteTagSynchronizer(String.valueOf(syncKeyPrefix) + this.start.getName(), this.start);
        this.mergedSynchronizer = new MergedSynchronizer(String.valueOf(syncKeyPrefix) + "0merged");
        try {
            this.setCurrentComparisonCriteria("org.eclipse.team.comparisoncriteria.content.ignore");
        }
        catch (TeamException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().addListener(this);
    }

    protected SyncInfo getSyncInfo(IResource local, IRemoteResource base, IRemoteResource remote, IProgressMonitor monitor) throws TeamException {
        return new CVSMergeSyncInfo(local, base, remote, this, monitor);
    }

    public void merged(IResource[] resources) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            byte[] remoteBytes = this.remoteSynchronizer.getSyncBytes(resource);
            if (remoteBytes == null) {
                remoteBytes = NO_REMOTE;
            }
            this.mergedSynchronizer.setSyncBytes(resource, remoteBytes);
            ++i;
        }
        this.fireTeamResourceChange(TeamDelta.asSyncChangedDeltas((TeamSubscriber)this, (IResource[])resources));
    }

    public void cancel() {
        super.cancel();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.remoteSynchronizer.dispose();
        this.baseSynchronizer.dispose();
        this.mergedSynchronizer.dispose();
    }

    public IResource[] roots() {
        return this.roots.toArray(new IResource[this.roots.size()]);
    }

    protected RemoteSynchronizer getRemoteSynchronizer() {
        return this.remoteSynchronizer;
    }

    protected RemoteSynchronizer getBaseSynchronizer() {
        return this.baseSynchronizer;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return this.getBaseSynchronizer().hasRemote(resource) || this.getRemoteSynchronizer().hasRemote(resource);
    }

    public CVSTag getStartTag() {
        return this.start;
    }

    public CVSTag getEndTag() {
        return this.end;
    }

    public boolean isReleaseSupported() {
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 4) {
                            IProject project = (IProject)resource;
                            if (!project.isAccessible()) {
                                return false;
                            }
                            if ((delta.getFlags() & 0x4000) != 0) {
                                return false;
                            }
                            if (RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) == null) {
                                return false;
                            }
                        }
                        if (CVSMergeSubscriber.this.roots.contains(resource)) {
                            if (delta.getKind() == 2 || delta.getKind() == 8192) {
                                CVSMergeSubscriber.this.cancel();
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e.getStatus());
        }
    }

    public boolean isMerged(IResource resource) throws TeamException {
        return this.mergedSynchronizer.getSyncBytes(resource) != null || this.mergedSynchronizer.isRemoteKnown(resource);
    }

    public void teamResourceChanged(TeamDelta[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            TeamDelta delta = deltas[i];
            switch (delta.getFlags()) {
                case 4: {
                    IResource resource = delta.getResource();
                    if (!this.roots.remove(resource)) break;
                    this.fireTeamResourceChange(new TeamDelta[]{delta});
                }
            }
            ++i;
        }
    }
}

