/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Location;
import org.eclipse.ant.internal.ui.antsupport.AntSecurityException;
import org.eclipse.ant.internal.ui.antsupport.InternalAntMessages;
import org.eclipse.ant.internal.ui.antsupport.logger.MessageIds;

public class RemoteAntBuildLogger
extends DefaultLogger {
    private long startTime = System.currentTimeMillis();
    private Socket fClientSocket;
    private PrintWriter fWriter;
    private String fHost = "";
    private int fPort = -1;
    private boolean fDebugMode = false;
    private boolean fSentProcessId = false;
    private List fEventQueue;

    protected void printMessage(String message, PrintStream stream, int priority) {
        this.marshalMessage(priority, message);
    }

    private void connect() {
        if (this.fDebugMode) {
            System.out.println("RemoteAntBuildLogger: trying to connect" + this.fHost + ":" + this.fPort);
        }
        int i = 1;
        while (i < 5) {
            try {
                this.fClientSocket = new Socket(this.fHost, this.fPort);
                this.fWriter = new PrintWriter(this.fClientSocket.getOutputStream(), true);
                return;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        this.shutDown();
    }

    private void shutDown() {
        if (this.fEventQueue != null) {
            this.fEventQueue.clear();
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fClientSocket != null) {
                this.fClientSocket.close();
                this.fClientSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    private void sendMessage(String msg) {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.println(msg);
    }

    public void buildFinished(BuildEvent event) {
        this.handleException(event);
        this.printMessage(this.getTimeString(System.currentTimeMillis() - this.startTime), this.out, 2);
        this.shutDown();
    }

    protected void handleException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception == null || exception instanceof AntSecurityException) {
            return;
        }
        this.printMessage(MessageFormat.format(InternalAntMessages.getString("RemoteAntBuildLogger.BUILD_FAILED__{0}_1"), exception.toString()), this.out, 0);
    }

    private String getTimeString(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        StringBuffer result = new StringBuffer(InternalAntMessages.getString("RemoteAntBuildLogger.Total_time"));
        if (minutes > 0L) {
            result.append(minutes);
            if (minutes > 1L) {
                result.append(InternalAntMessages.getString("RemoteAntBuildLogger._minutes_2"));
            } else {
                result.append(InternalAntMessages.getString("RemoteAntBuildLogger._minute_3"));
            }
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                result.append(' ');
            }
            result.append(seconds);
            if (seconds > 1L) {
                result.append(InternalAntMessages.getString("RemoteAntBuildLogger._seconds_4"));
            } else {
                result.append(InternalAntMessages.getString("RemoteAntBuildLogger._second_5"));
            }
        }
        if (seconds == 0L && minutes == 0L) {
            result.append(milliseconds);
            result.append(InternalAntMessages.getString("RemoteAntBuildLogger._milliseconds_6"));
        }
        return result.toString();
    }

    public void targetStarted(BuildEvent event) {
        if (!this.fSentProcessId) {
            this.establishConnection(event);
        }
        if (2 <= this.msgOutputLevel) {
            String msg = String.valueOf(event.getTarget().getName()) + ":";
            this.printMessage(msg, this.out, 2);
        }
    }

    private void establishConnection(BuildEvent event) {
        String portProperty = event.getProject().getProperty("eclipse.connect.port");
        if (portProperty != null) {
            this.fPort = Integer.parseInt(portProperty);
            this.connect();
        }
        this.fSentProcessId = true;
        StringBuffer message = new StringBuffer(MessageIds.PROCESS_ID);
        message.append(event.getProject().getProperty("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID"));
        this.sendMessage(message.toString());
        if (this.fEventQueue != null) {
            Iterator iter = this.fEventQueue.iterator();
            while (iter.hasNext()) {
                this.processEvent((BuildEvent)iter.next());
            }
            this.fEventQueue = null;
        }
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > this.msgOutputLevel) {
            return;
        }
        if (!this.fSentProcessId) {
            if (this.fEventQueue == null) {
                this.fEventQueue = new ArrayList(10);
            }
            this.fEventQueue.add(event);
            return;
        }
        this.processEvent(event);
    }

    private void processEvent(BuildEvent event) {
        if (event.getTask() != null & !this.emacsMode) {
            try {
                this.marshalTaskMessage(event);
            }
            catch (IOException iOException) {}
        } else {
            this.marshalMessage(event);
        }
    }

    private void marshalMessage(BuildEvent event) {
        String eventMessage = event.getMessage().trim();
        if (eventMessage.length() == 0) {
            return;
        }
        this.marshalMessage(event.getPriority(), eventMessage);
    }

    private void marshalMessage(int priority, String message) {
        try {
            BufferedReader r = new BufferedReader(new StringReader(message));
            String line = r.readLine();
            while (line != null) {
                StringBuffer messageLine = new StringBuffer();
                messageLine.append(priority);
                messageLine.append(',');
                messageLine.append(line);
                this.sendMessage(messageLine.toString());
                line = r.readLine();
            }
        }
        catch (IOException iOException) {}
    }

    private void marshalTaskMessage(BuildEvent event) throws IOException {
        String eventMessage = event.getMessage().trim();
        if (eventMessage.length() == 0) {
            return;
        }
        BufferedReader r = new BufferedReader(new StringReader(eventMessage));
        String line = r.readLine();
        String taskName = event.getTask().getTaskName();
        StringBuffer labelBuff = new StringBuffer();
        labelBuff.append('[');
        labelBuff.append(taskName);
        labelBuff.append("] ");
        String label = labelBuff.toString();
        Location location = event.getTask().getLocation();
        int priority = event.getPriority();
        while (line != null) {
            StringBuffer message = new StringBuffer(MessageIds.TASK);
            message.append(priority);
            message.append(',');
            message.append(taskName);
            message.append(',');
            line = (String.valueOf(label) + line).trim();
            message.append(line.length());
            message.append(',');
            message.append(line);
            message.append(',');
            message.append(location);
            this.sendMessage(message.toString());
            line = r.readLine();
        }
    }

    public void buildStarted(BuildEvent event) {
        this.establishConnection(event);
        super.buildStarted(event);
    }
}

