/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.jce.SHA1;
import com.jcraft.jsch.jce.SignatureDSA;
import com.jcraft.jsch.jce.SignatureRSA;

public class DHGEX
extends KeyExchange {
    static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    static int min;
    static int preferred;
    static int max;
    static final int RSA = 0;
    static final int DSS = 1;
    private int type = 0;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    private byte[] f;

    public void init(Session session, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        this.session = session;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        this.sha = new SHA1();
        this.sha.init();
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        try {
            Class<?> c = Class.forName(session.getConfig("dh"));
            this.dh = (DH)c.newInstance();
            this.dh.init();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(min);
        this.buf.putInt(preferred);
        this.buf.putInt(max);
        session.write(this.packet);
        this.state = 31;
    }

    public boolean next(Buffer _buf) throws Exception {
        switch (this.state) {
            case 31: {
                _buf.getInt();
                _buf.getByte();
                int j = _buf.getByte();
                if (j != 31) {
                    System.err.println("type: must be 31 " + j);
                    return false;
                }
                this.p = _buf.getMPInt();
                this.g = _buf.getMPInt();
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                this.session.write(this.packet);
                this.state = 33;
                return true;
            }
            case 33: {
                int j = _buf.getInt();
                j = _buf.getByte();
                j = _buf.getByte();
                if (j != 33) {
                    System.err.println("type: must be 33 " + j);
                    return false;
                }
                this.K_S = _buf.getString();
                byte[] f = _buf.getMPInt();
                byte[] sig_of_H = _buf.getString();
                this.dh.setF(f);
                this.K = this.dh.getK();
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(min);
                this.buf.putInt(preferred);
                this.buf.putInt(max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(f);
                this.buf.putMPInt(this.K);
                byte[] foo = new byte[this.buf.getLength()];
                this.buf.getByte(foo);
                this.sha.update(foo, 0, foo.length);
                this.H = this.sha.digest();
                int i = 0;
                j = 0;
                j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                String alg = new String(this.K_S, i, j);
                i += j;
                boolean result = false;
                if (alg.equals("ssh-rsa")) {
                    this.type = 0;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    byte[] tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    byte[] ee = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    byte[] n = tmp;
                    SignatureRSA sig = new SignatureRSA();
                    sig.init();
                    sig.setPubKey(ee, n);
                    sig.update(this.H);
                    result = sig.verify(sig_of_H);
                } else if (alg.equals("ssh-dss")) {
                    byte[] q = null;
                    this.type = 1;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    byte[] tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    this.p = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    q = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    this.g = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    f = tmp;
                    SignatureDSA sig = new SignatureDSA();
                    sig.init();
                    sig.setPubKey(f, this.p, q, this.g);
                    sig.update(this.H);
                    result = sig.verify(sig_of_H);
                } else {
                    System.out.println("unknow alg");
                }
                this.state = 0;
                return result;
            }
        }
        return false;
    }

    public String getKeyType() {
        if (this.type == 1) {
            return "DSA";
        }
        return "RSA";
    }

    public int getState() {
        return this.state;
    }

    static {
        SSH_MSG_KEX_DH_GEX_GROUP = 31;
        SSH_MSG_KEX_DH_GEX_INIT = 32;
        SSH_MSG_KEX_DH_GEX_REPLY = 33;
        min = 1024;
        preferred = 1024;
        max = 1024;
        RSA = 0;
        DSS = 1;
    }
}

