/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;

class ChannelX11
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    static String host;
    static int port;
    boolean init = true;
    static byte[] cookie;
    static byte[] cookie_hex;
    private static Hashtable faked_cookie_pool;
    private static Hashtable faked_cookie_hex_pool;
    static byte[] table;
    Socket socket = null;

    static int revtable(byte foo) {
        int i = 0;
        while (i < table.length) {
            if (table[i] == foo) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    static void setCookie(String foo) {
        cookie_hex = foo.getBytes();
        cookie = new byte[16];
        int i = 0;
        while (i < 16) {
            ChannelX11.cookie[i] = (byte)(ChannelX11.revtable(cookie_hex[i * 2]) << 4 & 0xF0 | ChannelX11.revtable(cookie_hex[i * 2 + 1]) & 0xF);
            ++i;
        }
    }

    static void setHost(String foo) {
        host = foo;
    }

    static void setPort(int foo) {
        port = foo;
    }

    static byte[] getFakedCookie(Session session) {
        byte[] foo = (byte[])faked_cookie_hex_pool.get(session);
        if (foo == null) {
            Random random = Session.random;
            foo = new byte[16];
            random.fill(foo, 0, 16);
            faked_cookie_pool.put(session, foo);
            byte[] bar = new byte[32];
            int i = 0;
            while (i < 16) {
                bar[2 * i] = table[foo[i] >>> 4 & 0xF];
                bar[2 * i + 1] = table[foo[i] & 0xF];
                ++i;
            }
            faked_cookie_hex_pool.put(session, bar);
            foo = bar;
        }
        return foo;
    }

    ChannelX11() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.type = "x11".getBytes();
        try {
            this.socket = new Socket(host, port);
            this.socket.setTcpNoDelay(true);
            this.io = new IO();
            this.io.setInputStream(this.socket.getInputStream());
            this.io.setOutputStream(this.socket.getOutputStream());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void run() {
        this.thread = this;
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            while (this.thread != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 16 - 20);
                if (i > 0 && !this.close) {
                    packet.reset();
                    buf.putByte((byte)94);
                    buf.putInt(this.recipient);
                    buf.putInt(i);
                    buf.skip(i);
                    this.session.write(packet, this, i);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.thread = null;
    }

    void write(byte[] foo, int s, int l) throws IOException {
        if (this.eof) {
            return;
        }
        if (this.init) {
            int plen = (foo[s + 6] & 0xFF) * 256 + (foo[s + 7] & 0xFF);
            int dlen = (foo[s + 8] & 0xFF) * 256 + (foo[s + 9] & 0xFF);
            if ((foo[s] & 0xFF) != 66 && (foo[s] & 0xFF) == 108) {
                plen = plen >>> 8 & 0xFF | plen << 8 & 0xFF00;
                dlen = dlen >>> 8 & 0xFF | dlen << 8 & 0xFF00;
            }
            byte[] bar = new byte[dlen];
            System.arraycopy(foo, s + 12 + plen + (-plen & 3), bar, 0, dlen);
            byte[] faked_cookie = (byte[])faked_cookie_pool.get(this.session);
            if (ChannelX11.equals(bar, faked_cookie)) {
                if (cookie != null) {
                    System.arraycopy(cookie, 0, foo, s + 12 + plen + (-plen & 3), dlen);
                }
            } else {
                System.out.println("wrong cookie");
            }
            this.init = false;
        }
        this.io.put(foo, s, l);
    }

    public void disconnect() {
        this.close();
        this.thread = null;
        try {
            if (this.io != null) {
                try {
                    if (this.io.in != null) {
                        this.io.in.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                try {
                    if (this.io.out != null) {
                        this.io.out.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception ee) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.io = null;
        Channel.del(this);
    }

    private static boolean equals(byte[] foo, byte[] bar) {
        if (foo.length != bar.length) {
            return false;
        }
        int i = 0;
        while (i < foo.length) {
            if (foo[i] != bar[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        LOCAL_WINDOW_SIZE_MAX = 131072;
        LOCAL_MAXIMUM_PACKET_SIZE = 16384;
        host = "127.0.0.1";
        port = 6000;
        cookie = null;
        cookie_hex = null;
        faked_cookie_pool = new Hashtable();
        faked_cookie_hex_pool = new Hashtable();
        table = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    }
}

