/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSubsystem;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public class ChannelSftp
extends ChannelSubsystem {
    private static final byte SSH_FXP_INIT = 1;
    private static final byte SSH_FXP_VERSION = 2;
    private static final byte SSH_FXP_OPEN = 3;
    private static final byte SSH_FXP_CLOSE = 4;
    private static final byte SSH_FXP_READ = 5;
    private static final byte SSH_FXP_WRITE = 6;
    private static final byte SSH_FXP_LSTAT = 7;
    private static final byte SSH_FXP_FSTAT = 8;
    private static final byte SSH_FXP_SETSTAT = 9;
    private static final byte SSH_FXP_FSETSTAT = 10;
    private static final byte SSH_FXP_OPENDIR = 11;
    private static final byte SSH_FXP_READDIR = 12;
    private static final byte SSH_FXP_REMOVE = 13;
    private static final byte SSH_FXP_MKDIR = 14;
    private static final byte SSH_FXP_RMDIR = 15;
    private static final byte SSH_FXP_REALPATH = 16;
    private static final byte SSH_FXP_STAT = 17;
    private static final byte SSH_FXP_RENAME = 18;
    private static final byte SSH_FXP_READLINK = 19;
    private static final byte SSH_FXP_SYMLINK = 20;
    private static final byte SSH_FXP_STATUS = 101;
    private static final byte SSH_FXP_HANDLE = 102;
    private static final byte SSH_FXP_DATA = 103;
    private static final byte SSH_FXP_NAME = 104;
    private static final byte SSH_FXP_ATTRS = 105;
    private static final byte SSH_FXP_EXTENDED = -56;
    private static final byte SSH_FXP_EXTENDED_REPLY = -55;
    private static final int SSH_FXF_READ = 1;
    private static final int SSH_FXF_WRITE = 2;
    private static final int SSH_FXF_APPEND = 4;
    private static final int SSH_FXF_CREAT = 8;
    private static final int SSH_FXF_TRUNC = 16;
    private static final int SSH_FXF_EXCL = 32;
    private static final int SSH_FILEXFER_ATTR_SIZE = 1;
    private static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    private static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    private static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    private static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int OVERWRITE = 0;
    public static final int RESUME = 1;
    public static final int APPEND = 2;
    private boolean interactive = false;
    private int count = 1;
    private Buffer buf;
    private Packet packet = new Packet(this.buf);
    private String version = "3";
    private int server_version = 3;
    private static final String file_separator;
    private static final char file_separatorc;
    private String cwd;
    private String home;
    private String lcwd;

    ChannelSftp() {
        this.setSubsystem("sftp");
    }

    public void init() {
    }

    public void start() {
        try {
            PipedOutputStream pos = new PipedOutputStream();
            this.io.setOutputStream(pos);
            PipedInputStream pis = new PipedInputStream(pos);
            this.io.setInputStream(pis);
            RequestSubsystem request = new RequestSubsystem("sftp");
            request.request(this.session, this);
            this.thread = this;
            this.buf = new Buffer();
            this.packet = new Packet(this.buf);
            int i = 0;
            boolean j = false;
            this.sendINIT();
            this.buf.rewind();
            i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            this.server_version = this.buf.getInt();
            this.sendREALPATH(".".getBytes());
            this.buf.rewind();
            i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            length = this.buf.getInt();
            type = this.buf.getByte();
            this.buf.getInt();
            i = this.buf.getInt();
            byte[] str = this.buf.getString();
            this.home = this.cwd = new String(str);
            str = this.buf.getString();
            this.lcwd = new File(".").getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void quit() {
        this.disconnect();
    }

    public void exit() {
        this.disconnect();
    }

    public void lcd(String path) throws SftpException {
        if (!ChannelSftp.isLocalAbsolutePath(path)) {
            path = this.lcwd + file_separator + path;
        }
        if (new File(path).isDirectory()) {
            try {
                path = new File(path).getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lcwd = path;
            return;
        }
        throw new SftpException(2, "No such directory");
    }

    public void cd(String path) throws SftpException {
        try {
            Vector v;
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            if ((v = this.glob_remote(path)).size() != 1) {
                throw new SftpException(4, v.toString());
            }
            path = (String)v.elementAt(0);
            this.sendREALPATH(path.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 101 && type != 104) {
                throw new SftpException(4, "");
            }
            if (type == 101) {
                this.buf.getInt();
                i = this.buf.getInt();
                byte[] str = this.buf.getString();
                throw new SftpException(i, new String(str));
            }
            this.buf.getInt();
            i = this.buf.getInt();
            byte[] str = this.buf.getString();
            if (str != null && str[0] != 47) {
                str = (this.cwd + "/" + new String(str)).getBytes();
            }
            this.cwd = new String(str);
            str = this.buf.getString();
            int n = this.buf.getInt();
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void put(String src, String dst) throws SftpException {
        this.put(src, dst, null, 0);
    }

    public void put(String src, String dst, int mode) throws SftpException {
        this.put(src, dst, null, mode);
    }

    public void put(String src, String dst, SftpProgressMonitor monitor) throws SftpException {
        this.put(src, dst, monitor, 0);
    }

    public void put(String src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        if (!ChannelSftp.isLocalAbsolutePath(src)) {
            src = this.lcwd + file_separator + src;
        }
        if (!dst.startsWith("/")) {
            dst = this.cwd + "/" + dst;
        }
        try {
            Vector v = this.glob_remote(dst);
            if (v.size() != 1) {
                throw new SftpException(4, v.toString());
            }
            dst = (String)v.elementAt(0);
            boolean isRemoteDir = this.isRemoteDir(dst);
            v = this.glob_local(src);
            int j = 0;
            while (j < v.size()) {
                String _src = (String)v.elementAt(j);
                String _dst = dst;
                if (isRemoteDir) {
                    int i;
                    if (!_dst.endsWith("/")) {
                        _dst = _dst + "/";
                    }
                    _dst = (i = _src.lastIndexOf(file_separatorc)) == -1 ? _dst + _src : _dst + _src.substring(i + 1);
                }
                long size_of_dst = 0L;
                if (mode == 1) {
                    try {
                        SftpATTRS attr = this.stat(_dst);
                        size_of_dst = attr.getSize();
                    }
                    catch (Exception eee) {
                        // empty catch block
                    }
                    long size_of_src = new File(_src).length();
                    if (size_of_src < size_of_dst) {
                        throw new SftpException(4, "failed to resume for " + _dst);
                    }
                    if (size_of_src == size_of_dst) {
                        return;
                    }
                }
                if (monitor != null) {
                    monitor.init(0, _src, _dst, new File(_src).length());
                    if (mode == 1) {
                        monitor.count(size_of_dst);
                    }
                }
                FileInputStream fis = new FileInputStream(_src);
                this.put(fis, _dst, monitor, mode);
                fis.close();
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void put(InputStream src, String dst) throws SftpException {
        this.put(src, dst, null, 0);
    }

    public void put(InputStream src, String dst, int mode) throws SftpException {
        this.put(src, dst, null, mode);
    }

    public void put(InputStream src, String dst, SftpProgressMonitor monitor) throws SftpException {
        this.put(src, dst, monitor, 0);
    }

    public void put(InputStream src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        try {
            long skipped;
            Vector v;
            if (!dst.startsWith("/")) {
                dst = this.cwd + "/" + dst;
            }
            if ((v = this.glob_remote(dst)).size() != 1) {
                throw new SftpException(4, v.toString());
            }
            dst = (String)v.elementAt(0);
            if (this.isRemoteDir(dst)) {
                throw new SftpException(4, dst + " is a directory");
            }
            long skip = 0L;
            if (mode == 1 || mode == 2) {
                try {
                    SftpATTRS attr = this.stat(dst);
                    skip = attr.getSize();
                }
                catch (Exception eee) {
                    // empty catch block
                }
            }
            if (mode == 1 && skip > 0L && (skipped = src.skip(skip)) < skip) {
                throw new SftpException(4, "failed to resume for " + dst);
            }
            if (mode == 0) {
                this.sendOPENW(dst.getBytes());
            } else {
                this.sendOPENA(dst.getBytes());
            }
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 101 && type != 102) {
                throw new SftpException(4, "");
            }
            if (type == 101) {
                this.buf.getInt();
                i = this.buf.getInt();
                this.throwStatusError(this.buf, i);
            }
            this.buf.getInt();
            byte[] handle = this.buf.getString();
            byte[] data = new byte[1024];
            long offset = 0L;
            if (mode == 1 || mode == 2) {
                offset += skip;
            }
            while ((i = src.read(data, 0, 1024)) > 0) {
                this.sendWRITE(handle, offset, data, 0, i);
                offset += (long)i;
                this.buf.rewind();
                this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                length = this.buf.getInt();
                type = this.buf.getByte();
                if (type != 101) break;
                this.buf.getInt();
                if (this.buf.getInt() == 0 && (monitor == null || monitor.count(i))) continue;
            }
            this.sendCLOSE(handle);
            if (monitor != null) {
                monitor.end();
            }
            this.buf.rewind();
            i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            length = this.buf.getInt();
            type = this.buf.getByte();
            if (type != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            i = this.buf.getInt();
            if (i == 0) {
                return;
            }
            this.throwStatusError(this.buf, i);
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public OutputStream put(String dst) throws SftpException {
        return this.put(dst, (SftpProgressMonitor)null, 0);
    }

    public OutputStream put(String dst, int mode) throws SftpException {
        return this.put(dst, (SftpProgressMonitor)null, mode);
    }

    public OutputStream put(String dst, final SftpProgressMonitor monitor, final int mode) throws SftpException {
        if (!dst.startsWith("/")) {
            dst = this.cwd + "/" + dst;
        }
        try {
            Vector v = this.glob_remote(dst);
            if (v.size() != 1) {
                throw new SftpException(4, v.toString());
            }
            dst = (String)v.elementAt(0);
            if (this.isRemoteDir(dst)) {
                throw new SftpException(4, dst + " is a directory");
            }
            PipedOutputStream pos = new PipedOutputStream();
            final PipedInputStream pis = new PipedInputStream(pos);
            final ChannelSftp channel = this;
            final String _dst = dst;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        channel.put(pis, _dst, monitor, mode);
                    }
                    catch (Exception ee) {
                        System.out.println("!!" + ee);
                    }
                    try {
                        pis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            return pos;
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String src, String dst) throws SftpException {
        this.get(src, dst, null, 0);
    }

    public void get(String src, String dst, SftpProgressMonitor monitor) throws SftpException {
        this.get(src, dst, monitor, 0);
    }

    public void get(String src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        if (!src.startsWith("/")) {
            src = this.cwd + "/" + src;
        }
        if (!ChannelSftp.isLocalAbsolutePath(dst)) {
            dst = this.lcwd + file_separator + dst;
        }
        try {
            Vector v = this.glob_remote(src);
            int j = 0;
            while (j < v.size()) {
                String _dst = dst;
                String _src = (String)v.elementAt(j);
                if (new File(_dst).isDirectory()) {
                    int i;
                    if (!_dst.endsWith(file_separator)) {
                        _dst = _dst + file_separator;
                    }
                    _dst = (i = _src.lastIndexOf(47)) == -1 ? _dst + src : _dst + _src.substring(i + 1);
                }
                SftpATTRS attr = this.stat(_src);
                if (mode == 1) {
                    long size_of_src = attr.getSize();
                    long size_of_dst = new File(_dst).length();
                    if (size_of_dst > size_of_src) {
                        throw new SftpException(4, "failed to resume for " + _dst);
                    }
                    if (size_of_dst == size_of_src) {
                        return;
                    }
                }
                if (monitor != null) {
                    monitor.init(1, _src, _dst, attr.getSize());
                    if (mode == 1) {
                        monitor.count(new File(_dst).length());
                    }
                }
                FileOutputStream fos = null;
                fos = mode == 0 ? new FileOutputStream(_dst) : new FileOutputStream(_dst, true);
                this.get(_src, fos, monitor, mode, new File(_dst).length());
                fos.close();
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String src, OutputStream dst) throws SftpException {
        this.get(src, dst, null, 0, 0L);
    }

    public void get(String src, OutputStream dst, SftpProgressMonitor monitor) throws SftpException {
        this.get(src, dst, monitor, 0, 0L);
    }

    private void get(String src, OutputStream dst, SftpProgressMonitor monitor, int mode, long skip) throws SftpException {
        try {
            Vector v;
            if (!src.startsWith("/")) {
                src = this.cwd + "/" + src;
            }
            if ((v = this.glob_remote(src)).size() != 1) {
                throw new SftpException(4, v.toString());
            }
            src = (String)v.elementAt(0);
            this.sendOPENR(src.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 101 && type != 102) {
                throw new SftpException(4, "");
            }
            if (type == 101) {
                this.buf.getInt();
                i = this.buf.getInt();
                this.throwStatusError(this.buf, i);
            }
            this.buf.getInt();
            byte[] handle = this.buf.getString();
            byte[] data = null;
            long offset = 0L;
            if (mode == 1) {
                offset += skip;
            }
            while (true) {
                this.sendREAD(handle, offset, 1000);
                this.buf.rewind();
                i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                length = this.buf.getInt();
                type = this.buf.getByte();
                this.buf.getInt();
                if (type != 101 && type != 103) break;
                if (type == 101) {
                    i = this.buf.getInt();
                    if (i == 1) break;
                    this.throwStatusError(this.buf, i);
                }
                data = this.buf.getString();
                dst.write(data, 0, data.length);
                dst.flush();
                if (monitor != null && !monitor.count(data.length)) break;
                offset += (long)data.length;
            }
            this.sendCLOSE(handle);
            if (monitor != null) {
                monitor.end();
            }
            this.buf.rewind();
            i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            length = this.buf.getInt();
            type = this.buf.getByte();
            if (type != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            i = this.buf.getInt();
            if (i == 0) {
                return;
            }
            this.throwStatusError(this.buf, i);
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public InputStream get(String src) throws SftpException {
        return this.get(src, null, 0);
    }

    public InputStream get(String src, int mode) throws SftpException {
        return this.get(src, null, mode);
    }

    public InputStream get(String src, final SftpProgressMonitor monitor, final int mode) throws SftpException {
        if (mode == 1) {
            throw new SftpException(4, "faile to resume from " + src);
        }
        if (!src.startsWith("/")) {
            src = this.cwd + "/" + src;
        }
        try {
            Vector v = this.glob_remote(src);
            if (v.size() != 1) {
                throw new SftpException(4, v.toString());
            }
            src = (String)v.elementAt(0);
            SftpATTRS attr = this.stat(src);
            PipedInputStream pis = new PipedInputStream();
            final PipedOutputStream pos = new PipedOutputStream(pis);
            final ChannelSftp channel = this;
            final String _src = src;
            if (attr.getSize() <= 0L) {
                try {
                    pos.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                return pis;
            }
            final Exception[] closed = new Exception[]{null};
            new Thread(new Runnable(){

                public void run() {
                    try {
                        channel.get(_src, pos, monitor, mode, 0L);
                    }
                    catch (Exception ee) {
                        closed[0] = ee;
                    }
                    try {
                        pos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            while (pis.available() == 0) {
                if (closed[0] != null) {
                    throw closed[0];
                }
                Thread.sleep(1000L);
            }
            return pis;
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    /*
     * Unable to fully structure code
     */
    public Vector ls(String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            dir = path;
            pattern = null;
            if (!this.isRemoteDir(dir)) {
                foo = path.lastIndexOf(47);
                dir = path.substring(0, foo);
                pattern = path.substring(foo + 1).getBytes();
            }
            this.sendOPENDIR(dir.getBytes());
            this.buf.rewind();
            i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            length = this.buf.getInt();
            type = this.buf.getByte();
            if (type != 101 && type != 102) {
                throw new SftpException(4, "");
            }
            if (type == 101) {
                this.buf.getInt();
                i = this.buf.getInt();
                this.throwStatusError(this.buf, i);
            }
            this.buf.getInt();
            handle = this.buf.getString();
            v = new Vector<String>();
            block2: while (true) {
                this.sendREADDIR(handle);
                this.buf.rewind();
                this.buf.index = i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                length = this.buf.getInt();
                length -= i - 4;
                type = this.buf.getByte();
                if (type != 101 && type != 104) {
                    throw new SftpException(4, "");
                }
                if (type == 101) break;
                this.buf.getInt();
                count = this.buf.getInt();
                while (true) {
                    if (count <= 0) continue block2;
                    if (length > 0) {
                        this.buf.shift();
                        i = this.io.in.read(this.buf.buffer, this.buf.index, this.buf.buffer.length - this.buf.index);
                        if (i > 0) ** break;
                        continue block2;
                        this.buf.index += i;
                        length -= i;
                    }
                    filename = this.buf.getString();
                    str = this.buf.getString();
                    longname = new String(str);
                    attrs = SftpATTRS.getATTR(this.buf);
                    if (pattern == null || Util.glob(pattern, filename)) {
                        v.addElement(longname);
                    }
                    --count;
                }
                break;
            }
            this.sendCLOSE(handle);
            this.buf.rewind();
            i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            length = this.buf.getInt();
            type = this.buf.getByte();
            if (type != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            i = this.buf.getInt();
            if (i == 0) {
                return v;
            }
            this.throwStatusError(this.buf, i);
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
        return null;
    }

    public void symlink(String oldpath, String newpath) throws SftpException {
        if (this.server_version < 3) {
            throw new SftpException(4, "The remote sshd is too old to support symlink operation.");
        }
        try {
            Vector v;
            if (!oldpath.startsWith("/")) {
                oldpath = this.cwd + "/" + oldpath;
            }
            if (!newpath.startsWith("/")) {
                newpath = this.cwd + "/" + newpath;
            }
            if ((v = this.glob_remote(oldpath)).size() != 1) {
                throw new SftpException(4, v.toString());
            }
            oldpath = (String)v.elementAt(0);
            this.sendSYMLINK(oldpath.getBytes(), newpath.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            i = this.buf.getInt();
            if (i == 0) {
                return;
            }
            this.throwStatusError(this.buf, i);
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void rename(String oldpath, String newpath) throws SftpException {
        if (this.server_version < 2) {
            throw new SftpException(4, "The remote sshd is too old to support rename operation.");
        }
        try {
            Vector v;
            if (!oldpath.startsWith("/")) {
                oldpath = this.cwd + "/" + oldpath;
            }
            if (!newpath.startsWith("/")) {
                newpath = this.cwd + "/" + newpath;
            }
            if ((v = this.glob_remote(oldpath)).size() != 1) {
                throw new SftpException(4, v.toString());
            }
            oldpath = (String)v.elementAt(0);
            v = this.glob_remote(newpath);
            if (v.size() >= 2) {
                throw new SftpException(4, v.toString());
            }
            if (v.size() == 1) {
                newpath = (String)v.elementAt(0);
            }
            this.sendRENAME(oldpath.getBytes(), newpath.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            i = this.buf.getInt();
            if (i == 0) {
                return;
            }
            this.throwStatusError(this.buf, i);
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void rm(String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            Vector v = this.glob_remote(path);
            int j = 0;
            while (j < v.size()) {
                path = (String)v.elementAt(j);
                this.sendREMOVE(path.getBytes());
                this.buf.rewind();
                int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int length = this.buf.getInt();
                int type = this.buf.getByte();
                if (type != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                i = this.buf.getInt();
                if (i != 0) {
                    this.throwStatusError(this.buf, i);
                }
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    boolean isRemoteDir(String path) {
        try {
            this.sendSTAT(path.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 105) {
                return false;
            }
            this.buf.getInt();
            SftpATTRS attr = SftpATTRS.getATTR(this.buf);
            return attr.isDir();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void chgrp(int gid, String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            Vector v = this.glob_remote(path);
            int j = 0;
            while (j < v.size()) {
                path = (String)v.elementAt(j);
                this.sendSTAT(path.getBytes());
                this.buf.rewind();
                int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int length = this.buf.getInt();
                int type = this.buf.getByte();
                if (type != 105) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                SftpATTRS attr = SftpATTRS.getATTR(this.buf);
                attr.setUIDGID(attr.uid, gid);
                this.sendSETSTAT(path.getBytes(), attr);
                this.buf.rewind();
                i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                length = this.buf.getInt();
                type = this.buf.getByte();
                if (type != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                i = this.buf.getInt();
                if (i != 0) {
                    this.throwStatusError(this.buf, i);
                }
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void chown(int uid, String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            Vector v = this.glob_remote(path);
            int j = 0;
            while (j < v.size()) {
                path = (String)v.elementAt(j);
                this.sendSTAT(path.getBytes());
                this.buf.rewind();
                int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int length = this.buf.getInt();
                int type = this.buf.getByte();
                if (type != 105) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                SftpATTRS attr = SftpATTRS.getATTR(this.buf);
                attr.setUIDGID(uid, attr.gid);
                this.sendSETSTAT(path.getBytes(), attr);
                this.buf.rewind();
                i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                length = this.buf.getInt();
                type = this.buf.getByte();
                if (type != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                i = this.buf.getInt();
                if (i != 0) {
                    this.throwStatusError(this.buf, i);
                }
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void chmod(int permissions, String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            Vector v = this.glob_remote(path);
            int j = 0;
            while (j < v.size()) {
                path = (String)v.elementAt(j);
                this.sendSTAT(path.getBytes());
                this.buf.rewind();
                int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int length = this.buf.getInt();
                int type = this.buf.getByte();
                if (type != 105) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                SftpATTRS attr = SftpATTRS.getATTR(this.buf);
                attr.setPERMISSIONS(permissions);
                this.sendSETSTAT(path.getBytes(), attr);
                this.buf.rewind();
                i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                length = this.buf.getInt();
                type = this.buf.getByte();
                if (type != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                i = this.buf.getInt();
                if (i != 0) {
                    this.throwStatusError(this.buf, i);
                }
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void rmdir(String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            Vector v = this.glob_remote(path);
            int j = 0;
            while (j < v.size()) {
                path = (String)v.elementAt(j);
                this.sendRMDIR(path.getBytes());
                this.buf.rewind();
                int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int length = this.buf.getInt();
                int type = this.buf.getByte();
                if (type != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                i = this.buf.getInt();
                if (i != 0) {
                    this.throwStatusError(this.buf, i);
                }
                ++j;
            }
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public void mkdir(String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            this.sendMKDIR(path.getBytes(), null);
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            i = this.buf.getInt();
            if (i == 0) {
                return;
            }
            this.throwStatusError(this.buf, i);
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS stat(String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            this.sendSTAT(path.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 105) {
                if (type == 101) {
                    this.buf.getInt();
                    i = this.buf.getInt();
                    this.throwStatusError(this.buf, i);
                }
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            SftpATTRS attr = SftpATTRS.getATTR(this.buf);
            return attr;
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS lstat(String path) throws SftpException {
        try {
            if (!path.startsWith("/")) {
                path = this.cwd + "/" + path;
            }
            this.sendLSTAT(path.getBytes());
            this.buf.rewind();
            int i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int length = this.buf.getInt();
            int type = this.buf.getByte();
            if (type != 105) {
                if (type == 101) {
                    this.buf.getInt();
                    i = this.buf.getInt();
                    this.throwStatusError(this.buf, i);
                }
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            SftpATTRS attr = SftpATTRS.getATTR(this.buf);
            return attr;
        }
        catch (Exception e) {
            if (e instanceof SftpException) {
                throw (SftpException)e;
            }
            throw new SftpException(4, "");
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public String lpwd() {
        return this.lcwd;
    }

    public String version() {
        return this.version;
    }

    private void sendINIT() throws Exception {
        this.packet.reset();
        this.putHEAD((byte)1, 5);
        this.buf.putInt(3);
        this.session.write(this.packet, this, 9);
    }

    private void sendREALPATH(byte[] path) throws Exception {
        this.sendPacketPath((byte)16, path);
    }

    private void sendSTAT(byte[] path) throws Exception {
        this.sendPacketPath((byte)17, path);
    }

    private void sendLSTAT(byte[] path) throws Exception {
        this.sendPacketPath((byte)7, path);
    }

    private void sendFSTAT(byte[] handle) throws Exception {
        this.sendPacketPath((byte)8, handle);
    }

    private void sendSETSTAT(byte[] path, SftpATTRS attr) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)9, 9 + path.length + attr.length());
        this.buf.putInt(this.count++);
        this.buf.putString(path);
        attr.dump(this.buf);
        this.session.write(this.packet, this, 9 + path.length + attr.length() + 4);
    }

    private void sendREMOVE(byte[] path) throws Exception {
        this.sendPacketPath((byte)13, path);
    }

    private void sendMKDIR(byte[] path, SftpATTRS attr) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)14, 9 + path.length + (attr != null ? attr.length() : 4));
        this.buf.putInt(this.count++);
        this.buf.putString(path);
        if (attr != null) {
            attr.dump(this.buf);
        } else {
            this.buf.putInt(0);
        }
        this.session.write(this.packet, this, 9 + path.length + (attr != null ? attr.length() : 4) + 4);
    }

    private void sendRMDIR(byte[] path) throws Exception {
        this.sendPacketPath((byte)15, path);
    }

    private void sendSYMLINK(byte[] p1, byte[] p2) throws Exception {
        this.sendPacketPath((byte)20, p1, p2);
    }

    private void sendREADLINK(byte[] path) throws Exception {
        this.sendPacketPath((byte)19, path);
    }

    private void sendOPENDIR(byte[] path) throws Exception {
        this.sendPacketPath((byte)11, path);
    }

    private void sendREADDIR(byte[] path) throws Exception {
        this.sendPacketPath((byte)12, path);
    }

    private void sendRENAME(byte[] p1, byte[] p2) throws Exception {
        this.sendPacketPath((byte)18, p1, p2);
    }

    private void sendCLOSE(byte[] path) throws Exception {
        this.sendPacketPath((byte)4, path);
    }

    private void sendOPENR(byte[] path) throws Exception {
        this.sendOPEN(path, 1);
    }

    private void sendOPENW(byte[] path) throws Exception {
        this.sendOPEN(path, 26);
    }

    private void sendOPENA(byte[] path) throws Exception {
        this.sendOPEN(path, 10);
    }

    private void sendOPEN(byte[] path, int mode) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)3, 17 + path.length);
        this.buf.putInt(this.count++);
        this.buf.putString(path);
        this.buf.putInt(mode);
        this.buf.putInt(0);
        this.session.write(this.packet, this, 17 + path.length + 4);
    }

    private void sendPacketPath(byte fxp, byte[] path) throws Exception {
        this.packet.reset();
        this.putHEAD(fxp, 9 + path.length);
        this.buf.putInt(this.count++);
        this.buf.putString(path);
        this.session.write(this.packet, this, 9 + path.length + 4);
    }

    private void sendPacketPath(byte fxp, byte[] p1, byte[] p2) throws Exception {
        this.packet.reset();
        this.putHEAD(fxp, 13 + p1.length + p2.length);
        this.buf.putInt(this.count++);
        this.buf.putString(p1);
        this.buf.putString(p2);
        this.session.write(this.packet, this, 13 + p1.length + p2.length + 4);
    }

    private void sendWRITE(byte[] handle, long offset, byte[] data, int start, int length) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)6, 21 + handle.length + length);
        this.buf.putInt(this.count++);
        this.buf.putString(handle);
        this.buf.putLong(offset);
        this.buf.putString(data, start, length);
        this.session.write(this.packet, this, 21 + handle.length + length + 4);
    }

    private void sendREAD(byte[] handle, long offset, int length) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)5, 21 + handle.length);
        this.buf.putInt(this.count++);
        this.buf.putString(handle);
        this.buf.putLong(offset);
        this.buf.putInt(length);
        this.session.write(this.packet, this, 21 + handle.length + 4);
    }

    private void putHEAD(byte type, int length) throws Exception {
        this.buf.putByte((byte)94);
        this.buf.putInt(this.recipient);
        this.buf.putInt(length + 4);
        this.buf.putInt(length);
        this.buf.putByte(type);
    }

    /*
     * Unable to fully structure code
     */
    private Vector glob_remote(String _path) throws Exception {
        v = new Vector<String>();
        path = _path.getBytes();
        i = path.length - 1;
        while (i >= 0) {
            if (path[i] == 42 || path[i] == 63) break;
            --i;
        }
        if (i >= 0) ** GOTO lbl13
        v.addElement(_path);
        return v;
        while (path[i] != 47) {
            --i;
lbl13:
            // 2 sources

            if (i >= 0) continue;
        }
        if (i < 0) {
            v.addElement(_path);
            return v;
        }
        if (i == 0) {
            dir = new byte[]{47};
        } else {
            dir = new byte[i];
            System.arraycopy(path, 0, dir, 0, i);
        }
        pattern = new byte[path.length - i - 1];
        System.arraycopy(path, i + 1, pattern, 0, pattern.length);
        this.sendOPENDIR(dir);
        this.buf.rewind();
        i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
        length = this.buf.getInt();
        type = this.buf.getByte();
        if (type != 101 && type != 102) {
            throw new SftpException(4, "");
        }
        if (type == 101) {
            this.buf.getInt();
            i = this.buf.getInt();
            this.throwStatusError(this.buf, i);
        }
        this.buf.getInt();
        handle = this.buf.getString();
        block2: while (true) {
            this.sendREADDIR(handle);
            this.buf.rewind();
            this.buf.index = i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            length = this.buf.getInt();
            length -= i - 4;
            type = this.buf.getByte();
            if (type != 101 && type != 104) {
                throw new SftpException(4, "");
            }
            if (type == 101) break;
            this.buf.getInt();
            count = this.buf.getInt();
            while (true) {
                if (count <= 0) continue block2;
                if (length > 0) {
                    this.buf.shift();
                    i = this.io.in.read(this.buf.buffer, this.buf.index, this.buf.buffer.length - this.buf.index);
                    if (i > 0) ** break;
                    continue block2;
                    this.buf.index += i;
                    length -= i;
                }
                filename = this.buf.getString();
                str = this.buf.getString();
                attrs = SftpATTRS.getATTR(this.buf);
                if (Util.glob(pattern, filename)) {
                    v.addElement(new String(dir) + "/" + new String(filename));
                }
                --count;
            }
            break;
        }
        this.sendCLOSE(handle);
        this.buf.rewind();
        i = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
        length = this.buf.getInt();
        type = this.buf.getByte();
        if (type != 101) {
            throw new SftpException(4, "");
        }
        this.buf.getInt();
        i = this.buf.getInt();
        if (i == 0) {
            return v;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Vector glob_local(String _path) throws Exception {
        v = new Vector<String>();
        path = _path.getBytes();
        i = path.length - 1;
        while (i >= 0) {
            if (path[i] == 42 || path[i] == 63) break;
            --i;
        }
        if (i >= 0) ** GOTO lbl13
        v.addElement(_path);
        return v;
        while (path[i] != ChannelSftp.file_separatorc) {
            --i;
lbl13:
            // 2 sources

            if (i >= 0) continue;
        }
        if (i < 0) {
            v.addElement(_path);
            return v;
        }
        if (i == 0) {
            dir = new byte[]{(byte)ChannelSftp.file_separatorc};
        } else {
            dir = new byte[i];
            System.arraycopy(path, 0, dir, 0, i);
        }
        pattern = new byte[path.length - i - 1];
        System.arraycopy(path, i + 1, pattern, 0, pattern.length);
        try {
            children = new File(new String(dir)).list();
            j = 0;
            while (j < children.length) {
                if (Util.glob(pattern, children[j].getBytes())) {
                    v.addElement(new String(dir) + ChannelSftp.file_separator + children[j]);
                }
                ++j;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return v;
    }

    private void throwStatusError(Buffer buf, int i) throws SftpException {
        if (this.server_version >= 3) {
            byte[] str = buf.getString();
            throw new SftpException(i, new String(str));
        }
        throw new SftpException(i, "Failure");
    }

    private static boolean isLocalAbsolutePath(String path) {
        return new File(path).isAbsolute();
    }

    static {
        SSH_FXP_INIT = 1;
        SSH_FXP_VERSION = (byte)2;
        SSH_FXP_OPEN = (byte)3;
        SSH_FXP_CLOSE = (byte)4;
        SSH_FXP_READ = (byte)5;
        SSH_FXP_WRITE = (byte)6;
        SSH_FXP_LSTAT = (byte)7;
        SSH_FXP_FSTAT = (byte)8;
        SSH_FXP_SETSTAT = (byte)9;
        SSH_FXP_FSETSTAT = (byte)10;
        SSH_FXP_OPENDIR = (byte)11;
        SSH_FXP_READDIR = (byte)12;
        SSH_FXP_REMOVE = (byte)13;
        SSH_FXP_MKDIR = (byte)14;
        SSH_FXP_RMDIR = (byte)15;
        SSH_FXP_REALPATH = (byte)16;
        SSH_FXP_STAT = (byte)17;
        SSH_FXP_RENAME = (byte)18;
        SSH_FXP_READLINK = (byte)19;
        SSH_FXP_SYMLINK = (byte)20;
        SSH_FXP_STATUS = (byte)101;
        SSH_FXP_HANDLE = (byte)102;
        SSH_FXP_DATA = (byte)103;
        SSH_FXP_NAME = (byte)104;
        SSH_FXP_ATTRS = (byte)105;
        SSH_FXP_EXTENDED = (byte)-56;
        SSH_FXP_EXTENDED_REPLY = (byte)-55;
        SSH_FXF_READ = 1;
        SSH_FXF_WRITE = 2;
        SSH_FXF_APPEND = 4;
        SSH_FXF_CREAT = 8;
        SSH_FXF_TRUNC = 16;
        SSH_FXF_EXCL = 32;
        SSH_FILEXFER_ATTR_SIZE = 1;
        SSH_FILEXFER_ATTR_UIDGID = 2;
        SSH_FILEXFER_ATTR_PERMISSIONS = 4;
        SSH_FILEXFER_ATTR_ACMODTIME = 8;
        SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
        SSH_FX_OK = 0;
        SSH_FX_EOF = 1;
        SSH_FX_NO_SUCH_FILE = 2;
        SSH_FX_PERMISSION_DENIED = 3;
        SSH_FX_FAILURE = 4;
        SSH_FX_BAD_MESSAGE = 5;
        SSH_FX_NO_CONNECTION = 6;
        SSH_FX_CONNECTION_LOST = 7;
        SSH_FX_OP_UNSUPPORTED = 8;
        OVERWRITE = 0;
        RESUME = 1;
        APPEND = 2;
        file_separator = File.separator;
        file_separatorc = File.separatorChar;
    }

    public static class Ssh_exp_name {
        private String filename;
        private String longname;
        private SftpATTRS attrs;

        Ssh_exp_name(String filename, String longname, SftpATTRS attrs) {
            this.setFilename(filename);
            this.setLongname(longname);
            this.setAttrs(attrs);
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getLongname() {
            return this.longname;
        }

        public void setLongname(String longname) {
            this.longname = longname;
        }

        public SftpATTRS getAttrs() {
            return this.attrs;
        }

        public void setAttrs(SftpATTRS attrs) {
            this.attrs = attrs;
        }

        public String toString() {
            return this.attrs.toString() + " " + this.filename;
        }
    }
}

