/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelDirectTCPIP
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int port;
    String originator_IP_address = "127.0.0.1";
    int originator_port = 0;

    ChannelDirectTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            this.io = new IO();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void connect() {
        try {
            Buffer buf = new Buffer(150);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)90);
            buf.putString("direct-tcpip".getBytes());
            buf.putInt(this.id);
            buf.putInt(this.lwsize);
            buf.putInt(this.lmpsize);
            buf.putString(this.host.getBytes());
            buf.putInt(this.port);
            buf.putString(this.originator_IP_address.getBytes());
            buf.putInt(this.originator_port);
            this.session.write(packet);
            try {
                while (this.getRecipient() == -1) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(this).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.thread = this;
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 16 - 20);
                if (i > 0 && !this.close) {
                    packet.reset();
                    buf.putByte((byte)94);
                    buf.putInt(this.recipient);
                    buf.putInt(i);
                    buf.skip(i);
                    this.session.write(packet, this, i);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    public void disconnect() {
        this.close();
        this.thread = null;
        try {
            if (this.io != null) {
                if (this.io.in != null) {
                    this.io.in.close();
                }
                if (this.io.out != null) {
                    this.io.out.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    public void setInputStream(InputStream in) {
        this.io.setInputStream(in);
    }

    public void setOutputStream(OutputStream out) {
        this.io.setOutputStream(out);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setOrgIPAddress(String foo) {
        this.originator_IP_address = foo;
    }

    public void setOrgPort(int foo) {
        this.originator_port = foo;
    }

    static {
        LOCAL_WINDOW_SIZE_MAX = 131072;
        LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    }
}

