/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.api.operations.IBatchOperation;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.api.search.IUpdateSearchResultCollector;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.JobTargetSite;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.standalone.ScriptedCommand;
import org.eclipse.update.internal.standalone.StandaloneUpdateApplication;

public class UpdateCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private String featureId;
    private IFeature currentFeature;

    public UpdateCommand(String featureId, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            this.featureId = featureId;
            if (featureId != null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), featureId);
                if (this.targetSite == null) {
                    throw new Exception("Cannot find configured site for " + featureId);
                }
                IFeature[] currentFeatures = UpdateUtils.searchSite(featureId, this.targetSite, true);
                if (currentFeatures == null || currentFeatures.length == 0) {
                    throw new Exception("Cannot find configured feature " + featureId);
                }
                this.currentFeature = currentFeatures[0];
            } else {
                IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            this.searchRequest = this.currentFeature == null ? UpdateUtils.createNewUpdatesRequest(null) : UpdateUtils.createNewUpdatesRequest(new IFeature[]{this.currentFeature});
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
    }

    public boolean run() {
        try {
            this.searchRequest.performSearch(this.collector, (IProgressMonitor)new NullProgressMonitor());
            IInstallFeatureOperation[] operations = this.collector.getOperations();
            if (operations == null || operations.length == 0) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("Feature " + this.featureId + " cannot be updated.", null));
                return false;
            }
            JobTargetSite[] jobTargetSites = new JobTargetSite[operations.length];
            int i = 0;
            while (i < operations.length) {
                jobTargetSites[i] = new JobTargetSite();
                jobTargetSites[i].job = operations[i];
                jobTargetSites[i].targetSite = operations[i].getTargetSite();
                ++i;
            }
            ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(jobTargetSites, this.getConfiguration());
            if (conflicts != null) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("Duplicate conflicts", null));
                return false;
            }
            if (this.isVerifyOnly()) {
                return true;
            }
            IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
            try {
                installOperation.execute((IProgressMonitor)new NullProgressMonitor(), this);
                System.out.println("Feature " + this.featureId + " has successfully been updated");
                return true;
            }
            catch (Exception e) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("Cannot update feature " + this.featureId, e));
                return false;
            }
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            if (status != null && status.getCode() == 42) {
                System.out.println("Connection Error");
            } else {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(ce);
            }
            return false;
        }
    }

    public boolean afterExecute(IOperation operation, Object data) {
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            IInstallFeatureOperation op = OperationsManager.getOperationFactory().createInstallOperation(UpdateCommand.this.getConfiguration(), null, feature, null, null, null);
            IConfiguredSite site = UpdateUtils.getDefaultTargetSite(UpdateCommand.this.getConfiguration(), op);
            if (site == null) {
                site = UpdateUtils.getAffinitySite(UpdateCommand.this.getConfiguration(), feature);
            }
            if (site == null) {
                site = UpdateCommand.this.targetSite;
            }
            op.setTargetSite(site);
            this.operations.add(op);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

