/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.api.operations.IUninstallFeatureOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.standalone.ScriptedCommand;
import org.eclipse.update.internal.standalone.StandaloneUpdateApplication;

public class UninstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private IFeature feature;

    public UninstallCommand(String featureId, String version, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            IFeature[] features;
            IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
            if (toSite != null) {
                URL toSiteURL = new File(toSite).toURL();
                if (SiteManager.getSite(toSiteURL, null) == null) {
                    throw new Exception("Cannot find site " + toSite);
                }
                this.targetSite = SiteManager.getSite(toSiteURL, null).getCurrentConfiguredSite();
            }
            if (this.targetSite == null) {
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if ((features = UpdateUtils.searchSite(featureId, this.targetSite, false)) == null || features.length == 0) {
                throw new Exception("There are no unconfigured features with id:" + featureId);
            }
            if (version == null || version.trim().length() == 0) {
                this.feature = features[0];
            } else {
                int i = 0;
                while (features != null && i < features.length) {
                    if (features[i].getVersionedIdentifier().getVersion().toString().equals(version) && !this.targetSite.isConfigured(features[i])) {
                        this.feature = features[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.feature == null) {
                throw new Exception("Cannot find unconfigured feature " + featureId + " with version " + version);
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    public boolean run() {
        if (InstallRegistry.getInstance().get("feature_" + this.feature.getVersionedIdentifier()) == null) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(Utilities.newCoreException("Feature " + this.feature + " was not installed by the update manager, so it cannot be uninstalled.", null));
            return false;
        }
        if (this.isVerifyOnly()) {
            return true;
        }
        IUninstallFeatureOperation uninstallOperation = OperationsManager.getOperationFactory().createUninstallOperation(this.getConfiguration(), this.targetSite, this.feature);
        try {
            return uninstallOperation.execute(null, null);
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
        catch (InvocationTargetException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
    }
}

