/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.internal.standalone.CmdLineArgs;
import org.eclipse.update.internal.standalone.ScriptedCommand;

public class StandaloneUpdateApplication
implements IPlatformRunnable {
    public static final Integer EXIT_ERROR = new Integer(1);
    private static boolean loggedException = false;

    public Object run(Object args) throws Exception {
        if (args == null) {
            return EXIT_ERROR;
        }
        if (args instanceof String[]) {
            String[] params = (String[])args;
            CmdLineArgs cmdLineArgs = new CmdLineArgs(params);
            ScriptedCommand cmd = cmdLineArgs.getCommand();
            if (cmd == null) {
                return EXIT_ERROR;
            }
            loggedException = false;
            boolean result = cmd.run();
            String log = Platform.getLogFileLocation().toOSString();
            if (result) {
                if (loggedException) {
                    System.out.println("Command completed with errors.  Please check " + log + " log file for details.");
                } else {
                    System.out.println("Command completed successfully.");
                }
                return IPlatformRunnable.EXIT_OK;
            }
            if (loggedException) {
                System.out.println("Command failed.  Please check " + log + " log file for details.");
            } else {
                System.out.println("Command failed.");
            }
            return EXIT_ERROR;
        }
        return EXIT_ERROR;
    }

    public static void exceptionLogged() {
        loggedException = true;
    }
}

