/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.api.operations.IOperation;
import org.eclipse.update.internal.api.search.IUpdateSearchResultCollector;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.api.search.UpdateSearchScope;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.standalone.ScriptedCommand;
import org.eclipse.update.internal.standalone.StandaloneUpdateApplication;

public class SearchCommand
extends ScriptedCommand {
    private URL remoteSiteURL;
    private UpdateSearchRequest searchRequest;
    private IUpdateSearchResultCollector collector;

    public SearchCommand(String fromSite) {
        try {
            this.remoteSiteURL = new URL(URLDecoder.decode(fromSite, "UTF-8"));
            UpdateSearchScope searchScope = new UpdateSearchScope();
            searchScope.addSearchSite("remoteSite", this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), searchScope);
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public boolean run() {
        try {
            System.out.println("Searching on " + this.remoteSiteURL.toString());
            this.searchRequest.performSearch(this.collector, (IProgressMonitor)new NullProgressMonitor());
            System.out.println("Done.");
            return true;
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            if (status != null && status.getCode() == 42) {
                System.out.println("Connection Error");
            } else {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(ce);
            }
            return false;
        }
    }

    public boolean afterExecute(IOperation operation, Object data) {
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            System.out.println("\"" + feature.getLabel() + "\" " + feature.getVersionedIdentifier().getIdentifier() + " " + feature.getVersionedIdentifier().getVersion());
        }
    }
}

