/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.operations.IOperation;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.standalone.StandaloneUpdateApplication;

public abstract class ScriptedCommand
implements IOperationListener {
    private IInstallConfiguration config;
    protected boolean verifyOnly;

    public ScriptedCommand() {
        this(null);
    }

    public ScriptedCommand(String verifyOnly) {
        this.verifyOnly = "true".equals(verifyOnly);
    }

    public boolean isVerifyOnly() {
        return this.verifyOnly;
    }

    public abstract boolean run();

    public boolean afterExecute(IOperation operation, Object data) {
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    protected IInstallConfiguration getConfiguration() {
        if (this.config == null) {
            try {
                ILocalSite localSite = SiteManager.getLocalSite();
                this.config = localSite.getCurrentConfiguration();
                if (!this.isVerifyOnly()) {
                    this.config = UpdateUtils.createInstallConfiguration();
                    UpdateUtils.makeConfigurationCurrent(this.config, null);
                }
            }
            catch (CoreException e) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(e);
            }
        }
        return this.config;
    }
}

