/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.api.operations.IBatchOperation;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.api.search.BackLevelFilter;
import org.eclipse.update.internal.api.search.EnvironmentFilter;
import org.eclipse.update.internal.api.search.IUpdateSearchResultCollector;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.api.search.UpdateSearchScope;
import org.eclipse.update.internal.api.search.VersionedIdentifiersFilter;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.JobTargetSite;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.standalone.ScriptedCommand;
import org.eclipse.update.internal.standalone.StandaloneUpdateApplication;

public class InstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private URL remoteSiteURL;
    private String featureId;
    private String version;

    public InstallCommand(String featureId, String version, String fromSite, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            this.featureId = featureId;
            this.version = version;
            this.remoteSiteURL = new URL(URLDecoder.decode(fromSite, "UTF-8"));
            IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
            if (toSite != null) {
                URL toSiteURL;
                ISite site;
                File sitePath = new File(toSite);
                if (!sitePath.exists()) {
                    sitePath.mkdirs();
                }
                if ((site = SiteManager.getSite(toSiteURL = sitePath.toURL(), null)) == null) {
                    throw new Exception("Cannot find site to install to: " + toSite);
                }
                this.targetSite = site.getCurrentConfiguredSite();
                if (this.targetSite == null) {
                    this.targetSite = this.getConfiguration().createConfiguredSite(sitePath);
                    this.getConfiguration().addConfiguredSite(this.targetSite);
                    sites = this.getConfiguration().getConfiguredSites();
                }
            }
            if (this.targetSite == null) {
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            UpdateSearchScope searchScope = new UpdateSearchScope();
            searchScope.addSearchSite("remoteSite", this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), searchScope);
            VersionedIdentifier vid = new VersionedIdentifier(featureId, version);
            this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{vid}));
            this.searchRequest.addFilter(new EnvironmentFilter());
            this.searchRequest.addFilter(new BackLevelFilter());
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    public boolean run() {
        try {
            this.searchRequest.performSearch(this.collector, (IProgressMonitor)new NullProgressMonitor());
            IInstallFeatureOperation[] operations = this.collector.getOperations();
            if (operations == null || operations.length == 0) {
                throw Utilities.newCoreException("Feature " + this.featureId + " " + this.version + " cannot be found on " + this.remoteSiteURL + "\nor a newer version is already installed.", null);
            }
            JobTargetSite[] jobTargetSites = new JobTargetSite[operations.length];
            int i = 0;
            while (i < operations.length) {
                jobTargetSites[i] = new JobTargetSite();
                jobTargetSites[i].job = operations[i];
                jobTargetSites[i].targetSite = operations[i].getTargetSite();
                ++i;
            }
            ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(jobTargetSites, this.getConfiguration());
            if (conflicts != null) {
                throw Utilities.newCoreException("Duplicate conflicts", null);
            }
            if (this.isVerifyOnly()) {
                return operations != null && operations.length > 1;
            }
            IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
            try {
                installOperation.execute((IProgressMonitor)new NullProgressMonitor(), this);
                System.out.println("Feature " + this.featureId + " " + this.version + " has successfully been installed");
                return true;
            }
            catch (Exception e) {
                throw Utilities.newCoreException("Cannot install feature " + this.featureId + " " + this.version, e);
            }
        }
        catch (CoreException ce) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(ce);
            return false;
        }
    }

    public boolean afterExecute(IOperation operation, Object data) {
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            if (feature.getVersionedIdentifier().getIdentifier().equals(InstallCommand.this.featureId) && feature.getVersionedIdentifier().getVersion().toString().equals(InstallCommand.this.version)) {
                this.operations.add(OperationsManager.getOperationFactory().createInstallOperation(InstallCommand.this.getConfiguration(), InstallCommand.this.targetSite, feature, null, null, null));
            }
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

