/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.standalone;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.mirror.MirrorCommand;
import org.eclipse.update.internal.standalone.DisableCommand;
import org.eclipse.update.internal.standalone.EnableCommand;
import org.eclipse.update.internal.standalone.InstallCommand;
import org.eclipse.update.internal.standalone.ScriptedCommand;
import org.eclipse.update.internal.standalone.SearchCommand;
import org.eclipse.update.internal.standalone.StandaloneUpdateApplication;
import org.eclipse.update.internal.standalone.UninstallCommand;
import org.eclipse.update.internal.standalone.UpdateCommand;

public class CmdLineArgs {
    private HashMap options = new HashMap();

    public CmdLineArgs(String[] args) {
        this.options.put("-command", "install");
        int i = 0;
        while (i < args.length - 1) {
            String to;
            if ("-command".equals(args[i])) {
                if (this.isValidCommand(args[i + 1])) {
                    this.options.put("-command", args[i + 1]);
                    ++i;
                } else {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(Utilities.newCoreException("Invalid command:" + args[i + 1], null));
                    return;
                }
            }
            if (this.isValidParam(args[i])) {
                this.options.put(args[i], args[i + 1]);
                ++i;
            }
            if ((to = (String)this.options.get("-to")) != null && to.startsWith("file:")) {
                try {
                    URL url = new URL(to);
                    this.options.put("-to", url.getFile());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
    }

    private boolean isValidParam(String param) {
        return param.equals("-command") || param.equals("-version") || param.equals("-to") || param.equals("-from") || param.equals("-featureId") || param.equals("-verifyOnly") || param.equals("-mirrorURL");
    }

    private boolean isValidCommand(String cmd) {
        return cmd.equals("install") || cmd.equals("enable") || cmd.equals("disable") || cmd.equals("search") || cmd.equals("update") || cmd.equals("mirror") || cmd.equals("uninstall");
    }

    public ScriptedCommand getCommand() {
        try {
            String cmd = (String)this.options.get("-command");
            if (cmd.equals("install")) {
                return new InstallCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-from"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
            }
            if (cmd.equals("enable")) {
                return new EnableCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
            }
            if (cmd.equals("disable")) {
                return new DisableCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
            }
            if (cmd.equals("search")) {
                return new SearchCommand((String)this.options.get("-from"));
            }
            if (cmd.equals("update")) {
                return new UpdateCommand((String)this.options.get("-featureId"), (String)this.options.get("-verifyOnly"));
            }
            if (cmd.equals("mirror")) {
                return new MirrorCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-from"), (String)this.options.get("-to"), (String)this.options.get("-mirrorURL"));
            }
            if (cmd.equals("uninstall")) {
                return new UninstallCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
            }
            return null;
        }
        catch (Exception e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return null;
        }
    }
}

