/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.api.search.IUpdateSiteAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdatePolicy {
    private static final String TAG_POLICY = "update-policy";
    private static final String TAG_URL_MAP = "url-map";
    private static final String ATT_URL = "url";
    private static final String ATT_PATTERN = "pattern";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private ArrayList entries = new ArrayList();
    private IUpdateSiteAdapter defaultSite;
    private boolean loaded = false;
    private boolean fallbackAllowed = true;

    /*
     * Exception decompiling
     */
    public void load(URL mapFile, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 152->156)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public IUpdateSiteAdapter getMappedSite(String id) {
        UpdateMapEntry lastEntry = null;
        int i = 0;
        while (i < this.entries.size()) {
            UpdateMapEntry entry = (UpdateMapEntry)this.entries.get(i);
            if (entry.matches(id)) {
                if (lastEntry == null) {
                    lastEntry = entry;
                } else {
                    String pattern = entry.getPattern();
                    String lastPattern = lastEntry.getPattern();
                    if (pattern.length() > lastPattern.length()) {
                        lastEntry = entry;
                    }
                }
            }
            ++i;
        }
        if (lastEntry != null) {
            return lastEntry.getSite();
        }
        return this.defaultSite;
    }

    public boolean isFallbackAllowed() {
        return this.fallbackAllowed;
    }

    private void reset() {
        if (!this.entries.isEmpty()) {
            this.entries.clear();
        }
    }

    private void processUpdatePolicy(Document document) throws CoreException {
        Element root = document.getDocumentElement();
        this.reset();
        if (!root.getNodeName().equals(TAG_POLICY)) {
            this.throwCoreException("'update-policy' is expected.", null);
        }
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String tag;
            Node child = nodes.item(i);
            if (child.getNodeType() == 1 && (tag = child.getNodeName()).equals(TAG_URL_MAP)) {
                this.processMapNode(child);
            }
            ++i;
        }
    }

    private void processMapNode(Node node) throws CoreException {
        String pattern = this.getAttribute(node, ATT_PATTERN);
        String urlName = this.getAttribute(node, ATT_URL);
        this.assertNotNull(ATT_PATTERN, pattern);
        this.assertNotNull(ATT_URL, urlName);
        if (urlName.trim().length() == 0) {
            this.addEntry(pattern, null);
            return;
        }
        try {
            String decodedValue = URLDecoder.decode(urlName, "UTF-8");
            URL url = new URL(decodedValue);
            this.addEntry(pattern, url);
        }
        catch (MalformedURLException malformedURLException) {
            this.throwCoreException("invalid URL - " + urlName, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private void assertNotNull(String name, String value) throws CoreException {
        if (value == null) {
            this.throwCoreException(String.valueOf(name) + " cannot be null.", null);
        }
    }

    private String getAttribute(Node node, String name) {
        NamedNodeMap attMap = node.getAttributes();
        Node att = attMap.getNamedItem(name);
        if (att == null) {
            return null;
        }
        return att.getNodeValue();
    }

    private void addEntry(String pattern, URL url) {
        if (pattern.equalsIgnoreCase("*")) {
            this.defaultSite = new MapSite(url);
        } else {
            this.entries.add(new UpdateMapEntry(pattern, url));
        }
    }

    private void throwCoreException(String message, Throwable e) throws CoreException {
        String fullMessage = "Update Policy: " + message;
        throw Utilities.newCoreException(fullMessage, 0, e);
    }

    private static class MapSite
    implements IUpdateSiteAdapter {
        private URL url;

        public MapSite(URL url) {
            this.url = url;
        }

        public String getLabel() {
            return this.url.toString();
        }

        public URL getURL() {
            return this.url;
        }
    }

    private static class UpdateMapEntry {
        private IUpdateSiteAdapter site;
        private String pattern;

        public UpdateMapEntry(String pattern, URL url) {
            this.pattern = pattern;
            this.site = new MapSite(url);
        }

        public IUpdateSiteAdapter getSite() {
            return this.site;
        }

        public boolean matches(String id) {
            return id.startsWith(this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

