/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.api.search.EnvironmentFilter;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.api.search.UpdateSearchScope;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallChangeParser;
import org.eclipse.update.internal.search.UpdatesSearchCategory;

public class UpdateUtils {
    private static final String KEY_SAVED_CONFIG = "MultiInstallWizard.savedConfig";
    private static final String RESOURCE_BUNDLE = "org.eclipse.update.internal.operations.UpdateManagerResources";
    private static ResourceBundle bundle;
    private static final String PREFIX;
    public static final String P_UPDATE_POLICY_URL;

    static {
        PREFIX = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        P_UPDATE_POLICY_URL = String.valueOf(PREFIX) + ".updatePolicyURL";
        bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
    }

    private UpdateUtils() {
    }

    public static String getString(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = UpdateUtils.getString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = UpdateUtils.getString(key);
        return MessageFormat.format(text, arg);
    }

    public static String getPluginId() {
        return UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
    }

    public static void logException(Throwable e) {
        UpdateUtils.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUtils.getPluginId(), 0, message, e);
        }
        UpdateUtils.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            Platform.getPlugin((String)"org.eclipse.core.runtime").getLog().log(status);
        }
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        IFeatureReference[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature) {
        return UpdateUtils.getInstalledFeatures(feature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature, boolean onlyConfigured) {
        return UpdateUtils.getInstalledFeatures(feature.getVersionedIdentifier(), onlyConfigured);
    }

    public static IFeature[] getInstalledFeatures(VersionedIdentifier vid, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            String id = vid.getIdentifier();
            int i = 0;
            while (i < isites.length) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = UpdateUtils.searchSite(id, isite, onlyConfigured);
                int j = 0;
                while (j < result.length) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
        }
        return features.toArray(new IFeature[features.size()]);
    }

    public static boolean isPatch(IFeature candidate) {
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPatch(IFeature target, IFeature candidate) {
        VersionedIdentifier vid = target.getVersionedIdentifier();
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            VersionedIdentifier ivid;
            IImport iimport = imports[i];
            if (iimport.isPatch() && vid.equals(ivid = iimport.getVersionedIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IInstallConfiguration getBackupConfigurationFor(IFeature feature) {
        VersionedIdentifier vid = feature.getVersionedIdentifier();
        String key = "@" + vid.getIdentifier() + "_" + vid.getVersion();
        try {
            ILocalSite lsite = SiteManager.getLocalSite();
            IInstallConfiguration[] configs = lsite.getPreservedConfigurations();
            int i = 0;
            while (i < configs.length) {
                IInstallConfiguration config = configs[i];
                if (config.getLabel().startsWith(key)) {
                    return config;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static boolean hasLicense(IFeature feature) {
        IURLEntry info = feature.getLicense();
        if (info == null) {
            return false;
        }
        String licenseTxt = info.getAnnotation();
        if (licenseTxt == null) {
            return false;
        }
        return licenseTxt.trim().length() > 0;
    }

    public static boolean hasOptionalFeatures(IFeatureReference fref) {
        try {
            return UpdateUtils.hasOptionalFeatures(fref.getFeature(null));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasOptionalFeatures(IFeature feature) {
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                if (iref.isOptional()) {
                    return true;
                }
                IFeature child = iref.getFeature(null);
                if (UpdateUtils.hasOptionalFeatures(child)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static IFeature getLocalFeature(IConfiguredSite csite, IFeature feature) throws CoreException {
        IFeatureReference[] refs = csite.getConfiguredFeatures();
        int i = 0;
        while (i < refs.length) {
            IFeatureReference ref = refs[i];
            VersionedIdentifier refVid = ref.getVersionedIdentifier();
            if (feature.getVersionedIdentifier().equals(refVid)) {
                return ref.getFeature(null);
            }
            ++i;
        }
        return null;
    }

    public static IConfiguredSite getConfigSite(IFeature feature, IInstallConfiguration config) throws CoreException {
        IConfiguredSite[] configSites = config.getConfiguredSites();
        int i = 0;
        while (i < configSites.length) {
            IConfiguredSite site = configSites[i];
            if (site.getSite().equals(feature.getSite())) {
                return site;
            }
            ++i;
        }
        return null;
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration config, IInstallFeatureOperation pendingChange) {
        return UpdateUtils.getDefaultTargetSite(config, pendingChange, true);
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration config, IInstallFeatureOperation pendingChange, boolean checkAffinityFeature) {
        IFeature oldFeature = pendingChange.getOldFeature();
        IFeature newFeature = pendingChange.getFeature();
        if (oldFeature != null) {
            try {
                return UpdateUtils.getConfigSite(oldFeature, config);
            }
            catch (CoreException e) {
                UpdateUtils.logException(e);
                return null;
            }
        }
        String newFeatureID = newFeature.getVersionedIdentifier().getIdentifier();
        IConfiguredSite sameSite = UpdateUtils.getSiteWithFeature(config, newFeatureID);
        if (sameSite != null) {
            return sameSite;
        }
        if (checkAffinityFeature) {
            return UpdateUtils.getAffinitySite(config, newFeature);
        }
        return null;
    }

    public static IConfiguredSite getAffinitySite(IInstallConfiguration config, IFeature newFeature) {
        IConfiguredSite affinitySite;
        String affinityID = newFeature.getAffinityFeature();
        if (affinityID != null && (affinitySite = UpdateUtils.getSiteWithFeature(config, affinityID)) != null) {
            return affinitySite;
        }
        return null;
    }

    public static IConfiguredSite getSiteWithFeature(IInstallConfiguration config, String featureID) {
        if (featureID == null) {
            return null;
        }
        IConfiguredSite[] sites = config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite site = sites[i];
            IFeatureReference[] refs = site.getFeatureReferences();
            int j = 0;
            while (j < refs.length) {
                IFeatureReference ref = refs[j];
                try {
                    IFeature feature = ref.getFeature(null);
                    if (featureID.equals(feature.getVersionedIdentifier().getIdentifier())) {
                        return site;
                    }
                }
                catch (CoreException e) {
                    UpdateUtils.logException(e);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static void collectOldFeatures(IFeature feature, IConfiguredSite targetSite, ArrayList result) throws CoreException {
        IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < included.length) {
            block6: {
                IFeature ifeature;
                IIncludedFeatureReference iref = included[i];
                try {
                    ifeature = iref.getFeature(null);
                }
                catch (CoreException e) {
                    if (!iref.isOptional()) {
                        throw e;
                    }
                    break block6;
                }
                String id = iref.getVersionedIdentifier().getIdentifier();
                IFeature[] sameIds = UpdateUtils.searchSite(id, targetSite, true);
                int j = 0;
                while (j < sameIds.length) {
                    IFeature sameId = sameIds[j];
                    if (!sameId.equals(ifeature)) {
                        result.add(sameId);
                    }
                    ++j;
                }
                UpdateUtils.collectOldFeatures(ifeature, targetSite, result);
            }
            ++i;
        }
    }

    public static void saveLocalSite() throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        localSite.save();
    }

    public static IInstallConfiguration createInstallConfiguration() throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.cloneCurrentConfiguration();
        config.setLabel(Utilities.format(config.getCreationDate()));
        return config;
    }

    public static UpdateSearchRequest createNewUpdatesRequest(IFeature[] features) {
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.setUpdateMapURL(UpdateUtils.getUpdateMapURL());
        UpdatesSearchCategory category = new UpdatesSearchCategory();
        if (features != null) {
            category.setFeatures(features);
        }
        UpdateSearchRequest searchRequest = new UpdateSearchRequest(category, scope);
        searchRequest.addFilter(new EnvironmentFilter());
        return searchRequest;
    }

    public static void makeConfigurationCurrent(IInstallConfiguration config, IInstallFeatureOperation job) throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        if (job != null && job.getFeature().isPatch()) {
            IInstallConfiguration cconfig = localSite.getCurrentConfiguration();
            IInstallConfiguration savedConfig = localSite.addToPreservedConfigurations(cconfig);
            VersionedIdentifier vid = job.getFeature().getVersionedIdentifier();
            String key = "@" + vid.getIdentifier() + "_" + vid.getVersion();
            String newLabel = UpdateUtils.getFormattedMessage(KEY_SAVED_CONFIG, key);
            savedConfig.setLabel(newLabel);
            OperationsManager.fireObjectChanged(savedConfig, null);
        }
        localSite.addConfiguration(config);
    }

    public static boolean isNestedChild(IInstallConfiguration config, IFeature feature) {
        IConfiguredSite[] csites = config.getConfiguredSites();
        try {
            int i = 0;
            while (csites != null && i < csites.length) {
                IFeatureReference[] refs = csites[i].getConfiguredFeatures();
                int j = 0;
                while (refs != null && j < refs.length) {
                    IFeature parent = refs[j].getFeature(null);
                    IIncludedFeatureReference[] children = parent.getIncludedFeatureReferences();
                    int k = 0;
                    while (children != null && k < children.length) {
                        IFeature child = children[k].getFeature(null);
                        if (feature.equals(child)) {
                            return true;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean hasObsoletePatches(IFeature feature) {
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                IFeature ifeature = iref.getFeature(null);
                IConfiguredSite csite = ifeature.getSite().getCurrentConfiguredSite();
                if (!csite.isConfigured(ifeature) && !UpdateUtils.isPatchHappy(ifeature)) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public static boolean isPatchHappy(IFeature feature) throws CoreException {
        IImport[] imports = feature.getImports();
        IImport patchReference = null;
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                patchReference = iimport;
                break;
            }
            ++i;
        }
        if (patchReference == null) {
            return false;
        }
        VersionedIdentifier refVid = patchReference.getVersionedIdentifier();
        IConfiguredSite csite = feature.getSite().getCurrentConfiguredSite();
        if (csite == null) {
            return false;
        }
        IFeatureReference[] crefs = csite.getConfiguredFeatures();
        int i2 = 0;
        while (i2 < crefs.length) {
            IFeatureReference cref = crefs[i2];
            VersionedIdentifier cvid = cref.getVersionedIdentifier();
            if (cvid.getIdentifier().equals(refVid.getIdentifier()) && cvid.getVersion().isGreaterThan(refVid.getVersion())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static URL getUpdateMapURL() {
        Preferences pref = UpdateCore.getPlugin().getPluginPreferences();
        String mapFile = pref.getString(P_UPDATE_POLICY_URL);
        if (mapFile != null && mapFile.length() > 0) {
            try {
                String decodedFile = URLDecoder.decode(mapFile, "UTF-8");
                return new URL(decodedFile);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return null;
    }

    public static ISessionDelta[] getSessionDeltas() {
        ArrayList<ISessionDelta> sessionDeltas = new ArrayList<ISessionDelta>();
        IPath path = UpdateCore.getPlugin().getStateLocation();
        File file = path.toFile();
        if (file.isDirectory()) {
            File[] allFiles = file.listFiles();
            int i = 0;
            while (i < allFiles.length) {
                block8: {
                    try {
                        if (allFiles[i].getName().endsWith(".xml")) {
                            InstallChangeParser parser;
                            ISessionDelta change;
                            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                                UpdateCore.debug("Found delta change:" + allFiles[i]);
                            }
                            if ((change = (parser = new InstallChangeParser(allFiles[i])).getInstallChange()) != null) {
                                sessionDeltas.add(change);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) break block8;
                        UpdateCore.log("Unable to parse install change:" + allFiles[i], e);
                    }
                }
                ++i;
            }
        }
        if (sessionDeltas.size() == 0) {
            return new ISessionDelta[0];
        }
        return (ISessionDelta[])sessionDeltas.toArray(UpdateUtils.arrayTypeFor(sessionDeltas));
    }

    private static Object[] arrayTypeFor(List l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        return (Object[])Array.newInstance(l.get(0).getClass(), 0);
    }

    public static void downloadFeatureContent(IFeature feature, final IProgressMonitor progress) throws InstallAbortedException, CoreException {
        if (!(feature instanceof Feature)) {
            return;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
            UpdateCore.debug("Downloading...:" + feature.getURL().toExternalForm());
        }
        NullProgressMonitor pm = new NullProgressMonitor(){

            public boolean isCanceled() {
                return progress.isCanceled();
            }
        };
        InstallMonitor monitor = new InstallMonitor((IProgressMonitor)pm);
        IFeatureContentProvider provider = feature.getFeatureContentProvider();
        IPluginEntry[] targetSitePluginEntries = null;
        IPluginEntry[] sourceFeaturePluginEntries = feature.getPluginEntries();
        IConfiguredSite targetSite = UpdateUtils.getSiteWithFeature(SiteManager.getLocalSite().getCurrentConfiguration(), ((Feature)feature).getFeatureIdentifier());
        if (targetSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                UpdateCore.debug("The site to install in is null");
            }
            targetSitePluginEntries = new IPluginEntry[]{};
        } else {
            targetSitePluginEntries = targetSite.getSite().getPluginEntries();
        }
        IPluginEntry[] pluginsToInstall = UpdateManagerUtils.diff(sourceFeaturePluginEntries, targetSitePluginEntries);
        INonPluginEntry[] nonPluginsToInstall = feature.getNonPluginEntries();
        provider.getFeatureEntryArchiveReferences(monitor);
        int i = 0;
        while (i < pluginsToInstall.length) {
            provider.getPluginEntryArchiveReferences(pluginsToInstall[i], monitor);
            ++i;
        }
        i = 0;
        while (i < nonPluginsToInstall.length) {
            provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i], monitor);
            ++i;
        }
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        int i2 = 0;
        while (i2 < children.length) {
            IFeature childFeature = null;
            try {
                childFeature = children[i2].getFeature(null);
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            if (childFeature != null) {
                UpdateUtils.downloadFeatureContent(childFeature, monitor);
            }
            ++i2;
        }
    }
}

