/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.api.operations.IUninstallFeatureOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;

public class UninstallOperation
extends FeatureOperation
implements IUninstallFeatureOperation {
    public UninstallOperation(IInstallConfiguration config, IConfiguredSite site, IFeature feature) {
        super(config, site, feature);
    }

    public void setInstallConfiguration(IInstallConfiguration config) {
        this.config = config;
    }

    public void setTargetSite(IConfiguredSite targetSite) {
        this.targetSite = targetSite;
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        if (this.targetSite == null) {
            this.targetSite = UpdateUtils.getConfigSite(this.feature, this.config);
        }
        if (this.targetSite == null) {
            String message = UpdateUtils.getFormattedMessage("OperationsManager.error.uninstall", this.feature.getLabel());
            Status status = new Status(4, UpdateUtils.getPluginId(), 0, message, null);
            throw new CoreException((IStatus)status);
        }
        this.targetSite.remove(this.feature, pm);
        this.markProcessed();
        if (listener != null) {
            listener.afterExecute(this, null);
        }
        SiteManager.getLocalSite().save();
        OperationsManager.fireObjectChanged(this.feature, "uninstall");
        return true;
    }
}

