/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.api.operations.IToggleSiteOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UpdateUtils;

public class ToggleSiteOperation
extends Operation
implements IToggleSiteOperation {
    private IConfiguredSite site;

    public ToggleSiteOperation(IConfiguredSite site) {
        this.site = site;
    }

    public boolean execute(IProgressMonitor monitor, IOperationListener listener) throws CoreException {
        if (this.site == null) {
            return false;
        }
        boolean oldValue = this.site.isEnabled();
        this.site.setEnabled(!oldValue);
        IStatus status = OperationsManager.getValidator().validateCurrentState();
        if (status != null) {
            this.site.setEnabled(oldValue);
            throw new CoreException(status);
        }
        try {
            SiteManager.getLocalSite().save();
            OperationsManager.fireObjectChanged(this.site, "");
            return true;
        }
        catch (CoreException e) {
            this.site.setEnabled(oldValue);
            UpdateUtils.logException(e);
            throw e;
        }
    }
}

