/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.operations.IConfigFeatureOperation;
import org.eclipse.update.internal.api.operations.IFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.api.operations.IUnconfigFeatureOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.PatchCleaner;
import org.eclipse.update.internal.operations.UpdateUtils;

public class ReplaceFeatureVersionOperation
extends FeatureOperation
implements IConfigFeatureOperation {
    private IFeature anotherFeature;

    public ReplaceFeatureVersionOperation(IFeature feature, IFeature anotherFeature) {
        super(feature.getSite().getCurrentConfiguredSite().getInstallConfiguration(), feature.getSite().getCurrentConfiguredSite(), feature);
        this.anotherFeature = anotherFeature;
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        IStatus status = OperationsManager.getValidator().validatePendingReplaceVersion(this.feature, this.anotherFeature);
        if (status != null) {
            throw new CoreException(status);
        }
        PatchCleaner cleaner = new PatchCleaner(this.targetSite, this.feature);
        this.targetSite.unconfigure(this.feature);
        cleaner.dispose();
        this.targetSite.configure(this.anotherFeature);
        this.ensureUnique();
        try {
            boolean restartNeeded = false;
            IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(this.feature);
            if (pendingOperation instanceof IConfigFeatureOperation) {
                OperationsManager.removePendingOperation(pendingOperation);
            } else {
                OperationsManager.addPendingOperation(this);
                restartNeeded = true;
            }
            pendingOperation = OperationsManager.findPendingOperation(this.anotherFeature);
            if (pendingOperation instanceof IUnconfigFeatureOperation) {
                OperationsManager.removePendingOperation(pendingOperation);
            } else {
                OperationsManager.addPendingOperation(this);
                restartNeeded = true;
            }
            this.markProcessed();
            if (listener != null) {
                listener.afterExecute(this, null);
            }
            SiteManager.getLocalSite().save();
            OperationsManager.fireObjectChanged(this.feature, null);
            return restartNeeded;
        }
        catch (CoreException e) {
            this.undo();
            UpdateUtils.logException(e);
            throw e;
        }
    }

    public void undo() throws CoreException {
        this.targetSite.unconfigure(this.anotherFeature);
        this.targetSite.configure(this.feature);
    }
}

