/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperationValidator;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;

public class OperationValidator
implements IOperationValidator {
    private static final String KEY_ROOT_MESSAGE = "ActivityConstraints.rootMessage";
    private static final String KEY_ROOT_MESSAGE_INIT = "ActivityConstraints.rootMessageInitial";
    private static final String KEY_CHILD_MESSAGE = "ActivityConstraints.childMessage";
    private static final String KEY_PLATFORM = "ActivityConstraints.platform";
    private static final String KEY_PRIMARY = "ActivityConstraints.primary";
    private static final String KEY_OS = "ActivityConstraints.os";
    private static final String KEY_WS = "ActivityConstraints.ws";
    private static final String KEY_ARCH = "ActivityConstraints.arch";
    private static final String KEY_PREREQ = "ActivityConstraints.prereq";
    private static final String KEY_PREREQ_PLUGIN = "ActivityConstaints.prereq.plugin";
    private static final String KEY_PREREQ_FEATURE = "ActivityConstaints.prereq.feature";
    private static final String KEY_PREREQ_PERFECT = "ActivityConstraints.prereqPerfect";
    private static final String KEY_PREREQ_EQUIVALENT = "ActivityConstraints.prereqEquivalent";
    private static final String KEY_PREREQ_COMPATIBLE = "ActivityConstraints.prereqCompatible";
    private static final String KEY_PREREQ_GREATER = "ActivityConstraints.prereqGreaterOrEqual";
    private static final String KEY_PATCH_REGRESSION = "ActivityConstraints.patchRegression";
    private static final String KEY_PATCH_UNCONFIGURE = "ActivityConstraints.patchUnconfigure";
    private static final String KEY_PATCH_UNCONFIGURE_BACKUP = "ActivityConstraints.patchUnconfigureBackup";
    private static final String KEY_PATCH_MISSING_TARGET = "ActivityConstraints.patchMissingTarget";
    private static final String KEY_OPTIONAL_CHILD = "ActivityConstraints.optionalChild";
    private static final String KEY_CYCLE = "ActivityConstraints.cycle";
    private static final String KEY_CONFLICT = "ActivityConstraints.conflict";
    private static final String KEY_EXCLUSIVE = "ActivityConstraints.exclusive";
    private static final String KEY_WRONG_TIMELINE = "ActivityConstraints.timeline";
    private static final String KEY_NO_LICENSE = "ActivityConstraints.noLicense";

    public IStatus validatePendingInstall(IFeature oldFeature, IFeature newFeature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validateInstall(oldFeature, newFeature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingUnconfig(IFeature feature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validateUnconfigure(feature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingConfig(IFeature feature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validateConfigure(feature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingReplaceVersion(IFeature feature, IFeature anotherFeature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validateReplaceVersion(feature, anotherFeature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validateSessionDelta(ISessionDelta delta, IFeatureReference[] deltaRefs) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        switch (delta.getType()) {
            case 1: {
                OperationValidator.validateDeltaConfigure(delta, deltaRefs, status);
            }
        }
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingRevert(IInstallConfiguration config) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validateRevert(config, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingChanges(IInstallFeatureOperation[] jobs) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validatePendingChanges(jobs, status, beforeStatus);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validateCurrentState() {
        ArrayList status = new ArrayList();
        OperationValidator.validateInitialState(status);
        if (status.size() > 0) {
            return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE, status, 4);
        }
        return null;
    }

    private static void validateInitialState(ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateUnconfigure(IFeature feature, ArrayList status) {
        try {
            if (OperationValidator.validateUnconfigurePatch(feature, status)) {
                return;
            }
            ArrayList features = OperationValidator.computeFeatures();
            features = OperationValidator.computeFeaturesAfterOperation(features, null, feature);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static boolean validateUnconfigurePatch(IFeature feature, ArrayList status) throws CoreException {
        if (feature.isPatch()) {
            IInstallConfiguration backup = UpdateUtils.getBackupConfigurationFor(feature);
            String msg = backup != null ? UpdateUtils.getFormattedMessage(KEY_PATCH_UNCONFIGURE_BACKUP, backup.getLabel()) : UpdateUtils.getString(KEY_PATCH_UNCONFIGURE);
            status.add(OperationValidator.createStatus(feature, msg));
            return true;
        }
        return false;
    }

    private static void validateConfigure(IFeature feature, ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkOptionalChildConfiguring(feature, status);
            OperationValidator.checkForCycles(feature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, feature, null);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateReplaceVersion(IFeature feature, IFeature anotherFeature, ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(feature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, anotherFeature, feature);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateInstall(IFeature oldFeature, IFeature newFeature, ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeatures();
            if (oldFeature == null && OperationValidator.isPatch(newFeature)) {
                OperationValidator.checkUnique(newFeature, features, status);
            }
            OperationValidator.checkForCycles(newFeature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
            OperationValidator.checkConstraints(features, status);
            OperationValidator.checkLicense(newFeature, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateRevert(IInstallConfiguration config, ArrayList status) {
        try {
            if (!OperationValidator.checkTimeline(config, status)) {
                return;
            }
            ArrayList features = OperationValidator.computeFeaturesAfterRevert(config);
            OperationValidator.checkConstraints(features, status);
            OperationValidator.checkRevertConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateDeltaConfigure(ISessionDelta delta, IFeatureReference[] deltaRefs, ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeaturesAfterDelta(delta, deltaRefs);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validatePendingChanges(IInstallFeatureOperation[] jobs, ArrayList status, ArrayList beforeStatus) {
        try {
            IFeature oldFeature;
            IFeature newFeature;
            IInstallFeatureOperation job;
            ArrayList features;
            ArrayList savedFeatures = features = OperationValidator.computeFeatures();
            int nexclusives = 0;
            ArrayList tmpStatus = new ArrayList();
            int i = 0;
            while (i < jobs.length) {
                job = jobs[i];
                newFeature = job.getFeature();
                oldFeature = job.getOldFeature();
                OperationValidator.checkLicense(newFeature, status);
                if (jobs.length > 1 && newFeature.isExclusive()) {
                    ++nexclusives;
                    status.add(OperationValidator.createStatus(newFeature, UpdateUtils.getString(KEY_EXCLUSIVE)));
                } else {
                    OperationValidator.checkForCycles(newFeature, null, features);
                    features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
                }
                ++i;
            }
            if (nexclusives > 0) {
                return;
            }
            OperationValidator.checkConstraints(features, tmpStatus);
            if (tmpStatus.size() == 0) {
                return;
            }
            features = savedFeatures;
            i = 0;
            while (i < jobs.length) {
                job = jobs[i];
                newFeature = job.getFeature();
                oldFeature = job.getOldFeature();
                features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
                OperationValidator.checkConstraints(features, status);
                if (status.size() > 0 && !OperationValidator.isBetterStatus(beforeStatus, status)) {
                    IStatus conflict = OperationValidator.createStatus(newFeature, UpdateUtils.getString(KEY_CONFLICT));
                    status.add(0, conflict);
                    return;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static ArrayList computeFeatures() throws CoreException {
        return OperationValidator.computeFeatures(true);
    }

    private static ArrayList computeFeatures(boolean configuredOnly) throws CoreException {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] crefs = configuredOnly ? csite.getConfiguredFeatures() : csite.getSite().getFeatureReferences();
            int j = 0;
            while (j < crefs.length) {
                IFeatureReference cref = crefs[j];
                IFeature cfeature = cref.getFeature(null);
                features.add(cfeature);
                ++j;
            }
            ++i;
        }
        return features;
    }

    private static ArrayList computeFeatureSubtree(IFeature top, IFeature feature, ArrayList features, boolean tolerateMissingChildren, ArrayList configuredFeatures, ArrayList visitedFeatures) throws CoreException {
        if (top == null) {
            return features;
        }
        if (feature == null) {
            feature = top;
        }
        if (features == null) {
            features = new ArrayList();
        }
        if (visitedFeatures == null) {
            visitedFeatures = new ArrayList<IFeature>();
        }
        if (visitedFeatures.contains(feature)) {
            IStatus status = OperationValidator.createStatus(top, UpdateUtils.getString(KEY_CYCLE));
            throw new CoreException(status);
        }
        visitedFeatures.add(feature);
        if (!features.contains(feature)) {
            features.add(feature);
        }
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < children.length) {
            block9: {
                try {
                    IFeature child = configuredFeatures == null ? children[i].getFeature(null) : OperationValidator.getBestMatch(children[i], configuredFeatures);
                    features = OperationValidator.computeFeatureSubtree(top, child, features, tolerateMissingChildren, null, visitedFeatures);
                }
                catch (CoreException e) {
                    if (children[i].isOptional() || tolerateMissingChildren) break block9;
                    throw e;
                }
            }
            ++i;
        }
        visitedFeatures.remove(feature);
        return features;
    }

    private static IFeature getBestMatch(IIncludedFeatureReference ref, ArrayList configuredFeatures) throws CoreException {
        int match = ref.getMatch();
        ISite site = ref.getSite();
        IConfiguredSite csite = site.getCurrentConfiguredSite();
        if (csite == null && match != 1) {
            VersionedIdentifier vid = ref.getVersionedIdentifier();
            PluginVersionIdentifier version = vid.getVersion();
            int i = 0;
            while (i < configuredFeatures.size()) {
                PluginVersionIdentifier fversion;
                IFeature feature = (IFeature)configuredFeatures.get(i);
                VersionedIdentifier fvid = feature.getVersionedIdentifier();
                if (fvid.getIdentifier().equals(vid.getIdentifier()) && (fversion = fvid.getVersion()).isGreaterThan(version)) {
                    boolean matches = false;
                    switch (match) {
                        case 3: {
                            matches = fvid.getVersion().isCompatibleWith(vid.getVersion());
                            break;
                        }
                        case 2: {
                            matches = fvid.getVersion().isEquivalentTo(vid.getVersion());
                            break;
                        }
                        case 4: {
                            matches = fvid.getVersion().isGreaterOrEqualTo(vid.getVersion());
                        }
                    }
                    if (matches) {
                        return feature;
                    }
                }
                ++i;
            }
        }
        return ref.getFeature(null);
    }

    private static void checkLicense(IFeature feature, ArrayList status) {
        String license;
        IURLEntry licenseEntry = feature.getLicense();
        if (licenseEntry != null && (license = licenseEntry.getAnnotation()) != null && license.trim().length() > 0) {
            return;
        }
        status.add(OperationValidator.createStatus(feature, UpdateUtils.getString(KEY_NO_LICENSE)));
    }

    private static ArrayList computeFeaturesAfterOperation(ArrayList features, IFeature add, IFeature remove) throws CoreException {
        ArrayList addTree = OperationValidator.computeFeatureSubtree(add, null, null, false, features, null);
        ArrayList removeTree = OperationValidator.computeFeatureSubtree(remove, null, null, true, null, null);
        if (remove != null) {
            OperationValidator.contributePatchesFor(removeTree, features, removeTree);
        }
        if (remove != null) {
            features.removeAll(removeTree);
        }
        if (add != null) {
            features.addAll(addTree);
        }
        return features;
    }

    private static void contributePatchesFor(ArrayList removeTree, ArrayList features, ArrayList result) throws CoreException {
        int i = 0;
        while (i < removeTree.size()) {
            IFeature feature = (IFeature)removeTree.get(i);
            OperationValidator.contributePatchesFor(feature, features, result);
            ++i;
        }
    }

    private static void contributePatchesFor(IFeature feature, ArrayList features, ArrayList result) throws CoreException {
        int i = 0;
        while (i < features.size()) {
            IFeature candidate = (IFeature)features.get(i);
            if (UpdateUtils.isPatch(feature, candidate)) {
                ArrayList removeTree = OperationValidator.computeFeatureSubtree(candidate, null, null, true, null, null);
                result.addAll(removeTree);
            }
            ++i;
        }
    }

    private static ArrayList computeFeaturesAfterRevert(IInstallConfiguration config) throws CoreException {
        ArrayList<IFeature> list = new ArrayList<IFeature>();
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] features = csite.getConfiguredFeatures();
            int j = 0;
            while (j < features.length) {
                list.add(features[j].getFeature(null));
                ++j;
            }
            ++i;
        }
        return list;
    }

    private static ArrayList computeFeaturesAfterDelta(ISessionDelta delta, IFeatureReference[] deltaRefs) throws CoreException {
        if (delta == null || deltaRefs == null) {
            deltaRefs = new IFeatureReference[]{};
        } else if (deltaRefs == null) {
            deltaRefs = delta.getFeatureReferences();
        }
        ArrayList features = new ArrayList();
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            ArrayList<IFeature> siteFeatures = new ArrayList<IFeature>();
            IFeatureReference[] crefs = csite.getConfiguredFeatures();
            int j = 0;
            while (crefs != null && j < crefs.length) {
                IFeatureReference cref = crefs[j];
                IFeature cfeature = cref.getFeature(null);
                siteFeatures.add(cfeature);
                ++j;
            }
            j = 0;
            while (j < deltaRefs.length) {
                IFeature dfeature;
                ISite deltaSite = deltaRefs[j].getSite();
                if (deltaSite.equals(csite.getSite()) && !siteFeatures.contains(dfeature = deltaRefs[j].getFeature(null))) {
                    siteFeatures.add(dfeature);
                }
                ++j;
            }
            IFeature[] array = siteFeatures.toArray(new IFeature[siteFeatures.size()]);
            ArrayList<IFeature> removeTree = new ArrayList<IFeature>();
            int j2 = 0;
            while (j2 < array.length) {
                VersionedIdentifier id1 = array[j2].getVersionedIdentifier();
                int k = 0;
                while (k < array.length) {
                    if (j2 != k) {
                        VersionedIdentifier id2 = array[k].getVersionedIdentifier();
                        if (id1.getIdentifier().equals(id2.getIdentifier()) && id2.getVersion().isGreaterThan(id1.getVersion())) {
                            removeTree.add(array[j2]);
                            siteFeatures.remove(array[j2]);
                            break;
                        }
                    }
                    ++k;
                }
                ++j2;
            }
            ArrayList patchesTree = new ArrayList();
            OperationValidator.contributePatchesFor(removeTree, siteFeatures, patchesTree);
            siteFeatures.removeAll(patchesTree);
            features.addAll(siteFeatures);
            ++i;
        }
        return features;
    }

    private static ArrayList computePluginsForFeatures(ArrayList features) throws CoreException {
        if (features == null) {
            return new ArrayList();
        }
        HashMap<VersionedIdentifier, IPluginEntry> plugins = new HashMap<VersionedIdentifier, IPluginEntry>();
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            IPluginEntry[] entries = feature.getPluginEntries();
            int j = 0;
            while (j < entries.length) {
                IPluginEntry entry = entries[j];
                plugins.put(entry.getVersionedIdentifier(), entry);
                ++j;
            }
            ++i;
        }
        ArrayList result = new ArrayList();
        result.addAll(plugins.values());
        return result;
    }

    private static boolean isPatch(IFeature feature) {
        IImport[] imports = feature.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void checkForCycles(IFeature feature, ArrayList candidates, ArrayList configuredFeatures) throws CoreException {
        if (feature == null) {
            return;
        }
        if (configuredFeatures == null) {
            configuredFeatures = new ArrayList();
        }
        if (candidates == null) {
            candidates = new ArrayList<IFeature>();
        }
        if (candidates.contains(feature)) {
            String msg = UpdateUtils.getFormattedMessage(KEY_CYCLE, new String[]{feature.getLabel(), feature.getVersionedIdentifier().toString()});
            IStatus status = OperationValidator.createStatus(feature, msg);
            throw new CoreException(status);
        }
        candidates.add(feature);
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < children.length) {
            block7: {
                try {
                    IFeature child = OperationValidator.getBestMatch(children[i], configuredFeatures);
                    OperationValidator.checkForCycles(child, candidates, configuredFeatures);
                }
                catch (CoreException e) {
                    if (children[i].isOptional()) break block7;
                    throw e;
                }
            }
            ++i;
        }
        candidates.remove(feature);
    }

    private static void checkUnique(IFeature feature, ArrayList features, ArrayList status) throws CoreException {
        if (features == null) {
            return;
        }
        IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < irefs.length) {
            IIncludedFeatureReference iref = irefs[i];
            IFeature ifeature = iref.getFeature(null);
            boolean patch = OperationValidator.isPatch(ifeature);
            VersionedIdentifier vid = ifeature.getVersionedIdentifier();
            String id = vid.getIdentifier();
            PluginVersionIdentifier version = vid.getVersion();
            boolean found = false;
            int j = 0;
            while (j < features.size()) {
                IFeature candidate = (IFeature)features.get(j);
                VersionedIdentifier cvid = candidate.getVersionedIdentifier();
                String cid = cvid.getIdentifier();
                PluginVersionIdentifier cversion = cvid.getVersion();
                if (cid.equals(id)) {
                    found = true;
                    if (!version.equals((Object)cversion) && !version.isGreaterThan(cversion)) {
                        String msg = UpdateUtils.getFormattedMessage(KEY_PATCH_REGRESSION, new String[]{ifeature.getLabel(), version.toString()});
                        status.add(OperationValidator.createStatus(feature, msg));
                    }
                }
                ++j;
            }
            if (!(found || patch || iref.isOptional())) {
                String msg = UpdateUtils.getFormattedMessage(KEY_PATCH_MISSING_TARGET, new String[]{ifeature.getLabel(), version.toString()});
                status.add(OperationValidator.createStatus(feature, msg));
            }
            if (patch) {
                OperationValidator.checkUnique(ifeature, features, status);
            }
            ++i;
        }
    }

    private static void checkConstraints(ArrayList features, ArrayList status) throws CoreException {
        if (features == null) {
            return;
        }
        ArrayList plugins = OperationValidator.computePluginsForFeatures(features);
        OperationValidator.checkEnvironment(features, status);
        OperationValidator.checkPlatformFeature(features, plugins, status);
        OperationValidator.checkPrimaryFeature(features, status);
        OperationValidator.checkPrereqs(features, plugins, status);
    }

    private static void checkEnvironment(ArrayList features, ArrayList status) {
        String os = BootLoader.getOS();
        String ws = BootLoader.getWS();
        String arch = BootLoader.getOSArch();
        int i = 0;
        while (i < features.size()) {
            IStatus s;
            IFeature feature = (IFeature)features.get(i);
            ArrayList fos = OperationValidator.createList(feature.getOS());
            ArrayList fws = OperationValidator.createList(feature.getWS());
            ArrayList farch = OperationValidator.createList(feature.getOSArch());
            if (fos.size() > 0 && !fos.contains(os)) {
                s = OperationValidator.createStatus(feature, UpdateUtils.getString(KEY_OS));
                if (!status.contains(s)) {
                    status.add(s);
                }
            } else if (fws.size() > 0 && !fws.contains(ws)) {
                s = OperationValidator.createStatus(feature, UpdateUtils.getString(KEY_WS));
                if (!status.contains(s)) {
                    status.add(s);
                }
            } else if (farch.size() > 0 && !farch.contains(arch) && !status.contains(s = OperationValidator.createStatus(feature, UpdateUtils.getString(KEY_ARCH)))) {
                status.add(s);
            }
            ++i;
        }
    }

    private static void checkPlatformFeature(ArrayList features, ArrayList plugins, ArrayList status) {
        String[] bootstrapPlugins = BootLoader.getCurrentPlatformConfiguration().getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < bootstrapPlugins.length) {
            boolean found = false;
            int j = 0;
            while (j < plugins.size()) {
                IPluginEntry plugin = (IPluginEntry)plugins.get(j);
                if (bootstrapPlugins[i].equals(plugin.getVersionedIdentifier().getIdentifier())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                IStatus s = OperationValidator.createStatus(null, UpdateUtils.getString(KEY_PLATFORM));
                if (!status.contains(s)) {
                    status.add(s);
                }
                return;
            }
            ++i;
        }
    }

    private static void checkPrimaryFeature(ArrayList features, ArrayList status) {
        String featureId = BootLoader.getCurrentPlatformConfiguration().getPrimaryFeatureIdentifier();
        if (featureId == null) {
            return;
        }
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            if (featureId.equals(feature.getVersionedIdentifier().getIdentifier())) {
                return;
            }
            ++i;
        }
        IStatus s = OperationValidator.createStatus(null, UpdateUtils.getString(KEY_PRIMARY));
        if (!status.contains(s)) {
            status.add(s);
        }
    }

    private static void checkPrereqs(ArrayList features, ArrayList plugins, ArrayList status) {
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            IImport[] imports = feature.getImports();
            int j = 0;
            while (j < imports.length) {
                IImport iimport = imports[j];
                VersionedIdentifier iid = iimport.getVersionedIdentifier();
                String id = iid.getIdentifier();
                PluginVersionIdentifier version = iid.getVersion();
                boolean featurePrereq = iimport.getKind() == 1;
                boolean ignoreVersion = version.getMajorComponent() == 0 && version.getMinorComponent() == 0 && version.getServiceComponent() == 0;
                int rule = iimport.getRule();
                if (rule == 0) {
                    rule = 3;
                }
                boolean found = false;
                ArrayList candidates = featurePrereq ? features : plugins;
                int k = 0;
                while (k < candidates.size()) {
                    block25: {
                        VersionedIdentifier cid;
                        block26: {
                            block24: {
                                if (!featurePrereq) break block24;
                                IFeature candidate = (IFeature)candidates.get(k);
                                if (feature.equals(candidate)) break block25;
                                cid = candidate.getVersionedIdentifier();
                                break block26;
                            }
                            IPluginEntry plugin = (IPluginEntry)candidates.get(k);
                            cid = plugin.getVersionedIdentifier();
                        }
                        PluginVersionIdentifier cversion = cid.getVersion();
                        if (id.equals(cid.getIdentifier())) {
                            if (ignoreVersion) {
                                found = true;
                            } else if (rule == 1 && cversion.isPerfect(version)) {
                                found = true;
                            } else if (rule == 2 && cversion.isEquivalentTo(version)) {
                                found = true;
                            } else if (rule == 3 && cversion.isCompatibleWith(version)) {
                                found = true;
                            } else if (rule == 4 && cversion.isGreaterOrEqualTo(version)) {
                                found = true;
                            }
                        }
                        if (found) break;
                    }
                    ++k;
                }
                if (!found) {
                    IStatus s;
                    String target = featurePrereq ? UpdateUtils.getString(KEY_PREREQ_FEATURE) : UpdateUtils.getString(KEY_PREREQ_PLUGIN);
                    String msg = UpdateUtils.getFormattedMessage(KEY_PREREQ, new String[]{target, id});
                    if (!ignoreVersion) {
                        if (rule == 1) {
                            msg = UpdateUtils.getFormattedMessage(KEY_PREREQ_PERFECT, new String[]{target, id, version.toString()});
                        } else if (rule == 2) {
                            msg = UpdateUtils.getFormattedMessage(KEY_PREREQ_EQUIVALENT, new String[]{target, id, version.toString()});
                        } else if (rule == 3) {
                            msg = UpdateUtils.getFormattedMessage(KEY_PREREQ_COMPATIBLE, new String[]{target, id, version.toString()});
                        } else if (rule == 4) {
                            msg = UpdateUtils.getFormattedMessage(KEY_PREREQ_GREATER, new String[]{target, id, version.toString()});
                        }
                    }
                    if (!status.contains(s = OperationValidator.createStatus(feature, msg))) {
                        status.add(s);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void checkRevertConstraints(ArrayList features, ArrayList status) {
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            try {
                OperationValidator.computeFeatureSubtree(feature, null, null, false, null, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
    }

    private static void checkOptionalChildConfiguring(IFeature feature, ArrayList status) throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        boolean included = false;
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            ISiteFeatureReference[] crefs = csite.getSite().getFeatureReferences();
            int j = 0;
            while (j < crefs.length) {
                ISiteFeatureReference cref = crefs[j];
                IFeature cfeature = null;
                cfeature = cref.getFeature(null);
                if (OperationValidator.isParent(cfeature, feature, true)) {
                    included = true;
                    if (csite.isConfigured(cfeature)) {
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (included) {
            String msg = UpdateUtils.getString(KEY_OPTIONAL_CHILD);
            status.add(OperationValidator.createStatus(feature, msg));
        }
    }

    private static void checkConfigurationLock(ArrayList status) {
    }

    private static boolean isParent(IFeature candidate, IFeature feature, boolean optionalOnly) throws CoreException {
        IIncludedFeatureReference[] refs = candidate.getIncludedFeatureReferences();
        int i = 0;
        while (i < refs.length) {
            IIncludedFeatureReference child = refs[i];
            VersionedIdentifier fvid = feature.getVersionedIdentifier();
            VersionedIdentifier cvid = child.getVersionedIdentifier();
            if (fvid.getIdentifier().equals(cvid.getIdentifier())) {
                PluginVersionIdentifier fversion = fvid.getVersion();
                PluginVersionIdentifier cversion = cvid.getVersion();
                int match = child.getMatch();
                boolean matched = false;
                switch (match) {
                    case 2: {
                        if (!fversion.isEquivalentTo(cversion)) break;
                        matched = true;
                        break;
                    }
                    case 3: {
                        if (!fversion.isCompatibleWith(cversion)) break;
                        matched = true;
                        break;
                    }
                    case 4: {
                        if (!fversion.isGreaterOrEqualTo(cversion)) break;
                        matched = true;
                        break;
                    }
                    default: {
                        if (!fversion.equals((Object)cversion)) break;
                        matched = true;
                    }
                }
                if (matched) {
                    return !optionalOnly || child.isOptional();
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean checkTimeline(IInstallConfiguration config, ArrayList status) {
        try {
            ILocalSite lsite = SiteManager.getLocalSite();
            IInstallConfiguration cconfig = lsite.getCurrentConfiguration();
            if (cconfig.getTimeline() != config.getTimeline()) {
                String msg = UpdateUtils.getFormattedMessage(KEY_WRONG_TIMELINE, config.getLabel());
                status.add(OperationValidator.createStatus(null, msg));
                return false;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        return true;
    }

    private static IStatus createMultiStatus(String rootKey, ArrayList children, int code) {
        IStatus[] carray = children.toArray(new IStatus[children.size()]);
        String message = UpdateUtils.getString(rootKey);
        return new MultiStatus(UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier(), code, carray, message, null);
    }

    private static IStatus createStatus(IFeature feature, String message) {
        String fullMessage;
        if (feature == null) {
            fullMessage = message;
        } else {
            PluginVersionIdentifier version = feature.getVersionedIdentifier().getVersion();
            fullMessage = UpdateUtils.getFormattedMessage(KEY_CHILD_MESSAGE, new String[]{feature.getLabel(), version.toString(), message});
        }
        Status status = new Status(4, UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier(), 0, fullMessage, null);
        return new FeatureStatus(feature, (IStatus)status);
    }

    private static IStatus createCombinedReportStatus(ArrayList beforeStatus, ArrayList status) {
        if (beforeStatus.size() == 0) {
            if (status.size() == 0) {
                return null;
            }
            return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE, status, 4);
        }
        if (status.size() == 0) {
            return null;
        }
        if (OperationValidator.isBetterStatus(beforeStatus, status)) {
            return OperationValidator.createMultiStatus("ActivityConstraints.warning", beforeStatus, 2);
        }
        ArrayList<IStatus> combined = new ArrayList<IStatus>();
        combined.add(OperationValidator.createMultiStatus("ActivityConstraints.beforeMessage", beforeStatus, 4));
        combined.add(OperationValidator.createMultiStatus("ActivityConstraints.afterMessage", status, 4));
        return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE_INIT, combined, 4);
    }

    private static ArrayList createList(String commaSeparatedList) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedList != null) {
            StringTokenizer t = new StringTokenizer(commaSeparatedList.trim(), ",");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.equals("")) continue;
                list.add(token);
            }
        }
        return list;
    }

    private static boolean isBetterStatus(ArrayList beforeStatus, ArrayList status) {
        if (status == null || status.size() == 0) {
            return true;
        }
        if (beforeStatus == null || beforeStatus.size() == 0) {
            return false;
        }
        if (beforeStatus.size() < status.size()) {
            return false;
        }
        int i = 0;
        while (i < status.size()) {
            IStatus s = (IStatus)status.get(i);
            if (!(s instanceof FeatureStatus)) {
                return false;
            }
            FeatureStatus fs = (FeatureStatus)s;
            boolean found = false;
            int j = 0;
            while (!found && j < beforeStatus.size()) {
                if (fs.equals(beforeStatus.get(j))) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class FeatureStatus
    implements IStatus {
        IStatus status;
        IFeature feature;

        public FeatureStatus(IFeature feature, IStatus status) {
            this.status = status;
            this.feature = feature;
        }

        public IStatus[] getChildren() {
            return this.status.getChildren();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public Throwable getException() {
            return this.status.getException();
        }

        public String getMessage() {
            return this.status.getMessage();
        }

        public String getPlugin() {
            return this.status.getPlugin();
        }

        public int getSeverity() {
            return this.status.getSeverity();
        }

        public boolean isMultiStatus() {
            return this.status.isMultiStatus();
        }

        public boolean isOK() {
            return this.status.isOK();
        }

        public boolean matches(int severityMask) {
            return this.status.matches(severityMask);
        }

        public IFeature getFeature() {
            return this.feature;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FeatureStatus)) {
                return false;
            }
            FeatureStatus fs = (FeatureStatus)obj;
            if (fs.getFeature() == this.feature) {
                return true;
            }
            if (fs.getFeature() == null && this.feature == null) {
                return fs.getMessage().equals(this.getMessage());
            }
            if (fs.getFeature() == null && this.feature != null) {
                return false;
            }
            if (fs.getFeature() != null && this.feature == null) {
                return false;
            }
            return fs.getFeature().equals(this.feature);
        }
    }
}

