/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.operations.JobTargetSite;
import org.eclipse.update.internal.operations.UpdateUtils;

public class JobTargetSites
extends HashMap {
    private IInstallConfiguration config;
    private IInstallFeatureOperation[] jobs;

    public JobTargetSites(IInstallConfiguration config) {
        this.config = config;
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobs = jobs;
    }

    public void computeDefaultTargetSites() {
        this.clear();
        int i = 0;
        while (i < this.jobs.length) {
            JobTargetSite jobSite = new JobTargetSite();
            jobSite.job = this.jobs[i];
            jobSite.defaultSite = UpdateUtils.getDefaultTargetSite(this.config, this.jobs[i], false);
            jobSite.affinitySite = UpdateUtils.getAffinitySite(this.config, this.jobs[i].getFeature());
            if (jobSite.affinitySite == null) {
                jobSite.affinitySite = this.jobs[i].getTargetSite();
            }
            jobSite.targetSite = this.computeTargetSite(jobSite);
            this.put(this.jobs[i], jobSite);
            ++i;
        }
    }

    public IConfiguredSite computeTargetSite(JobTargetSite jobSite) {
        IConfiguredSite csite = jobSite.affinitySite != null ? jobSite.affinitySite : jobSite.defaultSite;
        return csite == null ? this.getFirstTarget(jobSite) : csite;
    }

    public boolean getSiteVisibility(IConfiguredSite site, JobTargetSite jobSite) {
        if (jobSite.affinitySite != null) {
            return site.getSite().equals(jobSite.affinitySite.getSite());
        }
        if (site.equals(jobSite.defaultSite)) {
            return true;
        }
        if (site.isPrivateSite() && site.isUpdatable()) {
            return true;
        }
        return jobSite.job.getOldFeature() == null && site.isProductSite();
    }

    private IConfiguredSite getFirstTarget(JobTargetSite jobSite) {
        IConfiguredSite firstSite = jobSite.targetSite;
        if (firstSite == null) {
            IConfiguredSite[] sites = this.config.getConfiguredSites();
            int i = 0;
            while (i < sites.length) {
                IConfiguredSite csite = sites[i];
                if (this.getSiteVisibility(csite, jobSite)) {
                    firstSite = csite;
                    break;
                }
                ++i;
            }
        }
        return firstSite;
    }

    public JobTargetSite findPatchedFeature(IFeature patch) {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            JobTargetSite jobSite = (JobTargetSite)this.get(iterator.next());
            IFeature target = jobSite.job.getFeature();
            if (target.equals(patch) || !UpdateUtils.isPatch(target, patch)) continue;
            return jobSite;
        }
        return null;
    }

    public JobTargetSite[] getJobTargetSites() {
        JobTargetSite[] sites = new JobTargetSite[this.jobs.length];
        int i = 0;
        while (i < this.jobs.length) {
            JobTargetSite jobSite;
            sites[i] = jobSite = (JobTargetSite)this.get(this.jobs[i]);
            ++i;
        }
        return sites;
    }

    public IConfiguredSite getTargetSite(IInstallFeatureOperation job) {
        JobTargetSite jobSite;
        IInstallFeatureOperation target = null;
        int i = 0;
        while (this.jobs != null && i < this.jobs.length) {
            if (job == this.jobs[i]) {
                target = this.jobs[i];
                break;
            }
            ++i;
        }
        if (target != null && (jobSite = (JobTargetSite)this.get(target)) != null) {
            return jobSite.targetSite;
        }
        return null;
    }
}

