/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.internal.api.operations.IFeatureOperation;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.PatchCleaner;
import org.eclipse.update.internal.operations.UpdateUtils;

public abstract class FeatureOperation
extends Operation
implements IFeatureOperation {
    protected IFeature feature;
    protected IFeature oldFeature;
    protected IInstallConfiguration config;
    protected IConfiguredSite targetSite;

    public FeatureOperation(IInstallConfiguration config, IConfiguredSite targetSite, IFeature feature) {
        this.feature = feature;
        this.config = config;
        this.targetSite = targetSite;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public IFeature getOldFeature() {
        return this.oldFeature;
    }

    public IConfiguredSite getTargetSite() {
        return this.targetSite;
    }

    public IInstallConfiguration getInstallConfiguration() {
        return this.config;
    }

    public void setInstallConfiguration(IInstallConfiguration config) {
        this.config = config;
    }

    public void setTargetSite(IConfiguredSite targetSite) {
        this.targetSite = targetSite;
    }

    void ensureUnique() throws CoreException {
        boolean patch = false;
        if (this.targetSite == null) {
            this.targetSite = this.feature.getSite().getCurrentConfiguredSite();
        }
        IImport[] imports = this.feature.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                patch = true;
                break;
            }
            ++i;
        }
        if (!patch) {
            return;
        }
        IFeature localFeature = UpdateUtils.getLocalFeature(this.targetSite, this.feature);
        ArrayList oldFeatures = new ArrayList();
        UpdateUtils.collectOldFeatures(localFeature, this.targetSite, oldFeatures);
        int i2 = 0;
        while (i2 < oldFeatures.size()) {
            IFeature oldFeature = (IFeature)oldFeatures.get(i2);
            FeatureOperation.unconfigure(this.config, oldFeature);
            ++i2;
        }
    }

    static void configure(IInstallConfiguration config, IFeature feature) throws CoreException {
        IConfiguredSite site = UpdateUtils.getConfigSite(feature, config);
        if (site != null) {
            site.configure(feature);
        }
    }

    static boolean unconfigure(IInstallConfiguration config, IFeature feature) throws CoreException {
        IConfiguredSite site = UpdateUtils.getConfigSite(feature, config);
        if (site != null) {
            PatchCleaner cleaner = new PatchCleaner(site, feature);
            boolean result = site.unconfigure(feature);
            cleaner.dispose();
            return result;
        }
        return false;
    }
}

