/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.operations.IConfigFeatureOperation;
import org.eclipse.update.internal.api.operations.IFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.api.operations.IUnconfigFeatureOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;

public class ConfigOperation
extends FeatureOperation
implements IConfigFeatureOperation {
    public ConfigOperation(IInstallConfiguration config, IConfiguredSite site, IFeature feature) {
        super(config, site, feature);
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        IStatus status = OperationsManager.getValidator().validatePendingConfig(this.feature);
        if (status != null && status.getCode() == 4) {
            throw new CoreException(status);
        }
        this.targetSite.configure(this.feature);
        this.ensureUnique();
        try {
            boolean restartNeeded = false;
            IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(this.feature);
            if (pendingOperation instanceof IUnconfigFeatureOperation) {
                OperationsManager.removePendingOperation(pendingOperation);
            } else {
                OperationsManager.addPendingOperation(this);
                restartNeeded = true;
            }
            this.markProcessed();
            if (listener != null) {
                listener.afterExecute(this, null);
            }
            SiteManager.getLocalSite().save();
            OperationsManager.fireObjectChanged(this.feature, null);
            return restartNeeded;
        }
        catch (CoreException e) {
            this.undo();
            UpdateUtils.logException(e);
            throw e;
        }
    }

    public void undo() throws CoreException {
        this.targetSite.unconfigure(this.feature);
    }
}

