/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.api.operations.IBatchOperation;
import org.eclipse.update.internal.api.operations.IFeatureOperation;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UpdateUtils;

public class BatchInstallOperation
extends Operation
implements IBatchOperation {
    private static final String KEY_INSTALLING = "OperationsManager.installing";
    protected IInstallFeatureOperation[] operations;

    public BatchInstallOperation(IInstallFeatureOperation[] operations) {
        this.operations = operations;
    }

    public IFeatureOperation[] getOperations() {
        return this.operations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor monitor, IOperationListener listener) throws CoreException, InvocationTargetException {
        int installCount = 0;
        if (this.operations == null) return false;
        if (this.operations.length == 0) {
            return false;
        }
        IInstallConfiguration config = this.operations[0].getInstallConfiguration();
        OperationsManager.setInProgress(true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                if (listener != null) {
                    listener.beforeExecute(this, null);
                }
                UpdateUtils.makeConfigurationCurrent(config, null);
                monitor.beginTask(UpdateUtils.getString(KEY_INSTALLING), this.operations.length);
                int i = 0;
                while (true) {
                    if (i >= this.operations.length) {
                        Object var7_9 = null;
                        break;
                    }
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1, 4);
                    this.operations[i].execute((IProgressMonitor)subMonitor, listener);
                    OperationsManager.addPendingOperation(this.operations[i]);
                    this.operations[i].markProcessed();
                    if (listener != null) {
                        listener.afterExecute(this.operations[i], null);
                    }
                    ++installCount;
                    ++i;
                }
            }
            catch (InstallAbortedException e) {
                throw new InvocationTargetException((Throwable)((Object)e));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            UpdateUtils.saveLocalSite();
            OperationsManager.setInProgress(false);
            monitor.done();
            throw throwable;
        }
        UpdateUtils.saveLocalSite();
        OperationsManager.setInProgress(false);
        monitor.done();
        return true;
    }
}

