/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.URLEntry;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InstallConfigurationParser
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private InputStream siteStream;
    private URL siteURL;
    private InstallConfigurationModel config;
    private ConfiguredSiteModel configSite;
    public static final String CONFIGURATION = "configuration";
    public static final String CONFIGURATION_SITE = "site";
    public static final String FEATURE = "feature";
    public static final String ACTIVITY = "activity";
    private Map sites = new HashMap();

    public InstallConfigurationParser(InputStream siteStream, InstallConfigurationModel config) throws IOException, SAXException, CoreException {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            UpdateCore.log(e);
        }
        catch (SAXException e) {
            UpdateCore.log(e);
        }
        this.siteStream = siteStream;
        this.config = config;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start parsing Configuration:" + config.getURL().toExternalForm());
        }
        this.parser.parse(new InputSource(this.siteStream), (DefaultHandler)this);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        try {
            String tag = localName.trim();
            if (tag.equalsIgnoreCase(CONFIGURATION)) {
                this.processConfig(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(CONFIGURATION_SITE)) {
                this.processSite(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(FEATURE)) {
                this.processFeature(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(ACTIVITY)) {
                this.processActivity(attributes);
                return;
            }
        }
        catch (MalformedURLException e) {
            throw new SAXException(Policy.bind("Parser.UnableToCreateURL", e.getMessage()), e);
        }
        catch (CoreException e) {
            throw new SAXException(Policy.bind("Parser.InternalError", e.toString()), (Exception)((Object)e));
        }
    }

    private void processSite(Attributes attributes) throws MalformedURLException, CoreException {
        String urlString = attributes.getValue("url");
        this.siteURL = new URL(urlString);
        ISite site = SiteManager.getSite(this.siteURL, null);
        this.sites.put(urlString, site);
        String policyString = attributes.getValue("policy");
        int policy = Integer.parseInt(policyString);
        BaseSiteLocalFactory factory = new BaseSiteLocalFactory();
        this.configSite = factory.createConfigurationSiteModel((SiteModel)((Object)site), policy);
        String platformURLString = attributes.getValue("platformURL");
        this.configSite.setPlatformURLString(platformURLString);
        String enableString = attributes.getValue("enable");
        boolean enable = enableString == null || enableString.equalsIgnoreCase("true");
        this.configSite.setEnabled(enable);
        URL urlToCheck = new URL(this.configSite.getPlatformURLString());
        IPlatformConfiguration runtimeConfig = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISiteEntry entry = runtimeConfig.findConfiguredSite(urlToCheck);
        if (entry != null) {
            this.configSite.setUpdatable(entry.isUpdateable());
        } else {
            UpdateCore.warn("Unable to retrieve site:" + platformURLString + " from platform.");
        }
        String updatable = this.configSite.isUpdatable() ? "true" : "false";
        this.config.addConfigurationSiteModel(this.configSite);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End process config site url:" + urlString + " policy:" + policyString + " updatable:" + updatable);
        }
    }

    private void processFeature(Attributes attributes) throws MalformedURLException, CoreException {
        boolean configured;
        String path = attributes.getValue("url");
        URL url = UpdateManagerUtils.getURL(this.siteURL, path, null);
        String configuredString = attributes.getValue("configured");
        boolean bl = configured = configuredString.trim().equalsIgnoreCase("true");
        if (url != null) {
            SiteFeatureReference ref = new SiteFeatureReference();
            ref.setSite((ISite)((Object)this.configSite.getSiteModel()));
            ref.setURL(url);
            if (ref != null) {
                if (configured) {
                    this.configSite.getConfigurationPolicyModel().addConfiguredFeatureReference(ref);
                } else {
                    this.configSite.getConfigurationPolicyModel().addUnconfiguredFeatureReference(ref);
                }
            }
            String updateURLString = attributes.getValue("updateURL");
            URLEntry entry = new URLEntry();
            entry.setURLString(updateURLString);
            entry.resolve(this.siteURL, null);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                UpdateCore.debug("End Processing DefaultFeature Tag: url:" + url.toExternalForm());
            }
        } else {
            UpdateCore.log(Policy.bind("InstallConfigurationParser.FeatureReferenceNoURL"), new Exception());
        }
    }

    private void processActivity(Attributes attributes) {
        String actionString = attributes.getValue("action");
        int action = Integer.parseInt(actionString);
        ConfigurationActivityModel activity = new BaseSiteLocalFactory().createConfigurationActivityModel();
        activity.setAction(action);
        String label = attributes.getValue("label");
        if (label != null) {
            activity.setLabel(label);
        }
        String dateString = attributes.getValue("date");
        Date date = new Date(Long.parseLong(dateString));
        activity.setDate(date);
        String statusString = attributes.getValue("status");
        int status = Integer.parseInt(statusString);
        activity.setStatus(status);
        this.config.addActivityModel(activity);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Processing Activity: action:" + actionString + " label: " + label + " date:" + dateString + " status" + statusString);
        }
    }

    private void processConfig(Attributes attributes) {
        long date = Long.parseLong(attributes.getValue("date"));
        this.config.setCreationDate(new Date(date));
        String timelineString = attributes.getValue("timeline");
        long timeline = date;
        if (timelineString != null) {
            timeline = Long.parseLong(timelineString);
        }
        this.config.setTimeline(timeline);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Processing Config Tag: date:" + date + " timeline:" + timeline);
        }
    }
}

