/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.UpdateCore;

public class UpdateManagerReconciler
implements IPlatformRunnable {
    private String originalApplication = "org.eclipse.update.UNKNOWN";
    private boolean initialize = false;
    private boolean firstUse = false;
    private boolean optimistic = false;
    private boolean dumpfile = false;
    private boolean DEBUG = false;
    private String dumpFilename = "";
    private static final String RECONCILER_APP = "org.eclipse.update.core.reconciler";
    private static final String APPLICATION = "-application";
    private static final String INITIALIZE = "-initialize";
    private static final String DUMPFILE = "-dumpfile";
    private static final String FIRSTUSE = "-firstuse";
    private static final String CHANGES_MARKER = ".newupdates";

    public Object run(Object args) throws Exception {
        this.DEBUG = UpdateCore.DEBUG_SHOW_RECONCILER;
        this.processCommandLine((String[])args);
        IPlatformConfiguration cfg = BootLoader.getCurrentPlatformConfiguration();
        long start = 0L;
        if (this.DEBUG) {
            start = new Date().getTime();
            this.debug("begin");
        }
        this.optimistic = this.initialize || this.firstUse;
        boolean changes = this.reconcile(cfg);
        if (this.DEBUG) {
            long delta = new Date().getTime() - start;
            this.debug("end [" + delta + "ms]");
        }
        if (this.dumpfile) {
            this.dumpFeatures();
        }
        if (this.initialize) {
            Platform.endSplash();
            return IPlatformRunnable.EXIT_OK;
        }
        if (RECONCILER_APP.equals(this.originalApplication)) {
            Platform.endSplash();
            if (changes) {
                this.markChanges(cfg);
            }
            return IPlatformRunnable.EXIT_OK;
        }
        if (this.dumpfile) {
            Platform.endSplash();
            if (changes) {
                this.markChanges(cfg);
            }
            return IPlatformRunnable.EXIT_OK;
        }
        Platform.endSplash();
        if (changes) {
            this.markChanges(cfg);
        }
        if (this.DEBUG) {
            this.debug("restarting ..." + new Date());
        }
        return IPlatformRunnable.EXIT_RESTART;
    }

    /*
     * Exception decompiling
     */
    private void dumpFeatures() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [5 : 250->254)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean reconcile(IPlatformConfiguration cfg) {
        boolean changes = true;
        try {
            if (this.DEBUG) {
                this.debug("mode: " + (this.optimistic ? "optimistic" : "pessimistic"));
            }
            changes = InternalSiteManager.reconcile(this.optimistic);
            if (this.DEBUG) {
                this.debug(changes ? "changes detected" : "no changes detected");
            }
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
        }
        catch (Exception e) {
            UpdateCore.warn(null, e);
        }
        cfg.refresh();
        return changes;
    }

    private void markChanges(IPlatformConfiguration cfg) {
        block4: {
            FileOutputStream fos = null;
            try {
                URL markerLocation = new URL(cfg.getConfigurationLocation(), CHANGES_MARKER);
                fos = new FileOutputStream(new File(markerLocation.getFile()));
                fos.write(0);
                fos.close();
            }
            catch (IOException iOException) {
                if (fos == null) break block4;
                try {
                    fos.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    private String[] processCommandLine(String[] args) {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(INITIALIZE)) {
                this.initialize = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(FIRSTUSE)) {
                this.firstUse = true;
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(APPLICATION)) {
                    found = true;
                    this.originalApplication = arg;
                }
                if (args[i - 1].equalsIgnoreCase(DUMPFILE)) {
                    found = true;
                    this.dumpfile = true;
                    this.dumpFilename = arg;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    private void debug(String s) {
        UpdateCore.debug(String.valueOf(this.getClass().getName()) + ": " + s);
    }
}

