/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ConnectionThreadManager;
import org.eclipse.update.internal.core.FileResponse;
import org.eclipse.update.internal.core.HttpResponse;
import org.eclipse.update.internal.core.OtherResponse;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.UpdateManagerLogWriter;

public class UpdateCore
extends Plugin {
    public static boolean DEBUG = false;
    public static boolean DEBUG_SHOW_INSTALL = false;
    public static boolean DEBUG_SHOW_PARSING = false;
    public static boolean DEBUG_SHOW_WARNINGS = false;
    public static boolean DEBUG_SHOW_CONFIGURATION = false;
    public static boolean DEBUG_SHOW_TYPE = false;
    public static boolean DEBUG_SHOW_WEB = false;
    public static boolean DEBUG_SHOW_IHANDLER = false;
    public static boolean DEBUG_SHOW_RECONCILER = false;
    private static final String PREFIX = "org.eclipse.update.core";
    public static final String P_HISTORY_SIZE = "org.eclipse.update.core.historySize";
    public static final String P_CHECK_SIGNATURE = "org.eclipse.update.core.checkSignature";
    public static final String P_UPDATE_VERSIONS = "org.eclipse.update.core.updateVersions";
    public static final String EQUIVALENT_VALUE = "equivalent";
    public static final String COMPATIBLE_VALUE = "compatible";
    private static UpdateCore plugin;
    private static UpdateManagerLogWriter log;
    private static final String LOG_FILE = ".install-log";
    private ConnectionThreadManager connectionManager;
    public static String HTTP_PROXY_HOST;
    public static String HTTP_PROXY_PORT;
    public static String HTTP_PROXY_ENABLE;

    static {
        HTTP_PROXY_HOST = "org.eclipse.update.core.proxy.host";
        HTTP_PROXY_PORT = "org.eclipse.update.core.proxy.port";
        HTTP_PROXY_ENABLE = "org.eclipse.update.core.proxy.enable";
    }

    public UpdateCore(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static UpdateCore getPlugin() {
        return plugin;
    }

    public ConnectionThreadManager getConnectionManager() {
        if (this.connectionManager == null) {
            this.connectionManager = new ConnectionThreadManager();
        }
        return this.connectionManager;
    }

    public void startup() throws CoreException {
        super.startup();
        Policy.localize("org.eclipse.update.internal.core.messages");
        DEBUG = this.getBooleanDebugOption("org.eclipse.update.core/debug", false);
        if (DEBUG) {
            DEBUG_SHOW_WARNINGS = this.getBooleanDebugOption("org.eclipse.update.core/debug/warning", false);
            DEBUG_SHOW_PARSING = this.getBooleanDebugOption("org.eclipse.update.core/debug/parsing", false);
            DEBUG_SHOW_INSTALL = this.getBooleanDebugOption("org.eclipse.update.core/debug/install", false);
            DEBUG_SHOW_CONFIGURATION = this.getBooleanDebugOption("org.eclipse.update.core/debug/configuration", false);
            DEBUG_SHOW_TYPE = this.getBooleanDebugOption("org.eclipse.update.core/debug/type", false);
            DEBUG_SHOW_WEB = this.getBooleanDebugOption("org.eclipse.update.core/debug/web", false);
            DEBUG_SHOW_IHANDLER = this.getBooleanDebugOption("org.eclipse.update.core/debug/installhandler", false);
            DEBUG_SHOW_RECONCILER = this.getBooleanDebugOption("org.eclipse.update.core/debug/reconciler", false);
        }
        try {
            File logFile = UpdateCore.getUpdateStateLocation();
            if (logFile != null) {
                log = new UpdateManagerLogWriter(logFile);
            }
        }
        catch (IOException e) {
            UpdateCore.warn("", e);
        }
        SiteManager.setHttpProxyInfo(this.getPluginPreferences().getBoolean(HTTP_PROXY_ENABLE), this.getPluginPreferences().getString(HTTP_PROXY_HOST), this.getPluginPreferences().getString(HTTP_PROXY_PORT));
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        JarContentReference.shutdown();
        Utilities.shutdown();
        if (log != null) {
            log.shutdown();
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    private boolean getBooleanDebugOption(String flag, boolean dflt) {
        String result = Platform.getDebugOption((String)flag);
        if (result == null) {
            return dflt;
        }
        return result.trim().equalsIgnoreCase("true");
    }

    public static void debug(String s) {
        StringBuffer msg = new StringBuffer();
        msg.append(UpdateCore.getPlugin().toString());
        msg.append("^");
        msg.append(Integer.toHexString(Thread.currentThread().hashCode()));
        msg.append(" ");
        msg.append(s);
        System.out.println(msg.toString());
    }

    public static void warn(String s) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (s != null) {
                s = "WARNING: " + s;
            }
            UpdateCore.log(s, null);
        }
    }

    public static void warn(String s, Throwable e) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (s != null) {
                s = "UPDATE MANAGER INFO: " + s;
            }
            UpdateCore.log(s, e);
        }
    }

    public static void log(IStatus status) {
        UpdateCore.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        UpdateCore.log("", e);
    }

    public static void log(String msg, Throwable e) {
        IStatus status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : Utilities.newCoreException(msg, e).getStatus();
        if (status != null) {
            UpdateCore.log(status);
        }
    }

    public static void log(IInstallConfiguration newConfiguration) {
        if (log != null) {
            log.log(newConfiguration);
        }
    }

    private static File getUpdateStateLocation() throws IOException {
        IPlatformConfiguration config = BootLoader.getCurrentPlatformConfiguration();
        URL configurationLocation = config.getConfigurationLocation();
        if (configurationLocation == null) {
            UpdateCore.warn("Unable to retrieve location for update manager log file");
            return null;
        }
        URL configLocation = Platform.resolve((URL)configurationLocation);
        File updateStateLocation = null;
        if ("file".equalsIgnoreCase(configLocation.getProtocol())) {
            ArrayList<File> list = new ArrayList<File>();
            File path = new File(configLocation.getFile());
            updateStateLocation = new File(path.getParentFile(), LOG_FILE);
            while (path != null) {
                if (!path.exists()) {
                    list.add(path);
                    path = path.getParentFile();
                    continue;
                }
                path = null;
            }
            int i = list.size() - 1;
            while (i >= 0) {
                path = (File)list.get(i);
                path.mkdir();
                if (config.isTransient()) {
                    path.deleteOnExit();
                }
                --i;
            }
        }
        return updateStateLocation;
    }

    public Response get(URL url) throws IOException {
        Response response = null;
        response = "file".equals(url.getProtocol()) ? new FileResponse(url) : (url != null && url.getProtocol().startsWith("http") ? new HttpResponse(url) : new OtherResponse(url));
        return response;
    }

    public static boolean isPatch(IFeature candidate) {
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initializeDefaultPluginPreferences() {
        this.getPluginPreferences().setDefault(P_CHECK_SIGNATURE, true);
        this.getPluginPreferences().setDefault(P_HISTORY_SIZE, 50);
        this.getPluginPreferences().setDefault(P_UPDATE_VERSIONS, EQUIVALENT_VALUE);
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            String proxyPort = System.getProperty("http.proxyPort");
            if (proxyPort == null || proxyPort.trim().length() == 0) {
                proxyPort = "80";
            }
            this.getPluginPreferences().setDefault(HTTP_PROXY_ENABLE, true);
            this.getPluginPreferences().setDefault(HTTP_PROXY_HOST, proxyHost);
            this.getPluginPreferences().setDefault(HTTP_PROXY_PORT, proxyPort);
        }
    }
}

