/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ILocalSiteChangedListener;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.IWritable;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteReconciler;
import org.eclipse.update.internal.core.SiteStatusAnalyzer;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.eclipse.update.internal.model.SiteLocalModel;
import org.eclipse.update.internal.model.SiteLocalParser;
import org.xml.sax.SAXException;

public class SiteLocal
extends SiteLocalModel
implements ILocalSite,
IWritable {
    private ListenersList listeners = new ListenersList();
    private SiteReconciler reconciler;
    private SiteStatusAnalyzer siteStatusAnalyzer;
    private boolean isTransient = false;
    private static final String UPDATE_STATE_SUFFIX = ".metadata";
    public static boolean newFeaturesFound = false;

    public static ILocalSite getLocalSite() throws CoreException {
        return SiteLocal.internalGetLocalSite(false);
    }

    public static ILocalSite internalGetLocalSite(boolean isOptimistic) throws CoreException {
        SiteLocal localSite = new SiteLocal();
        IPlatformConfiguration currentPlatformConfiguration = BootLoader.getCurrentPlatformConfiguration();
        localSite.isTransient(currentPlatformConfiguration.isTransient());
        try {
            URL location;
            try {
                location = SiteLocal.getUpdateStateLocation(currentPlatformConfiguration);
            }
            catch (IOException exception) {
                throw Utilities.newCoreException(Policy.bind(Policy.bind("SiteLocal.UnableToRetrieveRWArea")), exception);
            }
            URL configXML = UpdateManagerUtils.getURL(location, "v2LocalSite.xml", null);
            localSite.setLocationURLString(configXML.toExternalForm());
            localSite.resolve(configXML, null);
            boolean hasRecoveredState = SiteLocal.parseLocalSiteFile(localSite, configXML);
            if (hasRecoveredState) {
                long bootStamp = currentPlatformConfiguration.getChangeStamp();
                if (localSite.getStamp() != bootStamp) {
                    UpdateCore.warn("Reconcile platform stamp:" + bootStamp + " is different from LocalSite stamp:" + localSite.getStamp());
                    newFeaturesFound = localSite.reconcile(isOptimistic);
                } else {
                    localSite.preserveRuntimePluginPath();
                }
            } else {
                newFeaturesFound = localSite.reconcile(true);
            }
        }
        catch (MalformedURLException exception) {
            throw Utilities.newCoreException(Policy.bind("SiteLocal.UnableToCreateURLFor", String.valueOf(localSite.getLocationURLString()) + " & " + "v2LocalSite.xml"), exception);
        }
        return localSite;
    }

    private static boolean parseLocalSiteFile(SiteLocal localSite, URL configXML) throws CoreException, MalformedURLException {
        URL resolvedURL = URLEncoder.encode(configXML);
        try {
            InputStream in = UpdateCore.getPlugin().get(resolvedURL).getInputStream();
            new SiteLocalParser(in, localSite);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UpdateCore.warn(String.valueOf(localSite.getLocationURLString()) + " does not exist, there is no previous state or install history we can recover from, we shall use default from platform configuration.", null);
            return false;
        }
        catch (SAXException exception) {
            UpdateCore.warn(Policy.bind("SiteLocal.ErrorParsingSavedState", localSite.getLocationURLString()), exception);
            SiteLocal.recoverSiteLocal(resolvedURL, localSite);
            return false;
        }
        catch (IOException exception) {
            UpdateCore.warn(Policy.bind("SiteLocal.UnableToAccessFile", configXML.toExternalForm()), exception);
            SiteLocal.recoverSiteLocal(resolvedURL, localSite);
            return false;
        }
        return true;
    }

    private SiteLocal() {
    }

    public void addConfiguration(IInstallConfiguration config) {
        if (config != null) {
            this.addConfigurationModel((InstallConfigurationModel)((Object)config));
            this.trimHistoryToCapacity();
            if (this.getCurrentConfigurationModel() != null) {
                this.getCurrentConfigurationModel().setCurrent(false);
            }
            if (config instanceof InstallConfiguration) {
                ((InstallConfiguration)config).setCurrent(true);
            }
            this.setCurrentConfigurationModel((InstallConfigurationModel)((Object)config));
            ((InstallConfigurationModel)((Object)config)).markReadOnly();
            Object[] siteLocalListeners = this.listeners.getListeners();
            int i = 0;
            while (i < siteLocalListeners.length) {
                ((ILocalSiteChangedListener)siteLocalListeners[i]).currentInstallConfigurationChanged(config);
                ++i;
            }
        }
    }

    private void trimHistoryToCapacity() {
        while (this.getConfigurationHistory().length > this.getMaximumHistoryCount()) {
            InstallConfigurationModel removedConfig = this.getConfigurationHistoryModel()[0];
            if (!this.removeConfigurationModel(removedConfig)) continue;
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Removed configuration :" + removedConfig.getLabel());
            }
            Object[] siteLocalListeners = this.listeners.getListeners();
            int i = 0;
            while (i < siteLocalListeners.length) {
                ((ILocalSiteChangedListener)siteLocalListeners[i]).installConfigurationRemoved((IInstallConfiguration)((Object)removedConfig));
                ++i;
            }
            URL url = removedConfig.getURL();
            UpdateManagerUtils.removeFromFileSystem(new File(url.getFile()));
        }
    }

    public void addLocalSiteChangedListener(ILocalSiteChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    public void removeLocalSiteChangedListener(ILocalSiteChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    public void save() throws CoreException {
        ((InstallConfiguration)this.getCurrentConfiguration()).save(this.isTransient());
        if ("file".equalsIgnoreCase(this.getLocationURL().getProtocol())) {
            File file = null;
            try {
                URL newURL = UpdateManagerUtils.getURL(this.getLocationURL(), "v2LocalSite.xml", null);
                file = new File(newURL.getFile());
                if (this.isTransient()) {
                    file.deleteOnExit();
                }
                UpdateManagerUtils.Writer writer = UpdateManagerUtils.getWriter(file, "UTF-8");
                writer.write(this);
            }
            catch (FileNotFoundException e) {
                throw Utilities.newCoreException(Policy.bind("SiteLocal.UnableToSaveStateIn", file.getAbsolutePath()), e);
            }
            catch (UnsupportedEncodingException e) {
                throw Utilities.newCoreException(Policy.bind("SiteLocal.UnableToEncodeConfiguration", file.getAbsolutePath()), e);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(String.valueOf(Policy.bind("SiteLocal.UnableToCreateURLFor")) + this.getLocationURL().toExternalForm() + " : " + "v2LocalSite.xml", e);
            }
        }
    }

    public void write(int indent, PrintWriter w) {
        IPlatformConfiguration platformConfig = BootLoader.getCurrentPlatformConfiguration();
        platformConfig.refresh();
        long changeStamp = platformConfig.getChangeStamp();
        this.setStamp(changeStamp);
        String gap = "";
        int i = 0;
        while (i < indent) {
            gap = String.valueOf(gap) + " ";
            ++i;
        }
        String increment = "";
        int i2 = 0;
        while (i2 < 3) {
            increment = String.valueOf(increment) + " ";
            ++i2;
        }
        w.print(String.valueOf(gap) + "<" + "localsite" + " ");
        if (this.getLabel() != null) {
            w.print(String.valueOf(gap) + "label=\"" + UpdateManagerUtils.Writer.xmlSafe(this.getLabel()) + "\" ");
        }
        w.print(String.valueOf(gap) + "history=\"" + this.getMaximumHistoryCount() + "\" ");
        w.print(String.valueOf(gap) + "stamp=\"" + changeStamp + "\" >");
        w.println("");
        InstallConfigurationModel[] configurations = this.getConfigurationHistoryModel();
        int index = 0;
        while (index < configurations.length) {
            InstallConfigurationModel element = configurations[index];
            if (!element.isCurrent()) {
                this.writeConfig(String.valueOf(gap) + increment, w, element);
            }
            ++index;
        }
        this.writeConfig(String.valueOf(gap) + increment, w, (InstallConfigurationModel)((Object)this.getCurrentConfiguration()));
        w.println("");
        if (this.getPreservedConfigurations() != null && this.getPreservedConfigurations().length != 0) {
            w.println(String.valueOf(gap) + increment + "<" + "preservedConfigurations" + ">");
            InstallConfigurationModel[] preservedConfig = this.getPreservedConfigurationsModel();
            int index2 = 0;
            while (index2 < preservedConfig.length) {
                InstallConfigurationModel element = preservedConfig[index2];
                this.writeConfig(String.valueOf(gap) + increment + increment, w, element);
                ++index2;
            }
            w.println(String.valueOf(gap) + increment + "</" + "preservedConfigurations" + ">");
        }
        w.println(String.valueOf(gap) + "</" + "localsite" + ">");
        UpdateCore.warn("Saved change stamp:" + changeStamp);
    }

    private void writeConfig(String gap, PrintWriter w, InstallConfigurationModel config) {
        w.print(String.valueOf(gap) + "<" + "config" + " ");
        URL locationAsDirectory = UpdateManagerUtils.getParent(this.getLocationURL());
        String URLInfoString = UpdateManagerUtils.getURLAsString(locationAsDirectory, config.getURL());
        w.print("url=\"" + UpdateManagerUtils.Writer.xmlSafe(URLInfoString) + "\" ");
        if (config.getLabel() != null) {
            w.print("label=\"" + UpdateManagerUtils.Writer.xmlSafe(config.getLabel()) + "\"");
        }
        w.println("/>");
    }

    public IInstallConfiguration createNewInstallConfiguration() throws CoreException {
        InstallConfiguration newInstallConfig = this.createConfigurationSite(null);
        newInstallConfig.setTimeline(newInstallConfig.getCreationDate().getTime());
        return newInstallConfig;
    }

    private InstallConfiguration createConfigurationSite(IInstallConfiguration installConfig) throws CoreException {
        if (this.getCurrentConfiguration() != null) {
            ((InstallConfiguration)this.getCurrentConfiguration()).saveConfigurationFile(this.isTransient());
        }
        InstallConfiguration result = null;
        Date currentDate = new Date();
        String newFileName = UpdateManagerUtils.getLocalRandomIdentifier("v2Config.xml", currentDate);
        try {
            URL newFile = UpdateManagerUtils.getURL(this.getLocationURL(), newFileName, null);
            String name = Utilities.format(currentDate);
            result = new InstallConfiguration(installConfig, newFile, name);
            result.setCreationDate(currentDate);
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(String.valueOf(Policy.bind("SiteLocal.UnableToCreateURLFor")) + newFileName, e);
        }
        return result;
    }

    public IInstallConfiguration cloneCurrentConfiguration() throws CoreException {
        IInstallConfiguration currentConfiguration = this.getCurrentConfiguration();
        InstallConfiguration clonedConfiguration = this.createConfigurationSite(currentConfiguration);
        clonedConfiguration.setTimeline(currentConfiguration.getTimeline());
        return clonedConfiguration;
    }

    /*
     * Exception decompiling
     */
    public void revertTo(IInstallConfiguration configuration, IProgressMonitor monitor, IProblemHandler handler) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 124->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IInstallConfiguration addToPreservedConfigurations(IInstallConfiguration configuration) throws CoreException {
        InstallConfiguration newConfiguration = null;
        if (configuration != null) {
            String newFileName = UpdateManagerUtils.getLocalRandomIdentifier("v2PreservedConfig.xml", new Date());
            try {
                URL newFile = UpdateManagerUtils.getURL(this.getLocationURL(), newFileName, null);
                Date currentDate = configuration.getCreationDate();
                String name = configuration.getLabel();
                newConfiguration = new InstallConfiguration(configuration, newFile, name);
                newConfiguration.setCreationDate(currentDate);
                newConfiguration.setTimeline(configuration.getTimeline());
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(String.valueOf(Policy.bind("SiteLocal.UnableToCreateURLFor")) + newFileName, e);
            }
            ConfigurationActivity activity = new ConfigurationActivity(9);
            activity.setLabel(configuration.getLabel());
            activity.setDate(new Date());
            activity.setStatus(0);
            newConfiguration.addActivity(activity);
            newConfiguration.saveConfigurationFile(this.isTransient());
            this.addPreservedInstallConfigurationModel(newConfiguration);
        }
        return newConfiguration;
    }

    public IInstallConfiguration findPreservedConfigurationFor(IInstallConfiguration configuration) {
        InstallConfigurationModel[] preservedConfigurations;
        InstallConfigurationModel preservedConfig = null;
        if (configuration != null && (preservedConfigurations = this.getPreservedConfigurationsModel()) != null) {
            int indexPreserved = 0;
            while (indexPreserved < preservedConfigurations.length) {
                if (configuration.getCreationDate().equals(preservedConfigurations[indexPreserved].getCreationDate())) {
                    preservedConfig = preservedConfigurations[indexPreserved];
                    break;
                }
                ++indexPreserved;
            }
        }
        return (IInstallConfiguration)((Object)preservedConfig);
    }

    public IInstallConfiguration getCurrentConfiguration() {
        if (this.getCurrentConfigurationModel() == null) {
            int index = 0;
            index = this.getConfigurationHistoryModel().length;
            if (index == 0) {
                return null;
            }
            InstallConfigurationModel config = this.getConfigurationHistoryModel()[index - 1];
            config.setCurrent(true);
            this.setCurrentConfigurationModel(config);
        }
        return (IInstallConfiguration)((Object)this.getCurrentConfigurationModel());
    }

    public IInstallConfiguration[] getPreservedConfigurations() {
        if (this.getPreservedConfigurationsModel().length == 0) {
            return new IInstallConfiguration[0];
        }
        return (IInstallConfiguration[])this.getPreservedConfigurationsModel();
    }

    public void removeFromPreservedConfigurations(IInstallConfiguration configuration) {
        if (this.removePreservedConfigurationModel((InstallConfigurationModel)((Object)configuration))) {
            ((InstallConfiguration)configuration).remove();
        }
    }

    private void preserveRuntimePluginPath() throws CoreException {
        IPlatformConfiguration platformConfig = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISiteEntry[] siteEntries = platformConfig.getConfiguredSites();
        IConfiguredSite[] configured = new IConfiguredSite[]{};
        if (this.getCurrentConfiguration() != null) {
            configured = this.getCurrentConfiguration().getConfiguredSites();
        }
        int siteIndex = 0;
        while (siteIndex < siteEntries.length) {
            URL resolvedURL = this.getReconciler().resolveSiteEntry(siteEntries[siteIndex]);
            boolean found = false;
            int index = 0;
            while (index < configured.length && !found) {
                if (configured[index] != null && UpdateManagerUtils.sameURL(configured[index].getSite().getURL(), resolvedURL)) {
                    found = true;
                    String[] listOfPlugins = siteEntries[siteIndex].getSitePolicy().getList();
                    ((ConfiguredSite)configured[index]).setPreviousPluginPath(listOfPlugins);
                    configured[index] = null;
                }
                ++index;
            }
            ++siteIndex;
        }
    }

    public IInstallConfiguration[] getConfigurationHistory() {
        if (this.getConfigurationHistoryModel().length == 0) {
            return new IInstallConfiguration[0];
        }
        return (IInstallConfiguration[])this.getConfigurationHistoryModel();
    }

    public boolean reconcile(boolean isOptimistic) throws CoreException {
        return this.getReconciler().reconcile(isOptimistic);
    }

    private SiteReconciler getReconciler() {
        if (this.reconciler == null) {
            this.reconciler = new SiteReconciler(this);
        }
        return this.reconciler;
    }

    private static URL getUpdateStateLocation(IPlatformConfiguration config) throws IOException {
        URL configLocation = Platform.resolve((URL)config.getConfigurationLocation());
        String temp = configLocation.toExternalForm();
        URL updateLocation = new URL(temp = String.valueOf(temp) + ".metadata/");
        if ("file".equalsIgnoreCase(updateLocation.getProtocol())) {
            ArrayList<File> list = new ArrayList<File>();
            File path = new File(updateLocation.getFile());
            while (path != null) {
                if (!path.exists()) {
                    list.add(path);
                    path = path.getParentFile();
                    continue;
                }
                path = null;
            }
            int i = list.size() - 1;
            while (i >= 0) {
                path = (File)list.get(i);
                path.mkdir();
                if (config.isTransient()) {
                    path.deleteOnExit();
                }
                --i;
            }
        }
        return updateLocation;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    private void isTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    private static void recoverSiteLocal(URL url, SiteLocal site) throws CoreException, MalformedURLException {
        String relativeURL;
        InstallConfigurationModel config;
        URL configURL;
        File[] preservedFiles;
        File dir;
        File[] configFiles;
        if (url == null) {
            throw Utilities.newCoreException(Policy.bind("SiteLocal.SiteUrlIsNull"), null);
        }
        site.setLabel(url.toExternalForm());
        long stamp = 0L;
        site.setStamp(stamp);
        File localXml = new File(url.getFile());
        if (localXml.exists()) {
            try {
                UpdateManagerUtils.removeFromFileSystem(localXml);
                UpdateCore.warn("Removed bad LocalSite.xml file:" + localXml);
            }
            catch (Exception e) {
                UpdateCore.warn("Unable to remove bad LocalSite.xml file:" + localXml, e);
            }
        }
        if ((configFiles = (dir = localXml.getParentFile()).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("v2Config") && name.endsWith("xml");
            }
        })) == null) {
            configFiles = new File[]{};
        }
        if ((preservedFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("v2PreservedConfig") && name.endsWith("xml");
            }
        })) == null) {
            preservedFiles = new File[]{};
        }
        int history = 0;
        if (configFiles.length > 0) {
            history = configFiles.length;
        }
        if (SiteLocalModel.DEFAULT_HISTORY > history) {
            history = SiteLocalModel.DEFAULT_HISTORY;
        }
        site.setMaximumHistoryCount(history);
        ArrayList<InstallConfigurationModel> validConfig = new ArrayList<InstallConfigurationModel>();
        int i = 0;
        while (i < configFiles.length) {
            configURL = configFiles[i].toURL();
            config = new BaseSiteLocalFactory().createInstallConfigurationModel();
            relativeURL = UpdateManagerUtils.getURLAsString(url, configURL);
            config.setLocationURLString(relativeURL);
            config.resolve(configURL, url);
            config.setLabel(Utilities.format(config.getCreationDate()));
            validConfig.add(config);
            ++i;
        }
        if (validConfig.size() > 0) {
            Iterator iter = validConfig.iterator();
            InstallConfigurationModel currentConfig = (InstallConfigurationModel)((Object)iter.next());
            while (iter.hasNext()) {
                InstallConfigurationModel element = (InstallConfigurationModel)((Object)iter.next());
                Date currentConfigDate = currentConfig.getCreationDate();
                Date elementDate = element.getCreationDate();
                if (elementDate != null && elementDate.after(currentConfigDate)) {
                    site.addConfigurationModel(currentConfig);
                    currentConfig = element;
                    continue;
                }
                site.addConfigurationModel(element);
            }
            site.addConfigurationModel(currentConfig);
        }
        i = 0;
        while (i < preservedFiles.length) {
            configURL = preservedFiles[i].toURL();
            config = new BaseSiteLocalFactory().createInstallConfigurationModel();
            relativeURL = UpdateManagerUtils.getURLAsString(url, configURL);
            config.setLocationURLString(relativeURL);
            config.resolve(configURL, url);
            config.setLabel(Utilities.format(config.getCreationDate()));
            site.addPreservedInstallConfigurationModel(config);
            ++i;
        }
    }

    private SiteStatusAnalyzer getSiteStatusAnalyzer() {
        if (this.siteStatusAnalyzer == null) {
            this.siteStatusAnalyzer = new SiteStatusAnalyzer(this);
        }
        return this.siteStatusAnalyzer;
    }

    public IStatus getFeatureStatus(IFeature feature) throws CoreException {
        return this.getSiteStatusAnalyzer().getFeatureStatus(feature);
    }

    public void setMaximumHistoryCount(int history) {
        super.setMaximumHistoryCount(history);
        this.trimHistoryToCapacity();
    }
}

