/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteContentConsumer;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileFactory;
import org.eclipse.update.internal.core.SiteFileNonPluginContentConsumer;
import org.eclipse.update.internal.core.SiteFilePluginContentConsumer;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFileContentConsumer
extends SiteContentConsumer {
    private IFeature feature;
    private boolean closed = false;
    private String oldPath;
    private String newPath;
    private List contentConsumers;
    private List installedFiles;
    private SiteFileFactory archiveFactory = new SiteFileFactory();

    public SiteFileContentConsumer(IFeature feature) {
        this.feature = feature;
        this.installedFiles = new ArrayList();
    }

    private String getFeaturePath() throws CoreException {
        String featurePath = null;
        try {
            VersionedIdentifier featureIdentifier = this.feature.getVersionedIdentifier();
            String path = "features/" + featureIdentifier.toString() + File.separator;
            URL newURL = new URL(this.getSite().getURL(), path);
            featurePath = newURL.getFile();
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(String.valueOf(Policy.bind("SiteFileContentConsumer.UnableToCreateURL")) + e.getMessage(), e);
        }
        return featurePath;
    }

    public IContentConsumer open(INonPluginEntry nonPluginEntry) throws CoreException {
        return new SiteFileNonPluginContentConsumer(this.getFeaturePath());
    }

    public IContentConsumer open(IPluginEntry pluginEntry) throws CoreException {
        SiteFilePluginContentConsumer cons = new SiteFilePluginContentConsumer(pluginEntry, this.getSite());
        this.addContentConsumers(cons);
        return cons;
    }

    /*
     * Exception decompiling
     */
    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 226->230)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IFeatureReference close() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFileContentConsumer", new Exception());
        }
        SiteFeatureReference ref = new SiteFeatureReference();
        ref.setSite(this.getSite());
        File file = null;
        try {
            file = new File(this.getFeaturePath());
            ref.setURL(file.toURL());
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Policy.bind("SiteFileContentConsumer.UnableToCreateURLForFile", file.getAbsolutePath()), e);
        }
        if (this.newPath != null) {
            ErrorRecoveryLog.getLog().appendPath("RENAME", this.newPath);
            boolean sucess = false;
            File fileToRename = new File(this.newPath);
            if (fileToRename.exists()) {
                File renamedFile = new File(this.oldPath);
                if (renamedFile.exists()) {
                    UpdateManagerUtils.removeFromFileSystem(renamedFile);
                    UpdateCore.warn("Removing already existing file:" + this.oldPath);
                }
                sucess = fileToRename.renameTo(renamedFile);
            }
            if (!sucess) {
                String msg = Policy.bind("ContentConsumer.UnableToRename", this.newPath, this.oldPath);
                throw Utilities.newCoreException(msg, new Exception(msg));
            }
        }
        if (this.contentConsumers != null) {
            Iterator iter = this.contentConsumers.iterator();
            while (iter.hasNext()) {
                ContentConsumer element = (ContentConsumer)iter.next();
                element.close();
            }
        }
        this.contentConsumers = null;
        if (ref != null) {
            this.commitPlugins(ref);
            ref.markReadOnly();
        }
        this.closed = true;
        return ref;
    }

    public void abort() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to abort a closed SiteFileContentConsumer", new Exception());
            return;
        }
        if (this.contentConsumers != null) {
            Iterator iter = this.contentConsumers.iterator();
            while (iter.hasNext()) {
                SiteFilePluginContentConsumer element = (SiteFilePluginContentConsumer)iter.next();
                element.abort();
            }
        }
        this.contentConsumers = null;
        boolean sucess = true;
        if (this.oldPath != null) {
            ErrorRecoveryLog.getLog().appendPath("DELETE", this.oldPath);
            File fileToDelete = new File(this.oldPath);
            if (fileToDelete.exists()) {
                sucess = fileToDelete.delete();
            }
        }
        if (!sucess) {
            String msg = Policy.bind("Unable to delete", this.oldPath);
            UpdateCore.log(msg, null);
        } else {
            Iterator iter = this.installedFiles.iterator();
            File featureFile = null;
            while (iter.hasNext()) {
                String path = (String)iter.next();
                featureFile = new File(path);
                UpdateManagerUtils.removeFromFileSystem(featureFile);
            }
            String featurePath = this.getFeaturePath();
            UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(featurePath));
        }
        this.closed = true;
    }

    private void commitPlugins(IFeatureReference localFeatureReference) throws CoreException {
        ((SiteFile)this.getSite()).addFeatureReferenceModel((SiteFeatureReferenceModel)localFeatureReference);
        IFeature localFeature = null;
        try {
            localFeature = localFeatureReference.getFeature(null);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return;
        }
        if (localFeature == null) {
            return;
        }
        ArchiveReferenceModel archive = null;
        IPluginEntry[] pluginEntries = localFeature.getPluginEntries();
        int i = 0;
        while (i < pluginEntries.length) {
            String versionId = pluginEntries[i].getVersionedIdentifier().toString();
            String pluginID = "plugins/" + versionId + ".jar";
            archive = this.archiveFactory.createArchiveReferenceModel();
            archive.setPath(pluginID);
            try {
                URL url = new URL(this.getSite().getURL(), "plugins/" + versionId + File.separator);
                archive.setURLString(url.toExternalForm());
                archive.resolve(url, null);
                ((SiteFile)this.getSite()).addArchiveReferenceModel(archive);
            }
            catch (MalformedURLException e) {
                String urlString = this.getSite().getURL() != null ? this.getSite().getURL().toExternalForm() : "";
                urlString = String.valueOf(urlString) + "plugins/" + pluginEntries[i].toString();
                throw Utilities.newCoreException(Policy.bind("SiteFile.UnableToCreateURL", urlString), e);
            }
            ++i;
        }
    }

    private void addContentConsumers(ContentConsumer cons) {
        if (this.contentConsumers == null) {
            this.contentConsumers = new ArrayList();
        }
        this.contentConsumers.add(cons);
    }
}

