/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.ISiteContentConsumer;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.UpdateUtils;

public class DeltaInstallHandler
extends BaseInstallHandler {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    protected IFeature oldFeature;
    protected ISiteContentConsumer contentConsumer;

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.pluginEntries == null) {
            return;
        }
        IFeature[] oldFeatures = UpdateUtils.getInstalledFeatures(this.feature);
        if (oldFeatures.length == 0) {
            return;
        }
        this.oldFeature = oldFeatures[0];
        IPluginEntry[] oldPlugins = this.oldFeature.getPluginEntries();
        int i = 0;
        while (i < this.pluginEntries.length) {
            IPluginEntry newPlugin = this.pluginEntries[i];
            IPluginEntry oldPlugin = this.getPluginEntry(oldPlugins, newPlugin.getVersionedIdentifier().getIdentifier());
            if (oldPlugin != null) {
                try {
                    this.overlayPlugin(oldPlugin, newPlugin);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, UpdateUtils.getPluginId(), 1, "", (Throwable)e));
                }
            }
            ++i;
        }
    }

    protected IPluginEntry getPluginEntry(IPluginEntry[] plugins, String id) {
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].getVersionedIdentifier().getIdentifier().equals(id)) {
                return plugins[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean referenceExists(ContentReference[] references, ContentReference ref) {
        String id = ref.getIdentifier();
        if (id == null) {
            return false;
        }
        int i = 0;
        while (i < references.length) {
            if (id.equals(references[i].getIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void overlayPlugin(IPluginEntry oldPlugin, IPluginEntry newPlugin) throws CoreException, IOException {
        ContentReference[] oldReferences = this.oldFeature.getFeatureContentProvider().getPluginEntryContentReferences(oldPlugin, null);
        ContentReference[] newReferences = this.feature.getFeatureContentProvider().getPluginEntryContentReferences(newPlugin, null);
        URL newURL = new URL(this.oldFeature.getSite().getURL(), "plugins/" + newPlugin.getVersionedIdentifier().toString());
        String pluginPath = newURL.getFile();
        int i = 0;
        while (i < oldReferences.length) {
            if (!this.isPluginXml(oldReferences[i]) && !this.referenceExists(newReferences, oldReferences[i])) {
                try {
                    File sourceFile = oldReferences[i].asFile();
                    File targetFile = new File(pluginPath, oldReferences[i].getIdentifier());
                    FileInputStream input = new FileInputStream(sourceFile);
                    UpdateManagerUtils.copyToLocal(input, targetFile.getAbsolutePath(), null);
                    UpdateManagerUtils.checkPermissions(oldReferences[i], pluginPath);
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }

    protected boolean isPluginXml(ContentReference ref) {
        String id = ref.getIdentifier();
        return PLUGIN_XML.equals(id) || FRAGMENT_XML.equals(id);
    }
}

