/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.api.search;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.internal.api.search.IUpdateSearchCategory;
import org.eclipse.update.internal.api.search.IUpdateSearchFilter;
import org.eclipse.update.internal.api.search.IUpdateSearchQuery;
import org.eclipse.update.internal.api.search.IUpdateSearchResultCollector;
import org.eclipse.update.internal.api.search.IUpdateSearchSite;
import org.eclipse.update.internal.api.search.IUpdateSiteAdapter;
import org.eclipse.update.internal.api.search.UpdateSearchScope;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.UpdatePolicy;

public class UpdateSearchRequest {
    private IUpdateSearchCategory category;
    private UpdateSearchScope scope;
    private boolean searchInProgress = false;
    private AggregateFilter aggregateFilter = new AggregateFilter();

    public UpdateSearchRequest(IUpdateSearchCategory category, UpdateSearchScope scope) {
        this.category = category;
        this.scope = scope;
    }

    public IUpdateSearchCategory getCategory() {
        return this.category;
    }

    public UpdateSearchScope getScope() {
        return this.scope;
    }

    public void addFilter(IUpdateSearchFilter filter) {
        if (this.searchInProgress) {
            return;
        }
        this.aggregateFilter.addFilter(filter);
    }

    public void removeFilter(IUpdateSearchFilter filter) {
        if (this.searchInProgress) {
            return;
        }
        this.aggregateFilter.removeFilter(filter);
    }

    public void setScope(UpdateSearchScope scope) {
        this.scope = scope;
    }

    public boolean isSearchInProgress() {
        return this.searchInProgress;
    }

    public void performSearch(IUpdateSearchResultCollector collector, IProgressMonitor monitor) throws CoreException {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        this.searchInProgress = true;
        IUpdateSearchQuery[] queries = this.category.getQueries();
        IUpdateSearchSite[] candidates = this.scope.getSearchSites();
        URL updateMapURL = this.scope.getUpdateMapURL();
        if (!monitor.isCanceled()) {
            int nsearchsites = 0;
            int i = 0;
            while (i < queries.length) {
                if (queries[i].getQuerySearchSite() != null) {
                    ++nsearchsites;
                }
                ++i;
            }
            int ntasks = nsearchsites + queries.length * candidates.length;
            if (updateMapURL != null) {
                ++ntasks;
            }
            monitor.beginTask("Searching...", ntasks);
            try {
                IStatus status;
                UpdatePolicy updatePolicy = null;
                if (updateMapURL != null && (status = this.loadUpdatePolicy(updatePolicy = new UpdatePolicy(), updateMapURL, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    statusList.add(status);
                }
                int i2 = 0;
                while (i2 < queries.length) {
                    IUpdateSearchQuery query = queries[i2];
                    IQueryUpdateSiteAdapter qsite = query.getQuerySearchSite();
                    if (qsite != null) {
                        IUpdateSiteAdapter mappedSite = this.getMappedSite(updatePolicy, qsite);
                        if (mappedSite != null && mappedSite.getURL() != null) {
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                            IStatus status2 = this.searchOneSite(mappedSite, null, query, collector, subMonitor);
                            if (status2 != null) {
                                statusList.add(status2);
                            }
                            if (monitor.isCanceled()) break;
                        }
                    } else {
                        int j = 0;
                        while (j < candidates.length) {
                            if (monitor.isCanceled()) break;
                            IUpdateSearchSite source = candidates[j];
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                            IStatus status3 = this.searchOneSite(source, source.getCategoriesToSkip(), query, collector, subMonitor);
                            if (status3 != null) {
                                statusList.add(status3);
                            }
                            ++j;
                        }
                        if (monitor.isCanceled()) break;
                    }
                    ++i2;
                }
            }
            catch (CoreException e) {
                this.searchInProgress = false;
                monitor.done();
                throw e;
            }
        }
        this.searchInProgress = false;
        monitor.done();
        if (statusList.size() > 0) {
            IStatus[] children = statusList.toArray(new IStatus[statusList.size()]);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.update.core", 42, children, UpdateUtils.getString("Search.networkProblems"), null);
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private IStatus loadUpdatePolicy(UpdatePolicy map, URL url, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Loading update policy ...");
        try {
            map.load(url, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status == null || status.getCode() != 42) {
                throw e;
            }
            monitor.worked(1);
            return status;
        }
        return null;
    }

    private IUpdateSiteAdapter getMappedSite(UpdatePolicy policy, IQueryUpdateSiteAdapter qsite) {
        if (policy != null && policy.isLoaded()) {
            IUpdateSiteAdapter mappedSite = policy.getMappedSite(qsite.getMappingId());
            if (mappedSite != null) {
                return mappedSite;
            }
            return policy.isFallbackAllowed() ? qsite : null;
        }
        return qsite;
    }

    private IStatus searchOneSite(IUpdateSiteAdapter siteAdapter, String[] categoriesToSkip, IUpdateSearchQuery query, IUpdateSearchResultCollector collector, SubProgressMonitor monitor) throws CoreException {
        ISite site;
        String text = "Contacting " + siteAdapter.getLabel() + "...";
        monitor.subTask(text);
        monitor.beginTask("", 10);
        URL siteURL = siteAdapter.getURL();
        try {
            site = SiteManager.getSite(siteURL, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status == null || status.getCode() != 42) {
                throw e;
            }
            monitor.worked(10);
            return status;
        }
        if (site == null) {
            monitor.worked(9);
            return null;
        }
        text = "Checking " + siteAdapter.getLabel() + "...";
        monitor.getWrappedProgressMonitor().subTask(text);
        query.run(site, categoriesToSkip, this.aggregateFilter, collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 9));
        return null;
    }

    class AggregateFilter
    implements IUpdateSearchFilter {
        private ArrayList filters;

        AggregateFilter() {
        }

        public void addFilter(IUpdateSearchFilter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            if (!this.filters.contains(filter)) {
                this.filters.add(filter);
            }
        }

        public void removeFilter(IUpdateSearchFilter filter) {
            if (this.filters == null) {
                return;
            }
            this.filters.remove(filter);
        }

        public boolean accept(IFeature match) {
            if (this.filters == null) {
                return true;
            }
            int i = 0;
            while (i < this.filters.size()) {
                IUpdateSearchFilter filter = (IUpdateSearchFilter)this.filters.get(i);
                if (!filter.accept(match)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean accept(IFeatureReference match) {
            if (this.filters == null) {
                return true;
            }
            int i = 0;
            while (i < this.filters.size()) {
                IUpdateSearchFilter filter = (IUpdateSearchFilter)this.filters.get(i);
                if (!filter.accept(match)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

