/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;

public class SiteModel
extends ModelObject {
    private String type;
    private URLEntryModel description;
    private List featureReferences;
    private List archiveReferences;
    private Set categories;
    private String locationURLString;
    private URL locationURL;
    private ConfiguredSiteModel configuredSiteModel;

    public String getType() {
        return this.type;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public SiteFeatureReferenceModel[] getFeatureReferenceModels() {
        if (this.featureReferences == null) {
            return new SiteFeatureReferenceModel[0];
        }
        return (SiteFeatureReferenceModel[])this.featureReferences.toArray(this.arrayTypeFor(this.featureReferences));
    }

    public ArchiveReferenceModel[] getArchiveReferenceModels() {
        if (this.archiveReferences == null) {
            return new ArchiveReferenceModel[0];
        }
        return (ArchiveReferenceModel[])this.archiveReferences.toArray(this.arrayTypeFor(this.archiveReferences));
    }

    public CategoryModel[] getCategoryModels() {
        if (this.categories == null) {
            return new CategoryModel[0];
        }
        return (CategoryModel[])this.categories.toArray(this.arrayTypeFor(this.categories));
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public URL getLocationURL() {
        return this.locationURL;
    }

    public void setType(String type) {
        this.assertIsWriteable();
        this.type = type;
    }

    public void setDescriptionModel(URLEntryModel description) {
        this.assertIsWriteable();
        this.description = description;
    }

    public void setFeatureReferenceModels(FeatureReferenceModel[] featureReferences) {
        this.assertIsWriteable();
        this.featureReferences = featureReferences == null ? null : new ArrayList<FeatureReferenceModel>(Arrays.asList(featureReferences));
    }

    public void setArchiveReferenceModels(ArchiveReferenceModel[] archiveReferences) {
        this.assertIsWriteable();
        this.archiveReferences = archiveReferences == null ? null : new ArrayList<ArchiveReferenceModel>(Arrays.asList(archiveReferences));
    }

    public void setCategoryModels(CategoryModel[] categories) {
        this.assertIsWriteable();
        if (categories == null) {
            this.categories = null;
        } else {
            this.categories = new TreeSet(CategoryModel.getComparator());
            this.categories.addAll(Arrays.asList(categories));
        }
    }

    public void setLocationURLString(String locationURLString) {
        this.assertIsWriteable();
        this.locationURLString = locationURLString;
    }

    public void addFeatureReferenceModel(SiteFeatureReferenceModel featureReference) {
        this.assertIsWriteable();
        if (this.featureReferences == null) {
            this.featureReferences = new ArrayList();
        }
        this.featureReferences.add(featureReference);
    }

    public void addArchiveReferenceModel(ArchiveReferenceModel archiveReference) {
        this.assertIsWriteable();
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList();
        }
        if (!this.archiveReferences.contains((Object)archiveReference)) {
            this.archiveReferences.add(archiveReference);
        }
    }

    public void addCategoryModel(CategoryModel category) {
        this.assertIsWriteable();
        if (this.categories == null) {
            this.categories = new TreeSet(CategoryModel.getComparator());
        }
        if (!this.categories.contains((Object)category)) {
            this.categories.add(category);
        }
    }

    public void removeFeatureReferenceModel(FeatureReferenceModel featureReference) {
        this.assertIsWriteable();
        if (this.featureReferences != null) {
            this.featureReferences.remove((Object)featureReference);
        }
    }

    public void removeArchiveReferenceModel(ArchiveReferenceModel archiveReference) {
        this.assertIsWriteable();
        if (this.archiveReferences != null) {
            this.archiveReferences.remove((Object)archiveReference);
        }
    }

    public void removeCategoryModel(CategoryModel category) {
        this.assertIsWriteable();
        if (this.categories != null) {
            this.categories.remove((Object)category);
        }
    }

    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
        this.markListReferenceReadOnly(this.getFeatureReferenceModels());
        this.markListReferenceReadOnly(this.getArchiveReferenceModels());
        this.markListReferenceReadOnly(this.getCategoryModels());
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.locationURL = this.resolveURL(base, bundleURL, this.getLocationURLString());
        if (this.locationURL == null) {
            this.locationURL = base;
        }
        this.resolveListReference(this.getFeatureReferenceModels(), this.locationURL, bundleURL);
        this.resolveListReference(this.getArchiveReferenceModels(), this.locationURL, bundleURL);
        this.resolveReference(this.getDescriptionModel(), base, bundleURL);
        this.resolveListReference(this.getCategoryModels(), base, bundleURL);
    }

    public ConfiguredSiteModel getConfiguredSiteModel() {
        return this.configuredSiteModel;
    }

    public void setConfiguredSiteModel(ConfiguredSiteModel configuredSiteModel) {
        this.configuredSiteModel = configuredSiteModel;
    }

    protected String getPropertyName() {
        return "site";
    }
}

