/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.FeatureReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public class IncludedFeatureReference
extends IncludedFeatureReferenceModel
implements IIncludedFeatureReference {
    private IFeature bestMatchFeature;

    public IncludedFeatureReference() {
    }

    public IncludedFeatureReference(IIncludedFeatureReference includedFeatureRef) {
        super((IncludedFeatureReferenceModel)((Object)includedFeatureRef));
    }

    public IncludedFeatureReference(IFeatureReference featureReference) {
        super(featureReference);
    }

    private boolean matches(VersionedIdentifier baseIdentifier, VersionedIdentifier id) {
        if (baseIdentifier == null || id == null) {
            return false;
        }
        if (!id.getIdentifier().equals(baseIdentifier.getIdentifier())) {
            return false;
        }
        switch (this.getMatch()) {
            case 1: {
                return id.getVersion().isPerfect(baseIdentifier.getVersion());
            }
            case 3: {
                return id.getVersion().isCompatibleWith(baseIdentifier.getVersion());
            }
            case 2: {
                return id.getVersion().isEquivalentTo(baseIdentifier.getVersion());
            }
            case 4: {
                return id.getVersion().isGreaterOrEqualTo(baseIdentifier.getVersion());
            }
        }
        UpdateCore.warn("Unknown matching rule:" + this.getMatch());
        return false;
    }

    private boolean isDisabled() {
        IConfiguredSite cSite = this.getSite().getCurrentConfiguredSite();
        if (cSite == null) {
            return false;
        }
        IFeatureReference[] configured = cSite.getConfiguredFeatures();
        int i = 0;
        while (i < configured.length) {
            if (this.equals(configured[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isUninstalled() {
        if (!this.isDisabled()) {
            return false;
        }
        ISiteFeatureReference[] installed = this.getSite().getFeatureReferences();
        int i = 0;
        while (i < installed.length) {
            if (this.equals(installed[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IFeature getFeature(boolean perfectMatch, IConfiguredSite configuredSite) throws CoreException {
        return this.getFeature(perfectMatch, configuredSite, null);
    }

    public IFeature getFeature(boolean perfectMatch, IConfiguredSite configuredSite, IProgressMonitor monitor) throws CoreException {
        if (perfectMatch || this.getMatch() == 1 || this.isDisabled()) {
            if (this.isUninstalled()) {
                throw new CoreException((IStatus)new Status(4, UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier(), 0, Policy.bind("IncludedFeatureReference.featureUninstalled", this.getFeatureIdentifier()), null));
            }
            return super.getFeature(monitor);
        }
        if (this.bestMatchFeature == null) {
            if (configuredSite == null) {
                configuredSite = this.getSite().getCurrentConfiguredSite();
            }
            IIncludedFeatureReference bestMatchReference = this.getBestMatch(configuredSite);
            IFeature localBestMatchFeature = this.getFeature(bestMatchReference, monitor);
            if (configuredSite == null) {
                return localBestMatchFeature;
            }
            this.bestMatchFeature = localBestMatchFeature;
        }
        return this.bestMatchFeature;
    }

    private IIncludedFeatureReference getBestMatch(IConfiguredSite configuredSite) throws CoreException {
        FeatureReference newRef = null;
        if (configuredSite == null) {
            return this;
        }
        IFeatureReference[] enabledFeatures = configuredSite.getConfiguredFeatures();
        int ref = 0;
        while (ref < enabledFeatures.length) {
            if (enabledFeatures[ref] != null) {
                VersionedIdentifier id = enabledFeatures[ref].getVersionedIdentifier();
                if (this.matches(this.getVersionedIdentifier(), id) && (newRef == null || id.getVersion().isGreaterThan(newRef.getVersionedIdentifier().getVersion()))) {
                    newRef = new IncludedFeatureReference(enabledFeatures[ref]);
                    ((IncludedFeatureReferenceModel)newRef).setMatchingRule(this.getMatch());
                    ((IncludedFeatureReferenceModel)newRef).isOptional(this.isOptional());
                    newRef.setLabel(this.getLabel());
                }
            }
            ++ref;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
            UpdateCore.warn("Found best match feature:" + newRef + " for feature reference " + this.getURLString());
        }
        if (newRef != null) {
            return newRef;
        }
        return this;
    }

    public IFeature getFeature() throws CoreException {
        return this.getFeature(null);
    }

    public IFeature getFeature(IProgressMonitor monitor) throws CoreException {
        return this.getFeature(false, null, monitor);
    }
}

