/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class Feature
extends FeatureModel
implements IFeature {
    public static final String FEATURE_FILE = "feature";
    public static final String FEATURE_XML = "feature.xml";
    private ISite site;
    private IFeatureContentProvider featureContentProvider;
    private List includedFeatureReferences;
    private VersionedIdentifier versionId;
    private InstallAbortedException abortedException = null;

    public boolean equals(Object object) {
        if (!(object instanceof IFeature)) {
            return false;
        }
        IFeature f = (IFeature)object;
        return this.getVersionedIdentifier().equals(f.getVersionedIdentifier());
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String id = this.getFeatureIdentifier();
        String ver = this.getFeatureVersion();
        if (id != null && ver != null) {
            try {
                this.versionId = new VersionedIdentifier(id, ver);
                return this.versionId;
            }
            catch (Exception exception) {
                UpdateCore.warn("Unable to create versioned identifier:" + id + ":" + ver);
            }
        }
        this.versionId = new VersionedIdentifier(this.getURL().toExternalForm(), null);
        return this.versionId;
    }

    public ISite getSite() {
        return this.site;
    }

    public URL getURL() {
        IFeatureContentProvider contentProvider = null;
        try {
            contentProvider = this.getFeatureContentProvider();
        }
        catch (CoreException e) {
            UpdateCore.warn("No content Provider", e);
        }
        return contentProvider != null ? contentProvider.getURL() : null;
    }

    public IURLEntry getUpdateSiteEntry() {
        return (IURLEntry)((Object)this.getUpdateSiteEntryModel());
    }

    public IURLEntry[] getDiscoverySiteEntries() {
        URLEntryModel[] result = this.getDiscoverySiteEntryModels();
        if (result.length == 0) {
            return new IURLEntry[0];
        }
        return (IURLEntry[])result;
    }

    public IInstallHandlerEntry getInstallHandlerEntry() {
        return (IInstallHandlerEntry)((Object)this.getInstallHandlerModel());
    }

    public IURLEntry getDescription() {
        return (IURLEntry)((Object)this.getDescriptionModel());
    }

    public IURLEntry getCopyright() {
        return (IURLEntry)((Object)this.getCopyrightModel());
    }

    public IURLEntry getLicense() {
        return (IURLEntry)((Object)this.getLicenseModel());
    }

    public URL getImage() {
        return this.getImageURL();
    }

    public IImport[] getRawImports() {
        ImportModel[] result = this.getImportModels();
        if (result.length == 0) {
            return new IImport[0];
        }
        return (IImport[])result;
    }

    public IFeatureReference install(IFeature targetFeature, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        return this.install(targetFeature, null, verificationListener, progress);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFeatureReference install(IFeature targetFeature, IFeatureReference[] optionalfeatures, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        block45: {
            this.debug("Installing...:" + this.getURL().toExternalForm());
            recoveryLog = ErrorRecoveryLog.getLog();
            monitor = progress == null ? new InstallMonitor((IProgressMonitor)new NullProgressMonitor()) : (progress instanceof InstallMonitor != false ? (InstallMonitor)progress : new InstallMonitor(progress));
            handler = new InstallHandlerProxy(1, this, this.getInstallHandlerEntry(), monitor);
            success = false;
            originalException = null;
            this.abortedException = null;
            provider = this.getFeatureContentProvider();
            verifier = provider.getVerifier();
            result = null;
            alreadyInstalledFeature = null;
            consumer = null;
            targetSitePluginEntries = null;
            try {
                try {
                    block43: {
                        block42: {
                            sourceFeaturePluginEntries = this.getPluginEntries();
                            targetSite = targetFeature.getSite();
                            if (targetSite == null) {
                                this.debug("The site to install in is null");
                                targetSitePluginEntries = new IPluginEntry[]{};
                            } else {
                                targetSitePluginEntries = targetSite.getPluginEntries();
                            }
                            pluginsToInstall = UpdateManagerUtils.diff(sourceFeaturePluginEntries, targetSitePluginEntries);
                            nonPluginsToInstall = this.getNonPluginEntries();
                            children = this.getIncludedFeatureReferences();
                            if (optionalfeatures != null) {
                                children = UpdateManagerUtils.optionalChildrenToInstall(children, optionalfeatures);
                            }
                            taskCount = 2 + 2 * pluginsToInstall.length + nonPluginsToInstall.length + 1 + 5 * children.length;
                            monitor.beginTask("", taskCount);
                            subMonitor = null;
                            recoveryLog.open("START_INSTALL_LOG");
                            handler.installInitiated();
                            references = provider.getFeatureEntryArchiveReferences(monitor);
                            this.verifyReferences(verifier, references, monitor, verificationListener, true);
                            this.monitorWork(monitor, 1);
                            i = 0;
                            while (true) {
                                if (i >= pluginsToInstall.length) break;
                                references = provider.getPluginEntryArchiveReferences(pluginsToInstall[i], monitor);
                                this.verifyReferences(verifier, references, monitor, verificationListener, false);
                                this.monitorWork(monitor, 1);
                                ++i;
                            }
                            handler.pluginsDownloaded(pluginsToInstall);
                            i = 0;
                            while (true) {
                                if (i >= nonPluginsToInstall.length) break;
                                references = provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i], monitor);
                                this.monitorWork(monitor, 1);
                                ++i;
                            }
                            handler.nonPluginDataDownloaded(nonPluginsToInstall, verificationListener);
                            consumer = targetFeature.getFeatureContentConsumer();
                            i = 0;
                            while (true) {
                                if (i >= children.length) break;
                                childFeature = null;
                                try {
                                    childFeature = children[i].getFeature(null);
                                }
                                catch (CoreException e) {
                                    UpdateCore.warn(null, e);
                                }
                                if (childFeature != null) {
                                    subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 5);
                                    ((Site)targetSite).install(childFeature, optionalfeatures, consumer, verifier, verificationListener, (IProgressMonitor)subMonitor);
                                }
                                ++i;
                            }
                            i = 0;
                            while (true) {
                                if (i >= pluginsToInstall.length) {
                                    alreadyInstalledFeature = this.featureAlreadyInstalled(targetSite);
                                    if (alreadyInstalledFeature == null) {
                                        break;
                                    }
                                    break block42;
                                }
                                if (InstallRegistry.getInstance().isPluginJustInstalled(pluginsToInstall[i])) {
                                    monitor.worked(1);
                                } else {
                                    references = provider.getPluginEntryContentReferences(pluginsToInstall[i], monitor);
                                    pluginConsumer = consumer.open(pluginsToInstall[i]);
                                    msg = "";
                                    subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
                                    pluginVerId = pluginsToInstall[i].getVersionedIdentifier();
                                    pluginID = pluginVerId == null ? "" : pluginVerId.getIdentifier();
                                    msg = Policy.bind("Feature.TaskInstallPluginFiles", pluginID);
                                    j = 0;
                                    while (true) {
                                        if (j >= references.length) {
                                            InstallRegistry.registerPlugin(pluginsToInstall[i]);
                                            if (!monitor.isCanceled()) break;
                                            this.abort();
                                            break;
                                        }
                                        this.setMonitorTaskName((IProgressMonitor)subMonitor, String.valueOf(msg) + references[j].getIdentifier());
                                        pluginConsumer.store(references[j], (IProgressMonitor)subMonitor);
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                            references = provider.getFeatureEntryContentReferences(monitor);
                            msg = "";
                            subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
                            msg = Policy.bind("Feature.TaskInstallFeatureFiles");
                            i = 0;
                            while (true) {
                                if (i >= references.length) {
                                    InstallRegistry.registerFeature(this);
                                    break block43;
                                }
                                this.setMonitorTaskName((IProgressMonitor)subMonitor, String.valueOf(msg) + " " + references[i].getIdentifier());
                                consumer.store(references[i], (IProgressMonitor)subMonitor);
                                ++i;
                            }
                        }
                        monitor.worked(1);
                    }
                    if (monitor.isCanceled()) {
                        this.abort();
                    }
                    handler.completeInstall(consumer);
                    this.monitorWork(monitor, 1);
                    success = true;
                }
                catch (InstallAbortedException e) {
                    this.abortedException = e;
                }
                catch (CoreException e) {
                    originalException = e;
                }
            }
            catch (Throwable var31_35) {
                var30_36 = null;
                newException = null;
                try {
                    if (consumer != null) {
                        if (success) {
                            result = consumer.close();
                            if (result == null && (result = alreadyInstalledFeature) != null && optionalfeatures != null && optionalfeatures.length > 0) {
                                this.reinitializeFeature(result);
                            }
                            recoveryLog.close("END_INSTALL_LOG");
                        } else {
                            consumer.abort();
                        }
                    }
                    handler.installCompleted(success);
                    recoveryLog.delete();
                }
                catch (CoreException e) {
                    newException = e;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), newException);
                }
                if (this.abortedException != null) {
                    throw this.abortedException;
                }
                throw var31_35;
            }
            {
                var30_37 = null;
                newException = null;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 891->972)] { 
lbl156:
            // 1 sources

            if (consumer != null) {
                if (success) {
                    result = consumer.close();
                    if (result == null && (result = alreadyInstalledFeature) != null && optionalfeatures != null && optionalfeatures.length > 0) {
                        this.reinitializeFeature(result);
                    }
                    recoveryLog.close("END_INSTALL_LOG");
                } else {
                    consumer.abort();
                }
            }
            handler.installCompleted(success);
            recoveryLog.delete();
            break block45;
lbl167:
            // 1 sources

            catch (CoreException e) {
                newException = e;
            }
        }
        if (originalException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), newException);
        }
        if (this.abortedException != null) {
            throw this.abortedException;
        }
        return result;
    }

    public IPluginEntry[] getRawPluginEntries() {
        PluginEntryModel[] result = this.getPluginEntryModels();
        if (result.length == 0) {
            return new IPluginEntry[0];
        }
        return (IPluginEntry[])result;
    }

    private IPluginEntry[] filterPluginEntry(IPluginEntry[] all) {
        ArrayList<IPluginEntry> list = new ArrayList<IPluginEntry>();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (UpdateManagerUtils.isValidEnvironment(all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
        }
        IPluginEntry[] result = new IPluginEntry[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    public INonPluginEntry[] getRawNonPluginEntries() {
        NonPluginEntryModel[] result = this.getNonPluginEntryModels();
        if (result.length == 0) {
            return new INonPluginEntry[0];
        }
        return (INonPluginEntry[])result;
    }

    public int getNonPluginEntryCount() {
        return this.getNonPluginEntryModels().length;
    }

    public IIncludedFeatureReference[] getRawIncludedFeatureReferences() throws CoreException {
        if (this.includedFeatureReferences == null) {
            this.initializeIncludedReferences();
        }
        if (this.includedFeatureReferences.size() == 0) {
            return new IncludedFeatureReference[0];
        }
        return (IIncludedFeatureReference[])this.includedFeatureReferences.toArray(this.arrayTypeFor(this.includedFeatureReferences));
    }

    public long getDownloadSize() {
        try {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IIncludedFeatureReference[] children = this.getIncludedFeatureReferences();
            int i = 0;
            while (i < children.length) {
                plugins = children[i].getFeature(null).getPluginEntries();
                allPluginEntries.addAll(Arrays.asList(plugins));
                nonPlugins = children[i].getFeature(null).getNonPluginEntries();
                allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
                ++i;
            }
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            return this.getFeatureContentProvider().getDownloadSizeFor(totalPlugins, totalNonPlugins);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return -1L;
        }
    }

    public long getInstallSize() {
        try {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IIncludedFeatureReference[] children = this.getIncludedFeatureReferences();
            int i = 0;
            while (i < children.length) {
                plugins = children[i].getFeature(null).getPluginEntries();
                allPluginEntries.addAll(Arrays.asList(plugins));
                nonPlugins = children[i].getFeature(null).getNonPluginEntries();
                allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
                ++i;
            }
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            return this.getFeatureContentProvider().getInstallSizeFor(totalPlugins, totalNonPlugins);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return -1L;
        }
    }

    public IFeatureContentProvider getFeatureContentProvider() throws CoreException {
        if (this.featureContentProvider == null) {
            throw Utilities.newCoreException(Policy.bind("Feature.NoContentProvider", this.getVersionedIdentifier().toString()), null);
        }
        return this.featureContentProvider;
    }

    public IFeatureContentConsumer getFeatureContentConsumer() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSite(ISite site) throws CoreException {
        if (this.site != null) {
            String featureURLString = this.getURL() != null ? this.getURL().toExternalForm() : "";
            throw Utilities.newCoreException(Policy.bind("Feature.SiteAlreadySet", featureURLString), null);
        }
        this.site = site;
    }

    public void setFeatureContentProvider(IFeatureContentProvider featureContentProvider) {
        this.featureContentProvider = featureContentProvider;
        featureContentProvider.setFeature(this);
    }

    public String toString() {
        String URLString = this.getURL() == null ? Policy.bind("Feature.NoURL") : this.getURL().toExternalForm();
        String verString = Policy.bind("Feature.FeatureVersionToString", URLString, this.getVersionedIdentifier().toString());
        String label = this.getLabel() == null ? "" : this.getLabel();
        return String.valueOf(verString) + " [" + label + "]";
    }

    private void abort() throws CoreException {
        String msg = Policy.bind("Feature.InstallationCancelled");
        throw new InstallAbortedException(msg, null);
    }

    private void initializeIncludedReferences() throws CoreException {
        this.includedFeatureReferences = new ArrayList();
        IIncludedFeatureReference[] nestedFeatures = this.getFeatureIncluded();
        if (nestedFeatures.length == 0) {
            return;
        }
        ISite site = this.getSite();
        if (site == null) {
            return;
        }
        int i = 0;
        while (i < nestedFeatures.length) {
            IIncludedFeatureReference include = nestedFeatures[i];
            IIncludedFeatureReference newRef = this.getPerfectIncludeFeature(site, include);
            this.includedFeatureReferences.add(newRef);
            ++i;
        }
    }

    private IIncludedFeatureReference getPerfectIncludeFeature(ISite site, IIncludedFeatureReference include) throws CoreException {
        ISiteFeatureReference[] refs = site.getFeatureReferences();
        VersionedIdentifier identifier = include.getVersionedIdentifier();
        if ("file".equals(site.getURL().getProtocol()) && refs != null) {
            int ref = 0;
            while (ref < refs.length) {
                VersionedIdentifier id;
                if (refs[ref] != null && identifier.equals(id = refs[ref].getVersionedIdentifier())) {
                    IncludedFeatureReference newRef = new IncludedFeatureReference(refs[ref]);
                    newRef.isOptional(include.isOptional());
                    if (include instanceof FeatureReferenceModel) {
                        newRef.setLabel(((FeatureReferenceModel)((Object)include)).getLabel());
                    }
                    newRef.setMatchingRule(include.getMatch());
                    newRef.setSearchLocation(include.getSearchLocation());
                    return newRef;
                }
                ++ref;
            }
        }
        IncludedFeatureReference newRef = new IncludedFeatureReference(include);
        newRef.setSite(this.getSite());
        ISiteFeatureReference parentRef = this.getSite().getFeatureReference(this);
        if (parentRef instanceof FeatureReference) {
            newRef.setType(((FeatureReference)((Object)parentRef)).getType());
        }
        String featureID = "features/" + identifier.toString() + ".jar";
        URL featureURL = this.getSite().getSiteContentProvider().getArchiveReference(featureID);
        newRef.setURL(featureURL);
        newRef.setFeatureIdentifier(identifier.getIdentifier());
        newRef.setFeatureVersion(identifier.getVersion().toString());
        try {
            newRef.resolve(this.getSite().getURL(), null);
            return newRef;
        }
        catch (Exception e) {
            throw Utilities.newCoreException(Policy.bind("Feature.UnableToInitializeFeatureReference", identifier.toString()), e);
        }
    }

    private void debug(String trace) {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
            UpdateCore.debug(trace);
        }
    }

    private void setMonitorTaskName(IProgressMonitor monitor, String taskName) {
        if (monitor != null) {
            monitor.setTaskName(taskName);
        }
    }

    private void monitorWork(IProgressMonitor monitor, int tick) throws CoreException {
        if (monitor != null) {
            monitor.worked(tick);
            if (monitor.isCanceled()) {
                this.abort();
            }
        }
    }

    private void verifyReferences(IVerifier verifier, ContentReference[] references, InstallMonitor monitor, IVerificationListener verificationListener, boolean isFeature) throws CoreException {
        IVerificationResult vr = null;
        if (verifier != null) {
            int j = 0;
            while (j < references.length) {
                vr = verifier.verify(this, references[j], isFeature, monitor);
                if (vr != null) {
                    if (verificationListener == null) {
                        return;
                    }
                    int result = verificationListener.prompt(vr);
                    if (result == 0) {
                        String msg = Policy.bind("JarVerificationService.CancelInstall");
                        Exception e = vr.getVerificationException();
                        throw new InstallAbortedException(msg, e);
                    }
                    if (result == 1) {
                        throw Utilities.newCoreException(Policy.bind("JarVerificationService.UnsucessfulVerification"), vr.getVerificationException());
                    }
                }
                ++j;
            }
        }
    }

    private IFeatureReference featureAlreadyInstalled(ISite targetSite) {
        ISiteFeatureReference[] references = targetSite.getFeatureReferences();
        ISiteFeatureReference currentReference = null;
        int i = 0;
        while (i < references.length) {
            currentReference = references[i];
            try {
                if (this.equals(currentReference.getFeature(null))) {
                    return currentReference;
                }
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            ++i;
        }
        UpdateCore.warn("ValidateAlreadyInstalled:Feature " + this + " not found on site:" + this.getURL());
        return null;
    }

    private void reinitializeFeature(IFeatureReference referenceToReinitialize) {
        if (referenceToReinitialize == null) {
            return;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.debug("Re initialize feature reference:" + referenceToReinitialize);
        }
        IFeature feature = null;
        try {
            ISite site;
            feature = referenceToReinitialize.getFeature(null);
            if (feature != null && feature instanceof Feature) {
                ((Feature)feature).initializeIncludedReferences();
            }
            if ((site = referenceToReinitialize.getSite()) == null) {
                return;
            }
            URL url = site.getURL();
            if (url == null) {
                return;
            }
            if ("file".equals(url.getProtocol())) {
                IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
                int i = 0;
                while (i < included.length) {
                    this.reinitializeFeature(included[i]);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
        }
    }

    public IIncludedFeatureReference[] getIncludedFeatureReferences() throws CoreException {
        return this.filterFeatures(this.getRawIncludedFeatureReferences());
    }

    private IIncludedFeatureReference[] filterFeatures(IIncludedFeatureReference[] allIncluded) {
        ArrayList<IIncludedFeatureReference> list = new ArrayList<IIncludedFeatureReference>();
        if (allIncluded != null) {
            int i = 0;
            while (i < allIncluded.length) {
                IIncludedFeatureReference included = allIncluded[i];
                if (UpdateManagerUtils.isValidEnvironment(included)) {
                    list.add(included);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + included);
                }
                ++i;
            }
        }
        IIncludedFeatureReference[] result = new IIncludedFeatureReference[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public INonPluginEntry[] getNonPluginEntries() {
        return this.filterNonPluginEntry(this.getRawNonPluginEntries());
    }

    private INonPluginEntry[] filterNonPluginEntry(INonPluginEntry[] all) {
        ArrayList<INonPluginEntry> list = new ArrayList<INonPluginEntry>();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (UpdateManagerUtils.isValidEnvironment(all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
        }
        INonPluginEntry[] result = new INonPluginEntry[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public IPluginEntry[] getPluginEntries() {
        return this.filterPluginEntry(this.getRawPluginEntries());
    }

    public IImport[] getImports() {
        return this.filterImports(this.getRawImports());
    }

    private IImport[] filterImports(IImport[] all) {
        ArrayList<IImport> list = new ArrayList<IImport>();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (UpdateManagerUtils.isValidEnvironment(all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
        }
        IImport[] result = new IImport[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }
}

