/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.site.SiteBuild;
import org.eclipse.pde.internal.core.site.SiteBuildFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSiteBuildModel
extends AbstractModel
implements ISiteBuildModel {
    protected transient SiteBuild siteBuild;

    public ISiteBuild getSiteBuild() {
        if (this.siteBuild == null) {
            SiteBuild s = new SiteBuild();
            s.model = this;
            this.siteBuild = s;
        }
        return this.siteBuild;
    }

    public ISiteBuild createSiteBuild() {
        SiteBuild s = new SiteBuild();
        s.model = this;
        s.parent = null;
        return s;
    }

    public ISiteBuildFeature createFeature() {
        SiteBuildFeature f = new SiteBuildFeature();
        f.model = this;
        f.parent = this.getSiteBuild();
        return f;
    }

    public String getInstallLocation() {
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void load(InputStream stream, boolean outOfSync) throws CoreException {
        try {
            SAXParser parser = this.getSaxParser();
            XMLDefaultHandler handler = new XMLDefaultHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(stream, (DefaultHandler)handler);
            this.processDocument(handler.getDocument());
            this.loaded = true;
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (Exception e) {
            this.throwParseErrorsException(e);
        }
    }

    private void processDocument(Document doc) {
        Element rootNode = doc.getDocumentElement();
        if (this.siteBuild == null) {
            this.siteBuild = new SiteBuild();
            this.siteBuild.model = this;
        } else {
            this.siteBuild.reset();
        }
        this.siteBuild.parse(rootNode);
    }

    public void reload(InputStream stream, boolean outOfSync) throws CoreException {
        if (this.siteBuild != null) {
            this.siteBuild.reset();
        }
        this.load(stream, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(99, new Object[]{this.siteBuild}, null));
    }

    public boolean isReconcilingModel() {
        return false;
    }
}

