/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;

public class PluginSearchScope {
    public static final int SCOPE_WORKSPACE = 0;
    public static final int SCOPE_SELECTION = 1;
    public static final int SCOPE_WORKING_SETS = 2;
    public static final int EXTERNAL_SCOPE_NONE = 0;
    public static final int EXTERNAL_SCOPE_ENABLED = 1;
    public static final int EXTERNAL_SCOPE_ALL = 2;
    private int workspaceScope;
    private int externalScope;
    private HashSet selectedResources;

    public PluginSearchScope(int workspaceScope, int externalScope, HashSet selectedResources) {
        this.workspaceScope = workspaceScope;
        this.externalScope = externalScope;
        this.selectedResources = selectedResources;
    }

    public PluginSearchScope() {
        this(0, 1, null);
    }

    private void addExternalModel(IPluginModelBase candidate, ArrayList result) {
        if (this.externalScope == 2) {
            result.add(candidate);
        } else if (this.externalScope == 1 && candidate.isEnabled()) {
            result.add(candidate);
        }
    }

    private void addWorkspaceModel(IPluginModelBase candidate, ArrayList result) {
        if (this.workspaceScope == 0) {
            result.add(candidate);
        } else if (this.selectedResources.contains(candidate.getUnderlyingResource())) {
            result.add(candidate);
        }
    }

    public IPluginModelBase[] getMatchingModels() {
        ArrayList result = new ArrayList();
        PluginModelManager modelManager = PDECore.getDefault().getModelManager();
        ModelEntry[] entries = modelManager.getEntries();
        int i = 0;
        while (i < entries.length) {
            IPluginModelBase candidate = entries[i].getActiveModel();
            if (candidate instanceof WorkspacePluginModelBase) {
                this.addWorkspaceModel(candidate, result);
            } else {
                this.addExternalModel(candidate, result);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }
}

