/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.net.URL;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;

public abstract class AbstractSchemaDescriptor
implements ISchemaDescriptor {
    protected Schema schema;

    protected Schema createSchema() {
        URL url = this.getSchemaURL();
        if (url == null) {
            return null;
        }
        return new Schema(this, url);
    }

    public void dispose() {
        if (this.schema != null && !this.schema.isDisposed()) {
            this.schema.dispose();
        }
        this.schema = null;
    }

    public ISchema getSchema() {
        if (this.schema == null) {
            this.loadSchema();
        }
        return this.schema;
    }

    protected void loadSchema() {
        this.schema = this.createSchema();
        if (this.schema != null) {
            this.schema.load();
        }
    }

    public void reload() {
        if (this.schema != null) {
            this.schema.reload();
        }
    }

    public abstract boolean isEnabled();
}

